/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining.veinmining;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ResourceLocation;
import top.theillusivec4.veinmining.config.VeinMiningConfig;

public class VeinMiningEnchantment
extends Enchantment {
    public static final String ID = "veinmining:vein_mining";
    public static final EnchantmentType TYPE = EnchantmentType.create((String)"veinmining:vein_mining", VeinMiningEnchantment::canEnchantItem);
    public static final Map<String, Predicate<Item>> PREDICATE_MAP;

    public VeinMiningEnchantment() {
        super(Enchantment.Rarity.RARE, TYPE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    private static boolean canEnchantItem(Item item) {
        for (String entry : VeinMiningConfig.Enchantment.items) {
            if (PREDICATE_MAP.getOrDefault(entry, k -> false).test(item)) {
                return true;
            }
            if (item.getRegistryName() == null || !item.getRegistryName().toString().equals(entry)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Enchantment.Rarity func_77324_c() {
        return VeinMiningConfig.Enchantment.rarity;
    }

    public int func_77325_b() {
        return VeinMiningConfig.Enchantment.levels;
    }

    public int func_77321_a(int enchantmentLevel) {
        return VeinMiningConfig.Enchantment.minEnchantabilityBase + VeinMiningConfig.Enchantment.minEnchantabilityPerLevel * (enchantmentLevel - 1);
    }

    public int func_223551_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 50;
    }

    public boolean func_185261_e() {
        return VeinMiningConfig.Enchantment.isTreasure;
    }

    public boolean func_230309_h_() {
        return VeinMiningConfig.Enchantment.isVillagerTrade;
    }

    public boolean func_230310_i_() {
        return VeinMiningConfig.Enchantment.isLootable;
    }

    protected boolean func_77326_a(Enchantment ench) {
        ResourceLocation rl = ench.getRegistryName();
        if (rl != null && VeinMiningConfig.Enchantment.incompatibleEnchantments.contains(rl.toString())) {
            return false;
        }
        return super.func_77326_a(ench);
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack) {
        return super.canApplyAtEnchantingTable(stack) && VeinMiningConfig.Enchantment.canApplyAtEnchantingTable;
    }

    public boolean isAllowedOnBooks() {
        return VeinMiningConfig.Enchantment.canApplyOnBooks;
    }

    static {
        HashMap<String, Predicate<Item>> temp = new HashMap<String, Predicate<Item>>();
        temp.put("is:tool", item -> item instanceof ToolItem);
        temp.put("is:pickaxe", item -> item instanceof PickaxeItem);
        temp.put("is:axe", item -> item instanceof AxeItem);
        temp.put("is:hoe", item -> item instanceof HoeItem);
        temp.put("is:shovel", item -> item instanceof ShovelItem);
        PREDICATE_MAP = ImmutableMap.copyOf(temp);
    }
}

