/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining.veinmining.logic;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import top.theillusivec4.veinmining.VeinMiningMod;
import top.theillusivec4.veinmining.config.VeinMiningConfig;
import top.theillusivec4.veinmining.veinmining.VeinMiningPlayers;
import top.theillusivec4.veinmining.veinmining.logic.BlockProcessor;

public class VeinMiningLogic {
    private static final Direction[] CARDINAL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH};

    public static void startVeinMining(ServerPlayerEntity playerEntity, BlockPos pos, Block source) {
        boolean ineffective;
        ServerWorld world = playerEntity.func_71121_q();
        ItemStack stack = playerEntity.func_184614_ca();
        if (!VeinMiningPlayers.canVeinMine((PlayerEntity)playerEntity)) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        boolean bl = ineffective = VeinMiningConfig.VeinMining.requireEffectiveTool && !ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)playerEntity, (IBlockReader)world, (BlockPos)pos);
        if (ineffective) {
            return;
        }
        int veiningLevels = EnchantmentHelper.func_77506_a((Enchantment)VeinMiningMod.VEIN_MINING, (ItemStack)stack);
        int maxBlocks = VeinMiningConfig.VeinMining.maxBlocksBase + VeinMiningConfig.VeinMining.maxBlocksPerLevel * veiningLevels;
        int maxDistance = VeinMiningConfig.VeinMining.maxDistanceBase + VeinMiningConfig.VeinMining.maxDistancePerLevel * veiningLevels;
        if (maxBlocks <= 0 || maxDistance <= 0) {
            return;
        }
        int blocks = 0;
        HashSet visited = Sets.newHashSet((Object[])new BlockPos[]{pos});
        LinkedList<Tuple<BlockPos, Integer>> candidates = new LinkedList<Tuple<BlockPos, Integer>>();
        VeinMiningLogic.addValidNeighbors(candidates, pos, 1);
        while (!candidates.isEmpty() && blocks < maxBlocks) {
            Tuple<BlockPos, Integer> candidate = candidates.poll();
            BlockPos blockPos = (BlockPos)candidate.func_76341_a();
            int blockDistance = (Integer)candidate.func_76340_b();
            if (VeinMiningLogic.stopVeining(stack)) {
                return;
            }
            BlockState blockState = world.func_180495_p(blockPos);
            if (!visited.add(blockPos) || !BlockProcessor.isValidTarget(blockState, (World)world, blockPos, source) || !VeinMiningLogic.harvest(playerEntity, blockPos, pos)) continue;
            if (blockDistance < maxDistance) {
                VeinMiningLogic.addValidNeighbors(candidates, blockPos, blockDistance + 1);
            }
            ++blocks;
        }
    }

    private static boolean stopVeining(ItemStack stack) {
        return VeinMiningConfig.VeinMining.limitedByDurability && (stack.func_77952_i() == stack.func_77958_k() || VeinMiningConfig.VeinMining.preventToolDestruction && stack.func_77952_i() == stack.func_77958_k() - 1);
    }

    private static void addValidNeighbors(LinkedList<Tuple<BlockPos, Integer>> candidates, BlockPos source, int distance) {
        if (VeinMiningConfig.VeinMining.diagonalMining) {
            BlockPos[] blockPositions;
            BlockPos up = source.func_177984_a();
            BlockPos down = source.func_177977_b();
            candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)up, (Object)distance));
            candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)down, (Object)distance));
            for (BlockPos blockPos : blockPositions = new BlockPos[]{up, down, source}) {
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.func_177976_e(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.func_177974_f(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.func_177978_c(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.func_177968_d(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.func_177978_c().func_177976_e(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.func_177978_c().func_177974_f(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.func_177968_d().func_177976_e(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.func_177968_d().func_177974_f(), (Object)distance));
            }
        } else {
            for (Direction direction : CARDINAL_DIRECTIONS) {
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)source.func_177972_a(direction), (Object)distance));
            }
        }
    }

    public static boolean harvest(ServerPlayerEntity player, BlockPos pos, BlockPos originPos) {
        ServerWorld world = player.func_71121_q();
        BlockState blockstate = world.func_180495_p(pos);
        GameType gameType = player.field_71134_c.func_73081_b();
        int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)gameType, (ServerPlayerEntity)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        Block block = blockstate.func_177230_c();
        if ((block instanceof CommandBlockBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !player.func_195070_dx()) {
            world.func_184138_a(pos, blockstate, blockstate, 3);
            return false;
        }
        if (player.func_184614_ca().onBlockStartBreak(pos, (PlayerEntity)player)) {
            return false;
        }
        if (player.func_223729_a((World)world, pos, gameType)) {
            return false;
        }
        if (gameType.func_77145_d()) {
            VeinMiningLogic.removeBlock((PlayerEntity)player, pos, false);
        } else {
            BlockPos spawnPos;
            ItemStack itemstack = player.func_184614_ca();
            ItemStack itemstack1 = itemstack.func_77946_l();
            boolean flag1 = blockstate.canHarvestBlock((IBlockReader)world, pos, (PlayerEntity)player);
            if (VeinMiningConfig.VeinMining.addToolDamage) {
                VeinMiningLogic.onBlockDestroyed(itemstack, (World)world, blockstate, pos, (PlayerEntity)player);
            }
            if (itemstack.func_190926_b() && !itemstack1.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)itemstack1, (Hand)Hand.MAIN_HAND);
            }
            boolean flag = VeinMiningLogic.removeBlock((PlayerEntity)player, pos, flag1);
            BlockPos blockPos = spawnPos = VeinMiningConfig.VeinMining.relocateDrops ? originPos : pos;
            if (flag && flag1) {
                VeinMiningLogic.harvestBlock(block, (World)world, (PlayerEntity)player, pos, spawnPos, blockstate, tileentity, itemstack1);
            }
            if (flag && exp > 0) {
                blockstate.func_177230_c().func_180637_b(world, spawnPos, exp);
            }
        }
        return true;
    }

    private static void onBlockDestroyed(ItemStack stack, World worldIn, BlockState blockIn, BlockPos pos, PlayerEntity playerIn) {
        if (!worldIn.field_72995_K && blockIn.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            int damage = VeinMiningConfig.VeinMining.toolDamageMultiplier;
            if (VeinMiningConfig.VeinMining.preventToolDestruction) {
                damage = Math.min(damage, stack.func_77958_k() - stack.func_77952_i() - 1);
            }
            if (damage > 0) {
                stack.func_222118_a(damage, (LivingEntity)playerIn, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
            }
        }
    }

    private static void harvestBlock(Block block, World worldIn, PlayerEntity player, BlockPos pos, BlockPos spawnPos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)block));
        if (VeinMiningConfig.VeinMining.addPlayerExhaustion) {
            player.func_71020_j((float)((double)0.005f * VeinMiningConfig.VeinMining.playerExhaustionMultiplier));
        }
        if (worldIn instanceof ServerWorld) {
            Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)worldIn), (BlockPos)pos, (TileEntity)te, (Entity)player, (ItemStack)stack).forEach(stackToSpawn -> Block.func_180635_a((World)worldIn, (BlockPos)spawnPos, (ItemStack)stackToSpawn));
            state.func_215706_a((ServerWorld)worldIn, pos, stack);
        }
    }

    private static boolean removeBlock(PlayerEntity player, BlockPos pos, boolean canHarvest) {
        World world = player.func_130014_f_();
        BlockState state = world.func_180495_p(pos);
        boolean removed = state.removedByPlayer(world, pos, player, canHarvest, world.func_204610_c(pos));
        if (removed) {
            state.func_177230_c().func_176206_d((IWorld)world, pos, state);
            if (!world.func_180495_p(pos).isAir((IBlockReader)world, pos)) {
                world.func_217377_a(pos, false);
            }
        }
        return removed;
    }
}

