/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining.veinmining;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import top.theillusivec4.veinmining.config.VeinMiningConfig;

public class VeinMiningEnchantment
extends Enchantment {
    public static final String ID = "veinmining:vein_mining";
    public static final EnchantmentCategory TYPE = EnchantmentCategory.create((String)"veinmining:vein_mining", VeinMiningEnchantment::canEnchantItem);
    public static final Map<String, Predicate<Item>> PREDICATE_MAP;

    public VeinMiningEnchantment() {
        super(Enchantment.Rarity.RARE, TYPE, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    private static boolean canEnchantItem(Item item) {
        for (String entry : VeinMiningConfig.Enchantment.items) {
            if (PREDICATE_MAP.getOrDefault(entry, k -> false).test(item)) {
                return true;
            }
            if (item.getRegistryName() == null || !item.getRegistryName().toString().equals(entry)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Enchantment.Rarity m_44699_() {
        return VeinMiningConfig.Enchantment.rarity;
    }

    public int m_6586_() {
        return VeinMiningConfig.Enchantment.levels;
    }

    public int m_6183_(int enchantmentLevel) {
        return VeinMiningConfig.Enchantment.minEnchantabilityBase + VeinMiningConfig.Enchantment.minEnchantabilityPerLevel * (enchantmentLevel - 1);
    }

    public int m_6175_(int enchantmentLevel) {
        return this.m_6183_(enchantmentLevel) + 50;
    }

    public boolean m_6591_() {
        return VeinMiningConfig.Enchantment.isTreasure;
    }

    public boolean m_6594_() {
        return VeinMiningConfig.Enchantment.isVillagerTrade;
    }

    public boolean m_6592_() {
        return VeinMiningConfig.Enchantment.isLootable;
    }

    protected boolean m_5975_(Enchantment ench) {
        ResourceLocation rl = ench.getRegistryName();
        if (rl != null && VeinMiningConfig.Enchantment.incompatibleEnchantments.contains(rl.toString())) {
            return false;
        }
        return super.m_5975_(ench);
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack) {
        return super.canApplyAtEnchantingTable(stack) && VeinMiningConfig.Enchantment.canApplyAtEnchantingTable;
    }

    public boolean isAllowedOnBooks() {
        return VeinMiningConfig.Enchantment.canApplyOnBooks;
    }

    static {
        HashMap<String, Predicate<Item>> temp = new HashMap<String, Predicate<Item>>();
        temp.put("is:tool", item -> item instanceof DiggerItem);
        temp.put("is:pickaxe", item -> item instanceof PickaxeItem);
        temp.put("is:axe", item -> item instanceof AxeItem);
        temp.put("is:hoe", item -> item instanceof HoeItem);
        temp.put("is:shovel", item -> item instanceof ShovelItem);
        PREDICATE_MAP = ImmutableMap.copyOf(temp);
    }
}

