/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining.veinmining.logic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.veinmining.config.VeinMiningConfig;

public class BlockGroups {
    private static final Map<String, Set<String>> blockToGroup = new HashMap<String, Set<String>>();

    public static void init() {
        blockToGroup.clear();
        for (String group : VeinMiningConfig.VeinMining.groups) {
            String[] ids = group.split(",");
            Set<String> blockGroup = BlockGroups.createGroup(ids);
            for (String blockId : blockGroup) {
                blockToGroup.merge(blockId, blockGroup, (s1, s2) -> {
                    s1.addAll(s2);
                    return s1;
                });
            }
        }
    }

    public static Set<String> getGroup(String id) {
        return blockToGroup.getOrDefault(id, new HashSet());
    }

    private static Set<String> createGroup(String[] ids) {
        HashSet<String> newGroup = new HashSet<String>();
        for (String id : ids) {
            ResourceLocation rl;
            boolean isTag;
            boolean bl = isTag = id.charAt(0) == '#';
            if (isTag) {
                Tag tag;
                rl = ResourceLocation.m_135820_((String)id.substring(1));
                if (rl == null || (tag = BlockTags.m_13115_().m_13404_(rl)) == null) continue;
                for (Block block : tag.m_6497_()) {
                    newGroup.add(Objects.requireNonNull(block.getRegistryName()).toString());
                }
                continue;
            }
            rl = ResourceLocation.m_135820_((String)id);
            if (rl == null || !ForgeRegistries.BLOCKS.containsKey(rl)) continue;
            newGroup.add(id);
        }
        return newGroup;
    }
}

