/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining.veinmining.logic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import top.theillusivec4.veinmining.config.VeinMiningConfig;
import top.theillusivec4.veinmining.veinmining.logic.BlockGroups;

public class BlockProcessor {
    private static final Map<String, Boolean> checkedBlocks = new HashMap<String, Boolean>();
    private static final Map<String, Map<String, Boolean>> checkedPairs = new HashMap<String, Map<String, Boolean>>();

    public static void rebuild() {
        checkedBlocks.clear();
        checkedPairs.clear();
        BlockGroups.init();
    }

    public static boolean isValidTarget(BlockState state, Level world, BlockPos pos, Block source) {
        Block block = state.m_60734_();
        return !state.m_60795_() && checkedBlocks.computeIfAbsent(Objects.requireNonNull(block.getRegistryName()).toString(), name -> BlockProcessor.checkBlock(block)) != false && BlockProcessor.matches(source, block);
    }

    private static boolean matches(Block origin, Block target) {
        String targetName;
        boolean useOriginKey;
        if (origin == target) {
            return true;
        }
        String originName = Objects.requireNonNull(origin.getRegistryName()).toString();
        boolean bl = useOriginKey = originName.compareTo(targetName = Objects.requireNonNull(target.getRegistryName()).toString()) >= 0;
        if (useOriginKey) {
            return checkedPairs.computeIfAbsent(originName, name -> new HashMap()).computeIfAbsent(targetName, name -> BlockProcessor.checkMatch(origin, target));
        }
        return checkedPairs.computeIfAbsent(targetName, name -> new HashMap()).computeIfAbsent(originName, name -> BlockProcessor.checkMatch(origin, target));
    }

    private static boolean checkBlock(Block block) {
        HashSet<String> ids = new HashSet<String>();
        ids.add(Objects.requireNonNull(block.getRegistryName()).toString());
        block.getTags().forEach(tag -> ids.add("#" + tag.toString()));
        Set<String> configs = VeinMiningConfig.VeinMining.blocks;
        if (VeinMiningConfig.VeinMining.blocksPermission == VeinMiningConfig.PermissionType.BLACKLIST) {
            for (String id : configs) {
                if (!ids.contains(id)) continue;
                return false;
            }
            return true;
        }
        for (String id : configs) {
            if (!ids.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkMatch(Block origin, Block target) {
        Set<String> group = BlockGroups.getGroup(Objects.requireNonNull(origin.getRegistryName()).toString());
        if (group != null) {
            return group.contains(Objects.requireNonNull(target.getRegistryName()).toString());
        }
        return false;
    }
}

