/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining.veinmining.logic;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import top.theillusivec4.veinmining.VeinMiningMod;
import top.theillusivec4.veinmining.config.VeinMiningConfig;
import top.theillusivec4.veinmining.veinmining.VeinMiningPlayers;
import top.theillusivec4.veinmining.veinmining.logic.BlockProcessor;

public class VeinMiningLogic {
    private static final Direction[] CARDINAL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH};

    public static void startVeinMining(ServerPlayer playerEntity, BlockPos pos, Block source) {
        boolean ineffective;
        ServerLevel world = playerEntity.m_9236_();
        ItemStack stack = playerEntity.m_21205_();
        if (!VeinMiningPlayers.canVeinMine((Player)playerEntity)) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        boolean bl = ineffective = VeinMiningConfig.VeinMining.requireEffectiveTool && !ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)playerEntity);
        if (ineffective) {
            return;
        }
        int veiningLevels = EnchantmentHelper.m_44843_((Enchantment)VeinMiningMod.VEIN_MINING, (ItemStack)stack);
        int maxBlocks = VeinMiningConfig.VeinMining.maxBlocksBase + VeinMiningConfig.VeinMining.maxBlocksPerLevel * veiningLevels;
        int maxDistance = VeinMiningConfig.VeinMining.maxDistanceBase + VeinMiningConfig.VeinMining.maxDistancePerLevel * veiningLevels;
        if (maxBlocks <= 0 || maxDistance <= 0) {
            return;
        }
        int blocks = 0;
        HashSet visited = Sets.newHashSet((Object[])new BlockPos[]{pos});
        LinkedList<Tuple<BlockPos, Integer>> candidates = new LinkedList<Tuple<BlockPos, Integer>>();
        VeinMiningLogic.addValidNeighbors(candidates, pos, 1);
        while (!candidates.isEmpty() && blocks < maxBlocks) {
            Tuple<BlockPos, Integer> candidate = candidates.poll();
            BlockPos blockPos = (BlockPos)candidate.m_14418_();
            int blockDistance = (Integer)candidate.m_14419_();
            if (VeinMiningLogic.stopVeining(stack)) {
                return;
            }
            BlockState blockState = world.m_8055_(blockPos);
            if (!visited.add(blockPos) || !BlockProcessor.isValidTarget(blockState, (Level)world, blockPos, source) || !VeinMiningLogic.harvest(playerEntity, blockPos, pos)) continue;
            if (blockDistance < maxDistance) {
                VeinMiningLogic.addValidNeighbors(candidates, blockPos, blockDistance + 1);
            }
            ++blocks;
        }
    }

    private static boolean stopVeining(ItemStack stack) {
        return VeinMiningConfig.VeinMining.limitedByDurability && (stack.m_41773_() == stack.m_41776_() || VeinMiningConfig.VeinMining.preventToolDestruction && stack.m_41773_() == stack.m_41776_() - 1);
    }

    private static void addValidNeighbors(LinkedList<Tuple<BlockPos, Integer>> candidates, BlockPos source, int distance) {
        if (VeinMiningConfig.VeinMining.diagonalMining) {
            BlockPos[] blockPositions;
            BlockPos up = source.m_7494_();
            BlockPos down = source.m_7495_();
            candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)up, (Object)distance));
            candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)down, (Object)distance));
            for (BlockPos blockPos : blockPositions = new BlockPos[]{up, down, source}) {
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142125_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142126_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142127_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142128_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142127_().m_142125_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142127_().m_142126_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142128_().m_142125_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142128_().m_142126_(), (Object)distance));
            }
        } else {
            for (Direction direction : CARDINAL_DIRECTIONS) {
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)source.m_142300_(direction), (Object)distance));
            }
        }
    }

    public static boolean harvest(ServerPlayer player, BlockPos pos, BlockPos originPos) {
        ServerLevel world = player.m_9236_();
        BlockState blockstate = world.m_8055_(pos);
        GameType gameType = player.f_8941_.m_9290_();
        int exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)gameType, (ServerPlayer)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        BlockEntity tileentity = world.m_7702_(pos);
        Block block = blockstate.m_60734_();
        if ((block instanceof CommandBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !player.m_36337_()) {
            world.m_7260_(pos, blockstate, blockstate, 3);
            return false;
        }
        if (player.m_21205_().onBlockStartBreak(pos, (Player)player)) {
            return false;
        }
        if (player.m_36187_((Level)world, pos, gameType)) {
            return false;
        }
        if (gameType.m_46408_()) {
            VeinMiningLogic.removeBlock((Player)player, pos, false);
        } else {
            BlockPos spawnPos;
            ItemStack itemstack = player.m_21205_();
            ItemStack itemstack1 = itemstack.m_41777_();
            boolean flag1 = blockstate.canHarvestBlock((BlockGetter)world, pos, (Player)player);
            if (VeinMiningConfig.VeinMining.addToolDamage) {
                VeinMiningLogic.onBlockDestroyed(itemstack, (Level)world, blockstate, pos, (Player)player);
            }
            if (itemstack.m_41619_() && !itemstack1.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)itemstack1, (InteractionHand)InteractionHand.MAIN_HAND);
            }
            boolean flag = VeinMiningLogic.removeBlock((Player)player, pos, flag1);
            BlockPos blockPos = spawnPos = VeinMiningConfig.VeinMining.relocateDrops ? originPos : pos;
            if (flag && flag1) {
                VeinMiningLogic.harvestBlock(block, (Level)world, (Player)player, pos, spawnPos, blockstate, tileentity, itemstack1);
            }
            if (flag && exp > 0) {
                blockstate.m_60734_().m_49805_(world, spawnPos, exp);
            }
        }
        return true;
    }

    private static void onBlockDestroyed(ItemStack stack, Level worldIn, BlockState blockIn, BlockPos pos, Player playerIn) {
        if (!worldIn.f_46443_ && blockIn.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            int damage = VeinMiningConfig.VeinMining.toolDamageMultiplier;
            if (VeinMiningConfig.VeinMining.preventToolDestruction) {
                damage = Math.min(damage, stack.m_41776_() - stack.m_41773_() - 1);
            }
            if (damage > 0) {
                stack.m_41622_(damage, (LivingEntity)playerIn, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
    }

    private static void harvestBlock(Block block, Level worldIn, Player player, BlockPos pos, BlockPos spawnPos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        player.m_36246_(Stats.f_12949_.m_12902_((Object)block));
        if (VeinMiningConfig.VeinMining.addPlayerExhaustion) {
            player.m_36399_((float)((double)0.005f * VeinMiningConfig.VeinMining.playerExhaustionMultiplier));
        }
        if (worldIn instanceof ServerLevel) {
            Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)worldIn), (BlockPos)pos, (BlockEntity)te, (Entity)player, (ItemStack)stack).forEach(stackToSpawn -> Block.m_49840_((Level)worldIn, (BlockPos)spawnPos, (ItemStack)stackToSpawn));
            state.m_60612_((ServerLevel)worldIn, pos, stack);
        }
    }

    private static boolean removeBlock(Player player, BlockPos pos, boolean canHarvest) {
        Level world = player.m_20193_();
        BlockState state = world.m_8055_(pos);
        boolean removed = state.removedByPlayer(world, pos, player, canHarvest, world.m_6425_(pos));
        if (removed) {
            state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
            if (!world.m_8055_(pos).m_60795_()) {
                world.m_7471_(pos, false);
            }
        }
        return removed;
    }
}

