/*
 * Decompiled with CFR 0.152.
 */
package platinpython.vfxgenerator.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;
import platinpython.vfxgenerator.tileentity.VFXGeneratorTileEntity;
import platinpython.vfxgenerator.util.ClientUtils;
import platinpython.vfxgenerator.util.network.NetworkHandler;
import platinpython.vfxgenerator.util.network.packets.VFXGeneratorDestroyParticlesPKT;
import platinpython.vfxgenerator.util.registries.TileEntityRegistry;

public class VFXGeneratorBlock
extends Block {
    public static final BooleanProperty INVERTED = BlockStateProperties.field_208188_o;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public VFXGeneratorBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150348_b).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)INVERTED, (Comparable)Boolean.FALSE)).func_206870_a((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{INVERTED, POWERED});
    }

    public void func_190948_a(ItemStack stack, IBlockReader level, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (stack.func_179543_a("particleData") != null) {
            tooltip.add((ITextComponent)ClientUtils.getGuiTranslationTextComponent("dataSaved"));
        }
    }

    public VoxelShape func_230335_e_(BlockState state, IBlockReader reader, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityRegistry.VFX_GENERATOR.get()).func_200968_a();
    }

    public void func_220069_a(BlockState state, World level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean isPowered;
        if (!level.field_72995_K && (isPowered = ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) != level.func_175640_z(pos)) {
            if (isPowered) {
                level.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            } else {
                level.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)POWERED), 2);
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld level, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() && !level.func_175640_z(pos)) {
            level.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)POWERED), 2);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.func_184614_ca().func_190926_b()) {
            TileEntity tileEntity;
            if (player.func_225608_bj_() && player.func_184592_cb().func_190926_b()) {
                level.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)INVERTED), 2);
                return ActionResultType.SUCCESS;
            }
            if (level.field_72995_K && (tileEntity = level.func_175625_s(pos)) instanceof VFXGeneratorTileEntity) {
                ClientUtils.openVFXGeneratorScreen((VFXGeneratorTileEntity)tileEntity);
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileEntity;
        if (stack.func_179543_a("particleData") != null && (tileEntity = level.func_175625_s(pos)) instanceof VFXGeneratorTileEntity) {
            ((VFXGeneratorTileEntity)tileEntity).loadFromTag(stack.func_196082_o());
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        CompoundNBT tag = stack.func_196082_o();
        CompoundNBT blockStateTag = new CompoundNBT();
        blockStateTag.func_74778_a("inverted", ((Boolean)state.func_177229_b((Property)INVERTED)).toString());
        tag.func_218657_a("BlockStateTag", (INBT)blockStateTag);
        stack.func_77982_d(tag);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof VFXGeneratorTileEntity) {
            stack.func_77982_d(((VFXGeneratorTileEntity)tileEntity).saveToTag(tag));
        }
        return stack;
    }

    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.field_72995_K && !state.func_203425_a(newState.func_177230_c())) {
            NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new VFXGeneratorDestroyParticlesPKT(Vector3d.func_237489_a_((Vector3i)pos)));
        }
        super.func_196243_a(state, level, pos, newState, isMoving);
    }
}

