/*
 * Decompiled with CFR 0.152.
 */
package platinpython.vfxgenerator.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import platinpython.vfxgenerator.client.gui.widget.ToggleButton;
import platinpython.vfxgenerator.client.gui.widget.VFXGeneratorOptionsList;
import platinpython.vfxgenerator.tileentity.VFXGeneratorTileEntity;
import platinpython.vfxgenerator.util.ClientUtils;
import platinpython.vfxgenerator.util.Color;
import platinpython.vfxgenerator.util.Constants;
import platinpython.vfxgenerator.util.network.NetworkHandler;
import platinpython.vfxgenerator.util.network.packets.VFXGeneratorDataSyncPKT;

public class VFXGeneratorScreen
extends Screen {
    public final VFXGeneratorTileEntity tileEntity;
    private VFXGeneratorOptionsList particleOptionsList;

    public VFXGeneratorScreen(VFXGeneratorTileEntity tileEntity) {
        super((ITextComponent)new TranslationTextComponent("block.vfxgenerator.vfx_generator"));
        this.tileEntity = tileEntity;
    }

    protected void func_231160_c_() {
        ToggleButton button = new ToggleButton(this.field_230708_k_ / 2 - 30, 20, 60, 10, this.tileEntity::setParticleEnabled, this.tileEntity::isParticleEnabled, this::sendToServer);
        this.func_230480_a_(button);
        this.particleOptionsList = new VFXGeneratorOptionsList(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, 32, this.field_230709_l_ - 32, 25);
        this.particleOptionsList.addMultipleChoiceButton(Constants.ParticleConstants.PARTICLE_OPTIONS, this.tileEntity::setParticleSelected, this.tileEntity::getParticleSelected, this::sendToServer);
        this.particleOptionsList.addToggleButton((ITextComponent)ClientUtils.getGuiTranslationTextComponent("rgb"), (ITextComponent)ClientUtils.getGuiTranslationTextComponent("hsb"), this.tileEntity::setParticleUseHSB, this.tileEntity::isParticleUseHSB, this::sendToServer);
        this.particleOptionsList.addToggleableRangeSlider(1.0f, (ITextComponent)ClientUtils.getGuiTranslationTextComponent("red"), StringTextComponent.field_240750_d_, 0.0, 255.0, value -> {
            Color oldColor = new Color(this.tileEntity.getParticleRGBColorBot());
            Color newColor = new Color(value.intValue(), oldColor.getGreen(), oldColor.getBlue());
            this.tileEntity.setParticleRGBColorBot(newColor.getRGB());
        }, value -> {
            Color oldColor = new Color(this.tileEntity.getParticleRGBColorTop());
            Color newColor = new Color(value.intValue(), oldColor.getGreen(), oldColor.getBlue());
            this.tileEntity.setParticleRGBColorTop(newColor.getRGB());
        }, () -> Float.valueOf(new Color(this.tileEntity.getParticleRGBColorBot()).getRed()), () -> Float.valueOf(new Color(this.tileEntity.getParticleRGBColorTop()).getRed()), (ITextComponent)ClientUtils.getGuiTranslationTextComponent("hue"), (ITextComponent)new StringTextComponent("\u00b0"), 0.0, 360.0, value -> {
            float[] oldHsb = this.tileEntity.getParticleHSBColorBot();
            this.tileEntity.setParticleHSBColorBot(new float[]{value.floatValue() / 360.0f, oldHsb[1], oldHsb[2]});
        }, value -> {
            float[] oldHsb = this.tileEntity.getParticleHSBColorTop();
            this.tileEntity.setParticleHSBColorTop(new float[]{value.floatValue() / 360.0f, oldHsb[1], oldHsb[2]});
        }, () -> Float.valueOf(this.tileEntity.getParticleHSBColorBot()[0] * 360.0f), () -> Float.valueOf(this.tileEntity.getParticleHSBColorTop()[0] * 360.0f), this::sendToServer, this.tileEntity::isParticleUseHSB);
        this.particleOptionsList.addToggleableRangeSlider(1.0f, (ITextComponent)ClientUtils.getGuiTranslationTextComponent("green"), StringTextComponent.field_240750_d_, 0.0, 255.0, value -> {
            Color oldColor = new Color(this.tileEntity.getParticleRGBColorBot());
            Color newColor = new Color(oldColor.getRed(), value.intValue(), oldColor.getBlue());
            this.tileEntity.setParticleRGBColorBot(newColor.getRGB());
        }, value -> {
            Color oldColor = new Color(this.tileEntity.getParticleRGBColorTop());
            Color newColor = new Color(oldColor.getRed(), value.intValue(), oldColor.getBlue());
            this.tileEntity.setParticleRGBColorTop(newColor.getRGB());
        }, () -> Float.valueOf(new Color(this.tileEntity.getParticleRGBColorBot()).getGreen()), () -> Float.valueOf(new Color(this.tileEntity.getParticleRGBColorTop()).getGreen()), (ITextComponent)ClientUtils.getGuiTranslationTextComponent("saturation"), (ITextComponent)new StringTextComponent("%"), 0.0, 100.0, value -> {
            float[] oldHsb = this.tileEntity.getParticleHSBColorBot();
            this.tileEntity.setParticleHSBColorBot(new float[]{oldHsb[0], value.floatValue() / 100.0f, oldHsb[2]});
        }, value -> {
            float[] oldHsb = this.tileEntity.getParticleHSBColorTop();
            this.tileEntity.setParticleHSBColorTop(new float[]{oldHsb[0], value.floatValue() / 100.0f, oldHsb[2]});
        }, () -> Float.valueOf(this.tileEntity.getParticleHSBColorBot()[1] * 100.0f), () -> Float.valueOf(this.tileEntity.getParticleHSBColorTop()[1] * 100.0f), this::sendToServer, this.tileEntity::isParticleUseHSB);
        this.particleOptionsList.addToggleableRangeSlider(1.0f, (ITextComponent)ClientUtils.getGuiTranslationTextComponent("blue"), StringTextComponent.field_240750_d_, 0.0, 255.0, value -> {
            Color oldColor = new Color(this.tileEntity.getParticleRGBColorBot());
            Color newColor = new Color(oldColor.getRed(), oldColor.getGreen(), value.intValue());
            this.tileEntity.setParticleRGBColorBot(newColor.getRGB());
        }, value -> {
            Color oldColor = new Color(this.tileEntity.getParticleRGBColorTop());
            Color newColor = new Color(oldColor.getRed(), oldColor.getGreen(), value.intValue());
            this.tileEntity.setParticleRGBColorTop(newColor.getRGB());
        }, () -> Float.valueOf(new Color(this.tileEntity.getParticleRGBColorBot()).getBlue()), () -> Float.valueOf(new Color(this.tileEntity.getParticleRGBColorTop()).getBlue()), (ITextComponent)ClientUtils.getGuiTranslationTextComponent("brightness"), (ITextComponent)new StringTextComponent("%"), 0.0, 100.0, value -> {
            float[] oldHsb = this.tileEntity.getParticleHSBColorBot();
            this.tileEntity.setParticleHSBColorBot(new float[]{oldHsb[0], oldHsb[1], value.floatValue() / 100.0f});
        }, value -> {
            float[] oldHsb = this.tileEntity.getParticleHSBColorTop();
            this.tileEntity.setParticleHSBColorTop(new float[]{oldHsb[0], oldHsb[1], value.floatValue() / 100.0f});
        }, () -> Float.valueOf(this.tileEntity.getParticleHSBColorBot()[2] * 100.0f), () -> Float.valueOf(this.tileEntity.getParticleHSBColorTop()[2] * 100.0f), this::sendToServer, this.tileEntity::isParticleUseHSB);
        this.particleOptionsList.addRangeSlider((ITextComponent)ClientUtils.getGuiTranslationTextComponent("lifetime"), (ITextComponent)ClientUtils.getGuiTranslationTextComponent("ticks"), 0.0, 200.0, 1.0f, value -> this.tileEntity.setParticleLifetimeBot(value.intValue()), value -> this.tileEntity.setParticleLifetimeTop(value.intValue()), () -> Float.valueOf(this.tileEntity.getParticleLifetimeBot()), () -> Float.valueOf(this.tileEntity.getParticleLifetimeTop()), this::sendToServer);
        this.particleOptionsList.addRangeSlider((ITextComponent)ClientUtils.getGuiTranslationTextComponent("size"), StringTextComponent.field_240750_d_, 0.0, 50.0, 0.1f, this.tileEntity::setParticleSizeBot, this.tileEntity::setParticleSizeTop, this.tileEntity::getParticleSizeBot, this.tileEntity::getParticleSizeTop, this::sendToServer);
        this.particleOptionsList.addRangeSlider((ITextComponent)ClientUtils.getGuiTranslationTextComponent("spawnX"), StringTextComponent.field_240750_d_, -20.0, 20.0, 0.1f, this.tileEntity::setParticleSpawnXBot, this.tileEntity::setParticleSpawnXTop, this.tileEntity::getParticleSpawnXBot, this.tileEntity::getParticleSpawnXTop, this::sendToServer);
        this.particleOptionsList.addRangeSlider((ITextComponent)ClientUtils.getGuiTranslationTextComponent("spawnY"), StringTextComponent.field_240750_d_, -20.0, 20.0, 0.1f, this.tileEntity::setParticleSpawnYBot, this.tileEntity::setParticleSpawnYTop, this.tileEntity::getParticleSpawnYBot, this.tileEntity::getParticleSpawnYTop, this::sendToServer);
        this.particleOptionsList.addRangeSlider((ITextComponent)ClientUtils.getGuiTranslationTextComponent("spawnZ"), StringTextComponent.field_240750_d_, -20.0, 20.0, 0.1f, this.tileEntity::setParticleSpawnZBot, this.tileEntity::setParticleSpawnZTop, this.tileEntity::getParticleSpawnZBot, this.tileEntity::getParticleSpawnZTop, this::sendToServer);
        this.particleOptionsList.addRangeSlider((ITextComponent)ClientUtils.getGuiTranslationTextComponent("motionX"), StringTextComponent.field_240750_d_, -3.0, 3.0, 0.01f, this.tileEntity::setParticleMotionXBot, this.tileEntity::setParticleMotionXTop, this.tileEntity::getParticleMotionXBot, this.tileEntity::getParticleMotionXTop, this::sendToServer);
        this.particleOptionsList.addRangeSlider((ITextComponent)ClientUtils.getGuiTranslationTextComponent("motionY"), StringTextComponent.field_240750_d_, -3.0, 3.0, 0.01f, this.tileEntity::setParticleMotionYBot, this.tileEntity::setParticleMotionYTop, this.tileEntity::getParticleMotionYBot, this.tileEntity::getParticleMotionYTop, this::sendToServer);
        this.particleOptionsList.addRangeSlider((ITextComponent)ClientUtils.getGuiTranslationTextComponent("motionZ"), StringTextComponent.field_240750_d_, -3.0, 3.0, 0.01f, this.tileEntity::setParticleMotionZBot, this.tileEntity::setParticleMotionZTop, this.tileEntity::getParticleMotionZBot, this.tileEntity::getParticleMotionZTop, this::sendToServer);
        this.particleOptionsList.addSlider((ITextComponent)ClientUtils.getGuiTranslationTextComponent("delay"), (ITextComponent)ClientUtils.getGuiTranslationTextComponent("ticks"), 1.0, 200.0, 1.0f, value -> this.tileEntity.setParticleDelay(value.intValue()), () -> Float.valueOf(this.tileEntity.getParticleDelay()), this::sendToServer);
        this.particleOptionsList.addSlider((ITextComponent)ClientUtils.getGuiTranslationTextComponent("gravity"), StringTextComponent.field_240750_d_, -2.0, 2.0, 0.01f, this.tileEntity::setParticleGravity, this.tileEntity::getParticleGravity, this::sendToServer);
        this.particleOptionsList.addToggleButton((ITextComponent)ClientUtils.getGuiTranslationTextComponent("collision").func_240702_b_(": ").func_230529_a_((ITextComponent)ClientUtils.getGuiTranslationTextComponent("disabled")), (ITextComponent)ClientUtils.getGuiTranslationTextComponent("collision").func_240702_b_(": ").func_230529_a_((ITextComponent)ClientUtils.getGuiTranslationTextComponent("enabled")), this.tileEntity::setParticleCollision, this.tileEntity::isParticleCollision, this::sendToServer);
        this.particleOptionsList.func_231039_at__().parallelStream().forEach(entry -> entry.setActive(this.tileEntity.isParticleEnabled()));
        this.func_230481_d_((IGuiEventListener)this.particleOptionsList);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.particleOptionsList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (!this.tileEntity.isParticleEnabled()) {
            this.func_238468_a_(matrixStack, 0, 32, this.field_230708_k_, this.field_230709_l_ - 32, -1072689136, -804253680);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)ClientUtils.getGuiTranslationTextComponent("particle"), (int)(this.field_230708_k_ / 2), (int)10, (int)-1);
    }

    public void func_231023_e_() {
        if (this.field_230706_i_.field_71439_g.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.tileEntity.func_174877_v())) > 64.0) {
            this.func_231175_as__();
        }
        this.particleOptionsList.func_231039_at__().parallelStream().forEach(entry -> {
            entry.updateValue();
            entry.setActive(this.tileEntity.isParticleEnabled());
        });
    }

    public boolean func_231177_au__() {
        return false;
    }

    private final void sendToServer() {
        NetworkHandler.INSTANCE.sendToServer((Object)new VFXGeneratorDataSyncPKT(this.tileEntity.saveToTag(new CompoundNBT()), this.tileEntity.func_174877_v()));
    }
}

