/*
 * Decompiled with CFR 0.152.
 */
package platinpython.vfxgenerator.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import platinpython.vfxgenerator.client.gui.widget.UpdateableWidget;
import platinpython.vfxgenerator.util.Util;

public class FloatRangeSlider
extends UpdateableWidget {
    private double leftSliderValue;
    private double rightSliderValue;
    private final double minValue;
    private final double maxValue;
    private final float stepSize;
    private final DecimalFormat format;
    private final ITextComponent prefix;
    private final ITextComponent suffix;
    private final Consumer<Float> setLeftValueFunction;
    private final Consumer<Float> setRightValueFunction;
    private final Supplier<Float> leftValueSupplier;
    private final Supplier<Float> rightValueSupplier;
    private boolean isLeftSelected;
    private boolean stopped;

    public FloatRangeSlider(int x, int y, int width, int height, ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, float stepSize, Consumer<Float> setLeftValueFunction, Consumer<Float> setRightValueFunction, Supplier<Float> leftValueSupplier, Supplier<Float> rightValueSupplier, Util.VoidFunction applyValueFunction) {
        super(x, y, width, height, applyValueFunction);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = stepSize;
        this.format = Float.toString(this.stepSize).split("\\.")[1].length() == 1 && Float.toString(this.stepSize).split("\\.")[1].equals("0") ? new DecimalFormat("0") : new DecimalFormat(Float.toString(this.stepSize).replaceAll("\\d", "0"));
        this.prefix = prefix;
        this.suffix = suffix;
        this.setLeftValueFunction = setLeftValueFunction;
        this.setRightValueFunction = setRightValueFunction;
        this.leftValueSupplier = leftValueSupplier;
        this.rightValueSupplier = rightValueSupplier;
        this.setupSliderValues(this.leftValueSupplier.get().floatValue(), this.rightValueSupplier.get().floatValue());
    }

    private void setupSliderValues(double leftValue, double rightValue) {
        this.leftSliderValue = Util.clamp(leftValue, this.minValue, this.maxValue, this.stepSize);
        this.rightSliderValue = Util.clamp(rightValue, this.minValue, this.maxValue, this.stepSize);
        this.leftSliderValue = Util.toValue(MathHelper.func_151237_a((double)this.leftSliderValue, (double)0.0, (double)this.rightSliderValue), this.minValue, this.maxValue, this.stepSize);
        this.rightSliderValue = Util.toValue(MathHelper.func_151237_a((double)this.rightSliderValue, (double)this.leftSliderValue, (double)1.0), this.minValue, this.maxValue, this.stepSize);
        this.setLeftValueFunction.accept(Float.valueOf((float)this.getLeftSliderValue()));
        this.setRightValueFunction.accept(Float.valueOf((float)this.getRightSliderValue()));
        this.applyValue();
        this.updateMessage();
    }

    protected int func_230989_a_(boolean isHovered) {
        return 0;
    }

    private int getYImageNoDisabled(boolean isHovered) {
        if (!this.field_230693_o_) {
            return 1;
        }
        return isHovered ? 2 : 1;
    }

    public boolean isLeftHovered(int mouseX) {
        return this.func_230449_g_() && (double)mouseX < (double)this.field_230690_l_ + (this.rightSliderValue + this.leftSliderValue) / 2.0 * (double)this.field_230688_j_;
    }

    public boolean isRightHovered(int mouseX) {
        return this.func_230449_g_() && (double)mouseX > (double)this.field_230690_l_ + (this.rightSliderValue + this.leftSliderValue) / 2.0 * (double)this.field_230688_j_;
    }

    protected void func_230441_a_(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiUtils.drawContinuousTexturedBox((MatrixStack)matrixStack, (int)(this.field_230690_l_ + (int)(this.leftSliderValue * (double)(this.field_230688_j_ - 8)) + 4), (int)(this.field_230691_m_ + 3), (int)0, (int)66, (int)((int)(this.rightSliderValue * (double)(this.field_230688_j_ - 8)) - (int)(this.leftSliderValue * (double)(this.field_230688_j_ - 8))), (int)(this.field_230689_k_ - 6), (int)200, (int)20, (int)2, (int)2, (int)2, (int)2, (float)this.func_230927_p_());
        if (this.isLeftHovered(mouseX)) {
            this.func_238474_b_(matrixStack, this.field_230690_l_ + (int)(this.rightSliderValue * (double)(this.field_230688_j_ - 8)), this.field_230691_m_, 0, 46 + this.getYImageNoDisabled(this.isRightHovered(mouseX)) * 20, 4, this.field_230689_k_);
            this.func_238474_b_(matrixStack, this.field_230690_l_ + (int)(this.rightSliderValue * (double)(this.field_230688_j_ - 8)) + 4, this.field_230691_m_, 196, 46 + this.getYImageNoDisabled(this.isRightHovered(mouseX)) * 20, 4, this.field_230689_k_);
            this.func_238474_b_(matrixStack, this.field_230690_l_ + (int)(this.leftSliderValue * (double)(this.field_230688_j_ - 8)), this.field_230691_m_, 0, 46 + this.getYImageNoDisabled(this.isLeftHovered(mouseX)) * 20, 4, this.field_230689_k_);
            this.func_238474_b_(matrixStack, this.field_230690_l_ + (int)(this.leftSliderValue * (double)(this.field_230688_j_ - 8)) + 4, this.field_230691_m_, 196, 46 + this.getYImageNoDisabled(this.isLeftHovered(mouseX)) * 20, 4, this.field_230689_k_);
        } else {
            this.func_238474_b_(matrixStack, this.field_230690_l_ + (int)(this.leftSliderValue * (double)(this.field_230688_j_ - 8)), this.field_230691_m_, 0, 46 + this.getYImageNoDisabled(this.isLeftHovered(mouseX)) * 20, 4, this.field_230689_k_);
            this.func_238474_b_(matrixStack, this.field_230690_l_ + (int)(this.leftSliderValue * (double)(this.field_230688_j_ - 8)) + 4, this.field_230691_m_, 196, 46 + this.getYImageNoDisabled(this.isLeftHovered(mouseX)) * 20, 4, this.field_230689_k_);
            this.func_238474_b_(matrixStack, this.field_230690_l_ + (int)(this.rightSliderValue * (double)(this.field_230688_j_ - 8)), this.field_230691_m_, 0, 46 + this.getYImageNoDisabled(this.isRightHovered(mouseX)) * 20, 4, this.field_230689_k_);
            this.func_238474_b_(matrixStack, this.field_230690_l_ + (int)(this.rightSliderValue * (double)(this.field_230688_j_ - 8)) + 4, this.field_230691_m_, 196, 46 + this.getYImageNoDisabled(this.isRightHovered(mouseX)) * 20, 4, this.field_230689_k_);
        }
    }

    private boolean getIsLeftClicked(double mouseX) {
        return mouseX < (double)(this.field_230690_l_ + (int)(this.leftSliderValue * (double)(this.field_230688_j_ - 8)) + 8) || mouseX < ((double)this.field_230690_l_ + this.leftSliderValue * (double)this.field_230688_j_ + ((double)this.field_230690_l_ + this.rightSliderValue * (double)this.field_230688_j_)) / 2.0;
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.isLeftSelected = this.getIsLeftClicked(mouseX);
        this.stopped = false;
        if (this.isLeftSelected) {
            this.setLeftSliderValue((mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8));
        } else {
            this.setRightSliderValue((mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8));
        }
    }

    protected void func_230983_a_(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.leftSliderValue == this.rightSliderValue && !this.stopped) {
            boolean bl = this.isLeftSelected = dragX < 0.0;
        }
        if (this.isLeftSelected) {
            this.setLeftSliderValue((mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8));
        } else {
            this.setRightSliderValue((mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8));
        }
        this.stopped = this.leftSliderValue == this.rightSliderValue;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            if (flag) {
                if (this.leftSliderValue != 0.0) {
                    this.setLeftSliderValue(Util.clamp(this.getLeftSliderValue() - (double)this.stepSize, this.minValue, this.maxValue, this.stepSize));
                    this.setRightSliderValue(Util.clamp(this.getRightSliderValue() - (double)this.stepSize, this.minValue, this.maxValue, this.stepSize));
                }
            } else if (this.rightSliderValue != 1.0) {
                this.setRightSliderValue(Util.clamp(this.getRightSliderValue() + (double)this.stepSize, this.minValue, this.maxValue, this.stepSize));
                this.setLeftSliderValue(Util.clamp(this.getLeftSliderValue() + (double)this.stepSize, this.minValue, this.maxValue, this.stepSize));
            }
        }
        return false;
    }

    @Override
    public void updateValue() {
        if ((double)this.leftValueSupplier.get().floatValue() != this.getLeftSliderValue()) {
            this.leftSliderValue = Util.clamp(this.leftValueSupplier.get().floatValue(), this.minValue, this.maxValue, this.stepSize);
        }
        if ((double)this.rightValueSupplier.get().floatValue() != this.getRightSliderValue()) {
            this.rightSliderValue = Util.clamp(this.rightValueSupplier.get().floatValue(), this.minValue, this.maxValue, this.stepSize);
        }
        this.updateMessage();
    }

    private void setLeftSliderValue(double value) {
        double d0 = this.leftSliderValue;
        this.leftSliderValue = Util.toValue(MathHelper.func_151237_a((double)value, (double)0.0, (double)this.rightSliderValue), this.minValue, this.maxValue, this.stepSize);
        if (d0 != this.leftSliderValue) {
            this.setLeftValueFunction.accept(Float.valueOf((float)this.getLeftSliderValue()));
            this.applyValue();
        }
        this.updateMessage();
    }

    private double getLeftSliderValue() {
        return this.leftSliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    private void setRightSliderValue(double value) {
        double d0 = this.rightSliderValue;
        this.rightSliderValue = Util.toValue(MathHelper.func_151237_a((double)value, (double)this.leftSliderValue, (double)1.0), this.minValue, this.maxValue, this.stepSize);
        if (d0 != this.rightSliderValue) {
            this.setRightValueFunction.accept(Float.valueOf((float)this.getRightSliderValue()));
            this.applyValue();
        }
        this.updateMessage();
    }

    private double getRightSliderValue() {
        return this.rightSliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    public void func_230988_a_(SoundHandler handler) {
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        super.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
    }

    @Override
    protected void updateMessage() {
        this.func_238482_a_((ITextComponent)new StringTextComponent("").func_230529_a_(this.prefix).func_240702_b_(": ").func_240702_b_(this.format.format(this.getLeftSliderValue())).func_240702_b_(this.suffix.getString().isEmpty() ? "" : " ").func_230529_a_(this.suffix).func_240702_b_(" - ").func_240702_b_(this.format.format(this.getRightSliderValue())).func_240702_b_(this.suffix.getString().isEmpty() ? "" : " ").func_230529_a_(this.suffix));
    }

    protected IFormattableTextComponent func_230442_c_() {
        return new TranslationTextComponent("gui.narrate.slider", new Object[]{this.func_230458_i_()});
    }
}

