/*
 * Decompiled with CFR 0.152.
 */
package platinpython.vfxgenerator.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import platinpython.vfxgenerator.client.gui.widget.UpdateableWidget;
import platinpython.vfxgenerator.util.Util;

public class FloatSlider
extends UpdateableWidget {
    private double sliderValue;
    private final double minValue;
    private final double maxValue;
    private final float stepSize;
    private final DecimalFormat format;
    private final ITextComponent prefix;
    private final ITextComponent suffix;
    private final Consumer<Float> setValueFunction;
    private final Supplier<Float> valueSupplier;

    public FloatSlider(int x, int y, int width, int height, ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, float stepSize, Consumer<Float> setValueFunction, Supplier<Float> valueSupplier, Util.VoidFunction applyValueFunction) {
        super(x, y, width, height, applyValueFunction);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = stepSize;
        this.format = Float.toString(this.stepSize).split("\\.")[1].length() == 1 && Float.toString(this.stepSize).split("\\.")[1].equals("0") ? new DecimalFormat("0") : new DecimalFormat(Float.toString(this.stepSize).replaceAll("\\d", "0"));
        this.prefix = prefix;
        this.suffix = suffix;
        this.setValueFunction = setValueFunction;
        this.valueSupplier = valueSupplier;
        this.setupSliderValues(this.valueSupplier.get().floatValue());
    }

    private void setupSliderValues(double value) {
        this.sliderValue = Util.clamp(value, this.minValue, this.maxValue, this.stepSize);
        this.setValueFunction.accept(Float.valueOf((float)this.getSliderValue()));
        this.applyValue();
        this.updateMessage();
    }

    protected int func_230989_a_(boolean isHovered) {
        return 0;
    }

    private int getYImageNoDisabled(boolean isHovered) {
        if (!this.field_230693_o_) {
            return 1;
        }
        return isHovered ? 2 : 1;
    }

    protected void func_230441_a_(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_238474_b_(matrixStack, this.field_230690_l_ + (int)(this.sliderValue * (double)(this.field_230688_j_ - 8)), this.field_230691_m_, 0, 46 + this.getYImageNoDisabled(this.func_230449_g_()) * 20, 4, this.field_230689_k_);
        this.func_238474_b_(matrixStack, this.field_230690_l_ + (int)(this.sliderValue * (double)(this.field_230688_j_ - 8)) + 4, this.field_230691_m_, 196, 46 + this.getYImageNoDisabled(this.func_230449_g_()) * 20, 4, this.field_230689_k_);
    }

    @Override
    public void updateValue() {
        if ((double)this.valueSupplier.get().floatValue() != this.getSliderValue()) {
            this.sliderValue = Util.clamp(this.valueSupplier.get().floatValue(), this.minValue, this.maxValue, this.stepSize);
        }
        this.updateMessage();
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8));
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void func_230983_a_(double mouseX, double mouseY, double dragX, double dragY) {
        this.setValueFromMouse(mouseX);
    }

    private void setSliderValue(double value) {
        double d0 = this.sliderValue;
        this.sliderValue = Util.toValue(value, this.minValue, this.maxValue, this.stepSize);
        if (d0 != this.sliderValue) {
            this.setValueFunction.accept(Float.valueOf((float)this.getSliderValue()));
            this.applyValue();
        }
        this.updateMessage();
    }

    private double getSliderValue() {
        return this.sliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    public void func_230988_a_(SoundHandler handler) {
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        super.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
    }

    @Override
    protected void updateMessage() {
        this.func_238482_a_((ITextComponent)new StringTextComponent("").func_230529_a_(this.prefix).func_240702_b_(": ").func_240702_b_(this.format.format(this.getSliderValue())).func_240702_b_(this.suffix.getString().isEmpty() ? "" : " ").func_230529_a_(this.suffix));
    }

    protected IFormattableTextComponent func_230442_c_() {
        return new TranslationTextComponent("gui.narrate.slider", new Object[]{this.func_230458_i_()});
    }
}

