/*
 * Decompiled with CFR 0.152.
 */
package platinpython.vfxgenerator.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.text.ITextComponent;
import platinpython.vfxgenerator.client.gui.widget.FloatRangeSlider;
import platinpython.vfxgenerator.client.gui.widget.FloatSlider;
import platinpython.vfxgenerator.client.gui.widget.MultipleStringChoiceButton;
import platinpython.vfxgenerator.client.gui.widget.ToggleTextButton;
import platinpython.vfxgenerator.client.gui.widget.UpdateableWidget;
import platinpython.vfxgenerator.util.Util;

public class VFXGeneratorOptionsList
extends AbstractOptionList<VFXGeneratorOptionsListEntry> {
    public VFXGeneratorOptionsList(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
        super(minecraft, width, height, top, bottom, itemHeight);
        this.func_244605_b(false);
    }

    public void addToggleButton(ITextComponent displayTextFalse, ITextComponent displayTextTrue, Consumer<Boolean> setValueFunction, Supplier<Boolean> valueSupplier, Util.VoidFunction applyValueFunction) {
        this.func_230513_b_((AbstractList.AbstractListEntry)VFXGeneratorOptionsListEntry.addToggleButton(this.field_230670_d_, displayTextFalse, displayTextTrue, setValueFunction, valueSupplier, applyValueFunction));
    }

    public void addMultipleChoiceButton(ImmutableList<String> options, Consumer<String> setValueFunction, Supplier<String> valueSupplier, Util.VoidFunction applyValueFunction) {
        this.func_230513_b_((AbstractList.AbstractListEntry)VFXGeneratorOptionsListEntry.addMultipleChoiceButton(this.field_230670_d_, options, setValueFunction, valueSupplier, applyValueFunction));
    }

    public void addSlider(ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, float stepSize, Consumer<Float> setValueFunction, Supplier<Float> valueSupplier, Util.VoidFunction applyValueFunction) {
        this.func_230513_b_((AbstractList.AbstractListEntry)VFXGeneratorOptionsListEntry.addSlider(this.field_230670_d_, prefix, suffix, minValue, maxValue, stepSize, setValueFunction, valueSupplier, applyValueFunction));
    }

    public void addRangeSlider(ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, float stepSize, Consumer<Float> setLeftValueFunction, Consumer<Float> setRightValueFunction, Supplier<Float> leftValueSupplier, Supplier<Float> rightValueSupplier, Util.VoidFunction applyValueFunction) {
        this.func_230513_b_((AbstractList.AbstractListEntry)VFXGeneratorOptionsListEntry.addRangeSlider(this.field_230670_d_, prefix, suffix, minValue, maxValue, stepSize, setLeftValueFunction, setRightValueFunction, leftValueSupplier, rightValueSupplier, applyValueFunction));
    }

    public void addToggleableRangeSlider(float stepSize, ITextComponent prefixFirst, ITextComponent suffixFirst, double minValueFirst, double maxValueFirst, Consumer<Float> setLeftValueFunctionFirst, Consumer<Float> setRightValueFunctionFirst, Supplier<Float> leftValueSupplierFirst, Supplier<Float> rightValueSupplierFirst, ITextComponent prefixSecond, ITextComponent suffixSecond, double minValueSecond, double maxValueSecond, Consumer<Float> setLeftValueFunctionSecond, Consumer<Float> setRightValueFunctionSecond, Supplier<Float> leftValueSupplierSecond, Supplier<Float> rightValueSupplierSecond, Util.VoidFunction applyValueFunction, Supplier<Boolean> toggleValueSupplier) {
        this.func_230513_b_((AbstractList.AbstractListEntry)ToggleableVFXGeneratorOptionsListEntry.addToggleableRangeSlider(this.field_230670_d_, stepSize, prefixFirst, suffixFirst, minValueFirst, maxValueFirst, setLeftValueFunctionFirst, setRightValueFunctionFirst, leftValueSupplierFirst, rightValueSupplierFirst, prefixSecond, suffixSecond, minValueSecond, maxValueSecond, setLeftValueFunctionSecond, setRightValueFunctionSecond, leftValueSupplierSecond, rightValueSupplierSecond, applyValueFunction, toggleValueSupplier));
    }

    public int func_230949_c_() {
        return 400;
    }

    protected int func_230952_d_() {
        return super.func_230952_d_() + 32;
    }

    public static class ToggleableVFXGeneratorOptionsListEntry
    extends VFXGeneratorOptionsListEntry {
        private final UpdateableWidget firstChild;
        private final UpdateableWidget secondChild;
        private final Supplier<Boolean> toggleValueSupplier;

        public ToggleableVFXGeneratorOptionsListEntry(UpdateableWidget firstChild, UpdateableWidget secondChild, Supplier<Boolean> toggleValueSupplier) {
            super(firstChild);
            this.firstChild = firstChild;
            this.secondChild = secondChild;
            this.toggleValueSupplier = toggleValueSupplier;
            this.updateValue();
        }

        public static ToggleableVFXGeneratorOptionsListEntry addToggleableRangeSlider(int guiWidth, float stepSize, ITextComponent prefixFirst, ITextComponent suffixFirst, double minValueFirst, double maxValueFirst, Consumer<Float> setLeftValueFunctionFirst, Consumer<Float> setRightValueFunctionFirst, Supplier<Float> leftValueSupplierFirst, Supplier<Float> rightValueSupplierFirst, ITextComponent prefixSecond, ITextComponent suffixSecond, double minValueSecond, double maxValueSecond, Consumer<Float> setLeftValueFunctionSecond, Consumer<Float> setRightValueFunctionSecond, Supplier<Float> leftValueSupplierSecond, Supplier<Float> rightValueSupplierSecond, Util.VoidFunction applyValueFunction, Supplier<Boolean> toggleValueSupplier) {
            return new ToggleableVFXGeneratorOptionsListEntry(new FloatRangeSlider(guiWidth / 2 - 155, 0, 310, 20, prefixFirst, suffixFirst, minValueFirst, maxValueFirst, stepSize, setLeftValueFunctionFirst, setRightValueFunctionFirst, leftValueSupplierFirst, rightValueSupplierFirst, applyValueFunction), new FloatRangeSlider(guiWidth / 2 - 155, 0, 310, 20, prefixSecond, suffixSecond, minValueSecond, maxValueSecond, stepSize, setLeftValueFunctionSecond, setRightValueFunctionSecond, leftValueSupplierSecond, rightValueSupplierSecond, applyValueFunction), toggleValueSupplier);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            this.firstChild.field_230691_m_ = top;
            this.secondChild.field_230691_m_ = top;
            this.firstChild.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.secondChild.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void setActive(boolean active) {
            this.firstChild.field_230693_o_ = active;
            this.secondChild.field_230693_o_ = active;
        }

        @Override
        public void updateValue() {
            this.firstChild.updateValue();
            this.secondChild.updateValue();
            if (this.toggleValueSupplier.get().booleanValue()) {
                this.firstChild.field_230694_p_ = false;
                this.secondChild.field_230694_p_ = true;
            } else {
                this.firstChild.field_230694_p_ = true;
                this.secondChild.field_230694_p_ = false;
            }
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)((Object)this.firstChild), (Object)((Object)this.secondChild));
        }
    }

    public static class VFXGeneratorOptionsListEntry
    extends AbstractOptionList.Entry<VFXGeneratorOptionsListEntry> {
        private final UpdateableWidget child;

        private VFXGeneratorOptionsListEntry(UpdateableWidget child) {
            this.child = child;
        }

        public static VFXGeneratorOptionsListEntry addToggleButton(int guiWidth, ITextComponent displayTextFalse, ITextComponent displayTextTrue, Consumer<Boolean> setValueFunction, Supplier<Boolean> valueSupplier, Util.VoidFunction applyValueFunction) {
            return new VFXGeneratorOptionsListEntry(new ToggleTextButton(guiWidth / 2 - 155, 0, 310, 20, displayTextFalse, displayTextTrue, setValueFunction, valueSupplier, applyValueFunction));
        }

        public static VFXGeneratorOptionsListEntry addMultipleChoiceButton(int guiWidth, ImmutableList<String> options, Consumer<String> setValueFunction, Supplier<String> valueSupplier, Util.VoidFunction applyValueFunction) {
            return new VFXGeneratorOptionsListEntry(new MultipleStringChoiceButton(guiWidth / 2 - 155, 0, 310, 20, options, setValueFunction, valueSupplier, applyValueFunction));
        }

        public static VFXGeneratorOptionsListEntry addSlider(int guiWidth, ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, float stepSize, Consumer<Float> setValueFunction, Supplier<Float> valueSupplier, Util.VoidFunction applyValueFunction) {
            return new VFXGeneratorOptionsListEntry(new FloatSlider(guiWidth / 2 - 155, 0, 310, 20, prefix, suffix, minValue, maxValue, stepSize, setValueFunction, valueSupplier, applyValueFunction));
        }

        public static VFXGeneratorOptionsListEntry addRangeSlider(int guiWidth, ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, float stepSize, Consumer<Float> setLeftValueFunction, Consumer<Float> setRightValueFunction, Supplier<Float> leftValueSupplier, Supplier<Float> rightValueSupplier, Util.VoidFunction applyValueFunction) {
            return new VFXGeneratorOptionsListEntry(new FloatRangeSlider(guiWidth / 2 - 155, 0, 310, 20, prefix, suffix, minValue, maxValue, stepSize, setLeftValueFunction, setRightValueFunction, leftValueSupplier, rightValueSupplier, applyValueFunction));
        }

        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            this.child.field_230691_m_ = top;
            this.child.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        public void setActive(boolean active) {
            this.child.field_230693_o_ = active;
        }

        public void updateValue() {
            this.child.updateValue();
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)((Object)this.child));
        }
    }
}

