/*
 * Decompiled with CFR 0.152.
 */
package platinpython.vfxgenerator.tileentity;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import platinpython.vfxgenerator.block.VFXGeneratorBlock;
import platinpython.vfxgenerator.util.ClientUtils;
import platinpython.vfxgenerator.util.Color;
import platinpython.vfxgenerator.util.Constants;
import platinpython.vfxgenerator.util.registries.TileEntityRegistry;

public class VFXGeneratorTileEntity
extends TileEntity
implements ITickableTileEntity {
    private boolean particleEnabled = true;
    private String particleSelected = "circle";
    private boolean particleUseHSB = false;
    private int particleRGBColorBot = -16777216;
    private int particleRGBColorTop = -1;
    private float[] particleHSBColorBot = new float[]{0.0f, 0.0f, 0.0f};
    private float[] particleHSBColorTop = new float[]{1.0f, 1.0f, 1.0f};
    private int particleLifetimeBot = 20;
    private int particleLifetimeTop = 80;
    private float particleSizeBot = 1.0f;
    private float particleSizeTop = 3.0f;
    private float particleSpawnXBot = -1.0f;
    private float particleSpawnXTop = 1.0f;
    private float particleSpawnYBot = 0.0f;
    private float particleSpawnYTop = 0.0f;
    private float particleSpawnZBot = -1.0f;
    private float particleSpawnZTop = 1.0f;
    private float particleMotionXBot = -0.1f;
    private float particleMotionXTop = 0.1f;
    private float particleMotionYBot = 0.1f;
    private float particleMotionYTop = 0.1f;
    private float particleMotionZBot = -0.1f;
    private float particleMotionZTop = 0.1f;
    private int particleDelay = 5;
    private float particleGravity = 0.0f;
    private boolean particleCollision = false;

    public VFXGeneratorTileEntity() {
        super((TileEntityType)TileEntityRegistry.VFX_GENERATOR.get());
    }

    public void func_73660_a() {
        if (((Boolean)this.func_195044_w().func_177229_b((Property)VFXGeneratorBlock.INVERTED)).booleanValue() && !((Boolean)this.func_195044_w().func_177229_b((Property)VFXGeneratorBlock.POWERED)).booleanValue() || !((Boolean)this.func_195044_w().func_177229_b((Property)VFXGeneratorBlock.INVERTED)).booleanValue() && ((Boolean)this.func_195044_w().func_177229_b((Property)VFXGeneratorBlock.POWERED)).booleanValue()) {
            World world = this.func_145831_w();
            if (world.field_72995_K && this.particleEnabled && world.func_82737_E() % (long)this.particleDelay == 0L) {
                Random random = world.func_201674_k();
                int color = -16777216;
                color = this.particleUseHSB ? Color.getRandomHSBColor(random, this.particleHSBColorBot, this.particleHSBColorTop) : Color.getRandomRGBColor(random, this.particleRGBColorBot, this.particleRGBColorTop);
                int lifetime = Math.round((float)this.particleLifetimeBot + random.nextFloat() * (float)(this.particleLifetimeTop - this.particleLifetimeBot));
                float size = this.particleSizeBot + random.nextFloat() * (this.particleSizeTop - this.particleSizeBot);
                Vector3d pos = Vector3d.func_237489_a_((Vector3i)this.func_174877_v());
                double spawnX = pos.field_72450_a + (double)this.particleSpawnXBot + (double)(random.nextFloat() * (this.particleSpawnXTop - this.particleSpawnXBot));
                double spawnY = pos.field_72448_b + (double)this.particleSpawnYBot + (double)(random.nextFloat() * (this.particleSpawnYTop - this.particleSpawnYBot));
                double spawnZ = pos.field_72449_c + (double)this.particleSpawnZBot + (double)(random.nextFloat() * (this.particleSpawnZTop - this.particleSpawnZBot));
                pos = new Vector3d(spawnX, spawnY, spawnZ);
                double motionX = this.particleMotionXBot + random.nextFloat() * (this.particleMotionXTop - this.particleMotionXBot);
                double motionY = this.particleMotionYBot + random.nextFloat() * (this.particleMotionYTop - this.particleMotionYBot);
                double motionZ = this.particleMotionZBot + random.nextFloat() * (this.particleMotionZTop - this.particleMotionZBot);
                Vector3d motion = new Vector3d(motionX, motionY, motionZ);
                ClientUtils.addParticle(this.particleSelected, color, lifetime, size, pos, motion, this.particleGravity, this.particleCollision);
            }
        }
    }

    public CompoundNBT saveToTag(CompoundNBT tag) {
        tag.func_218657_a("particleData", (INBT)this.saveToParticleTag());
        return tag;
    }

    private CompoundNBT saveToParticleTag() {
        CompoundNBT particleTag = new CompoundNBT();
        particleTag.func_74757_a("enabled", this.isParticleEnabled());
        particleTag.func_74778_a("selected", this.getParticleSelected());
        particleTag.func_74757_a("useHSB", this.isParticleUseHSB());
        particleTag.func_74768_a("RGBColorBot", this.getParticleRGBColorBot());
        particleTag.func_74768_a("RGBColorTop", this.getParticleRGBColorTop());
        particleTag.func_74776_a("hueBot", this.getParticleHSBColorBot()[0]);
        particleTag.func_74776_a("saturationBot", this.getParticleHSBColorBot()[1]);
        particleTag.func_74776_a("brightnessBot", this.getParticleHSBColorBot()[2]);
        particleTag.func_74776_a("hueTop", this.getParticleHSBColorTop()[0]);
        particleTag.func_74776_a("saturationTop", this.getParticleHSBColorTop()[1]);
        particleTag.func_74776_a("brightnessTop", this.getParticleHSBColorTop()[2]);
        particleTag.func_74768_a("lifetimeBot", this.getParticleLifetimeBot());
        particleTag.func_74768_a("lifetimeTop", this.getParticleLifetimeTop());
        particleTag.func_74776_a("sizeBot", this.getParticleSizeBot());
        particleTag.func_74776_a("sizeTop", this.getParticleSizeTop());
        particleTag.func_74776_a("spawnXBot", this.getParticleSpawnXBot());
        particleTag.func_74776_a("spawnXTop", this.getParticleSpawnXTop());
        particleTag.func_74776_a("spawnYBot", this.getParticleSpawnYBot());
        particleTag.func_74776_a("spawnYTop", this.getParticleSpawnYTop());
        particleTag.func_74776_a("spawnZBot", this.getParticleSpawnZBot());
        particleTag.func_74776_a("spawnZTop", this.getParticleSpawnZTop());
        particleTag.func_74776_a("motionXBot", this.getParticleMotionXBot());
        particleTag.func_74776_a("motionXTop", this.getParticleMotionXTop());
        particleTag.func_74776_a("motionYBot", this.getParticleMotionYBot());
        particleTag.func_74776_a("motionYTop", this.getParticleMotionYTop());
        particleTag.func_74776_a("motionZBot", this.getParticleMotionZBot());
        particleTag.func_74776_a("motionZTop", this.getParticleMotionZTop());
        particleTag.func_74768_a("delay", this.getParticleDelay());
        particleTag.func_74776_a("gravity", this.getParticleGravity());
        particleTag.func_74757_a("collision", this.isParticleCollision());
        return particleTag;
    }

    public void loadFromTag(CompoundNBT tag) {
        this.loadFromParticleTag(tag.func_74775_l("particleData"));
    }

    private void loadFromParticleTag(CompoundNBT particleTag) {
        this.particleEnabled = particleTag.func_74767_n("enabled");
        this.particleSelected = Constants.ParticleConstants.PARTICLE_OPTIONS.contains((Object)particleTag.func_74779_i("selected")) ? particleTag.func_74779_i("selected") : "circle";
        this.particleUseHSB = particleTag.func_74767_n("useHSB");
        this.particleRGBColorBot = MathHelper.func_76125_a((int)particleTag.func_74762_e("RGBColorBot"), (int)-16777216, (int)-1);
        this.particleRGBColorTop = MathHelper.func_76125_a((int)particleTag.func_74762_e("RGBColorTop"), (int)-16777216, (int)-1);
        this.particleHSBColorBot[0] = MathHelper.func_76131_a((float)particleTag.func_74760_g("hueBot"), (float)0.0f, (float)1.0f);
        this.particleHSBColorBot[1] = MathHelper.func_76131_a((float)particleTag.func_74760_g("saturationBot"), (float)0.0f, (float)1.0f);
        this.particleHSBColorBot[2] = MathHelper.func_76131_a((float)particleTag.func_74760_g("brightnessBot"), (float)0.0f, (float)1.0f);
        this.particleHSBColorTop[0] = MathHelper.func_76131_a((float)particleTag.func_74760_g("hueTop"), (float)0.0f, (float)1.0f);
        this.particleHSBColorTop[1] = MathHelper.func_76131_a((float)particleTag.func_74760_g("saturationTop"), (float)0.0f, (float)1.0f);
        this.particleHSBColorTop[2] = MathHelper.func_76131_a((float)particleTag.func_74760_g("brightnessTop"), (float)0.0f, (float)1.0f);
        this.particleLifetimeBot = MathHelper.func_76125_a((int)particleTag.func_74762_e("lifetimeBot"), (int)0, (int)200);
        this.particleLifetimeTop = MathHelper.func_76125_a((int)particleTag.func_74762_e("lifetimeTop"), (int)0, (int)200);
        this.particleSizeBot = MathHelper.func_76131_a((float)particleTag.func_74760_g("sizeBot"), (float)0.0f, (float)50.0f);
        this.particleSizeTop = MathHelper.func_76131_a((float)particleTag.func_74760_g("sizeTop"), (float)0.0f, (float)50.0f);
        this.particleSpawnXBot = MathHelper.func_76131_a((float)particleTag.func_74760_g("spawnXBot"), (float)-20.0f, (float)20.0f);
        this.particleSpawnXTop = MathHelper.func_76131_a((float)particleTag.func_74760_g("spawnXTop"), (float)-20.0f, (float)20.0f);
        this.particleSpawnYBot = MathHelper.func_76131_a((float)particleTag.func_74760_g("spawnYBot"), (float)-20.0f, (float)20.0f);
        this.particleSpawnYTop = MathHelper.func_76131_a((float)particleTag.func_74760_g("spawnYTop"), (float)-20.0f, (float)20.0f);
        this.particleSpawnZBot = MathHelper.func_76131_a((float)particleTag.func_74760_g("spawnZBot"), (float)-20.0f, (float)20.0f);
        this.particleSpawnZTop = MathHelper.func_76131_a((float)particleTag.func_74760_g("spawnZTop"), (float)-20.0f, (float)20.0f);
        this.particleMotionXBot = MathHelper.func_76131_a((float)particleTag.func_74760_g("motionXBot"), (float)-3.0f, (float)3.0f);
        this.particleMotionXTop = MathHelper.func_76131_a((float)particleTag.func_74760_g("motionXTop"), (float)-3.0f, (float)3.0f);
        this.particleMotionYBot = MathHelper.func_76131_a((float)particleTag.func_74760_g("motionYBot"), (float)-3.0f, (float)3.0f);
        this.particleMotionYTop = MathHelper.func_76131_a((float)particleTag.func_74760_g("motionYTop"), (float)-3.0f, (float)3.0f);
        this.particleMotionZBot = MathHelper.func_76131_a((float)particleTag.func_74760_g("motionZBot"), (float)-3.0f, (float)3.0f);
        this.particleMotionZTop = MathHelper.func_76131_a((float)particleTag.func_74760_g("motionZTop"), (float)-3.0f, (float)3.0f);
        this.particleDelay = MathHelper.func_76125_a((int)particleTag.func_74762_e("delay"), (int)1, (int)200);
        this.particleGravity = MathHelper.func_76131_a((float)particleTag.func_74760_g("gravity"), (float)-2.0f, (float)2.0f);
        this.particleCollision = particleTag.func_74767_n("collision");
        this.ensureParticleDataOrder();
    }

    private void ensureParticleDataOrder() {
        this.particleRGBColorBot = MathHelper.func_76125_a((int)this.getParticleRGBColorBot(), (int)-16777216, (int)this.getParticleRGBColorTop());
        this.particleRGBColorTop = MathHelper.func_76125_a((int)this.getParticleRGBColorTop(), (int)this.getParticleRGBColorBot(), (int)-1);
        this.particleHSBColorBot[0] = MathHelper.func_76131_a((float)this.getParticleHSBColorBot()[0], (float)0.0f, (float)this.getParticleHSBColorTop()[0]);
        this.particleHSBColorBot[1] = MathHelper.func_76131_a((float)this.getParticleHSBColorBot()[1], (float)0.0f, (float)this.getParticleHSBColorTop()[1]);
        this.particleHSBColorBot[2] = MathHelper.func_76131_a((float)this.getParticleHSBColorBot()[2], (float)0.0f, (float)this.getParticleHSBColorTop()[2]);
        this.particleHSBColorTop[0] = MathHelper.func_76131_a((float)this.getParticleHSBColorTop()[0], (float)this.getParticleHSBColorBot()[0], (float)1.0f);
        this.particleHSBColorTop[1] = MathHelper.func_76131_a((float)this.getParticleHSBColorTop()[1], (float)this.getParticleHSBColorBot()[1], (float)1.0f);
        this.particleHSBColorTop[2] = MathHelper.func_76131_a((float)this.getParticleHSBColorTop()[2], (float)this.getParticleHSBColorBot()[2], (float)1.0f);
        this.particleLifetimeBot = MathHelper.func_76125_a((int)this.getParticleLifetimeBot(), (int)0, (int)this.getParticleLifetimeTop());
        this.particleLifetimeTop = MathHelper.func_76125_a((int)this.getParticleLifetimeTop(), (int)this.getParticleLifetimeBot(), (int)200);
        this.particleSizeBot = MathHelper.func_76131_a((float)this.getParticleSizeBot(), (float)0.0f, (float)this.getParticleSizeTop());
        this.particleSizeTop = MathHelper.func_76131_a((float)this.getParticleSizeTop(), (float)this.getParticleSizeBot(), (float)50.0f);
        this.particleSpawnXBot = MathHelper.func_76131_a((float)this.getParticleSpawnXBot(), (float)-20.0f, (float)this.getParticleSpawnXTop());
        this.particleSpawnXTop = MathHelper.func_76131_a((float)this.getParticleSpawnXTop(), (float)this.getParticleSpawnXBot(), (float)20.0f);
        this.particleSpawnYBot = MathHelper.func_76131_a((float)this.getParticleSpawnYBot(), (float)-20.0f, (float)this.getParticleSpawnYTop());
        this.particleSpawnYTop = MathHelper.func_76131_a((float)this.getParticleSpawnYTop(), (float)this.getParticleSpawnYBot(), (float)20.0f);
        this.particleSpawnZBot = MathHelper.func_76131_a((float)this.getParticleSpawnZBot(), (float)-20.0f, (float)this.getParticleSpawnZTop());
        this.particleSpawnZTop = MathHelper.func_76131_a((float)this.getParticleSpawnZTop(), (float)this.getParticleSpawnZBot(), (float)20.0f);
        this.particleMotionXBot = MathHelper.func_76131_a((float)this.getParticleMotionXBot(), (float)-3.0f, (float)this.getParticleMotionXTop());
        this.particleMotionXTop = MathHelper.func_76131_a((float)this.getParticleMotionXTop(), (float)this.getParticleMotionXBot(), (float)3.0f);
        this.particleMotionYBot = MathHelper.func_76131_a((float)this.getParticleMotionYBot(), (float)-3.0f, (float)this.getParticleMotionYTop());
        this.particleMotionYTop = MathHelper.func_76131_a((float)this.getParticleMotionYTop(), (float)this.getParticleMotionYBot(), (float)3.0f);
        this.particleMotionZBot = MathHelper.func_76131_a((float)this.getParticleMotionZBot(), (float)-3.0f, (float)this.getParticleMotionZTop());
        this.particleMotionZTop = MathHelper.func_76131_a((float)this.getParticleMotionZTop(), (float)this.getParticleMotionZBot(), (float)3.0f);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        return super.func_189515_b(this.saveToTag(tag));
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.loadFromTag(tag);
        super.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.saveToTag(super.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.loadFromTag(tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.saveToTag(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.loadFromTag(pkt.func_148857_g());
    }

    public boolean isParticleEnabled() {
        return this.particleEnabled;
    }

    public void setParticleEnabled(boolean particleEnabled) {
        this.particleEnabled = particleEnabled;
        this.func_70296_d();
    }

    public String getParticleSelected() {
        return this.particleSelected;
    }

    public void setParticleSelected(String particleSelected) {
        this.particleSelected = Constants.ParticleConstants.PARTICLE_OPTIONS.contains((Object)particleSelected) ? particleSelected : "circle";
        this.func_70296_d();
    }

    public boolean isParticleUseHSB() {
        return this.particleUseHSB;
    }

    public void setParticleUseHSB(boolean particleUseHSB) {
        this.particleUseHSB = particleUseHSB;
        this.func_70296_d();
    }

    public int getParticleRGBColorBot() {
        return this.particleRGBColorBot;
    }

    public void setParticleRGBColorBot(int particleRGBColorBot) {
        this.particleRGBColorBot = MathHelper.func_76125_a((int)particleRGBColorBot, (int)-16777216, (int)this.getParticleRGBColorTop());
        this.func_70296_d();
    }

    public int getParticleRGBColorTop() {
        return this.particleRGBColorTop;
    }

    public void setParticleRGBColorTop(int particleRGBColorTop) {
        this.particleRGBColorTop = MathHelper.func_76125_a((int)particleRGBColorTop, (int)this.getParticleRGBColorBot(), (int)-1);
        this.func_70296_d();
    }

    public float[] getParticleHSBColorBot() {
        return this.particleHSBColorBot;
    }

    public void setParticleHSBColorBot(float[] particleHSBColorBot) {
        this.particleHSBColorBot[0] = MathHelper.func_76131_a((float)particleHSBColorBot[0], (float)0.0f, (float)this.getParticleHSBColorTop()[0]);
        this.particleHSBColorBot[1] = MathHelper.func_76131_a((float)particleHSBColorBot[1], (float)0.0f, (float)this.getParticleHSBColorTop()[1]);
        this.particleHSBColorBot[2] = MathHelper.func_76131_a((float)particleHSBColorBot[2], (float)0.0f, (float)this.getParticleHSBColorTop()[2]);
        this.func_70296_d();
    }

    public float[] getParticleHSBColorTop() {
        return this.particleHSBColorTop;
    }

    public void setParticleHSBColorTop(float[] particleHSBColorTop) {
        this.particleHSBColorTop[0] = MathHelper.func_76131_a((float)particleHSBColorTop[0], (float)this.getParticleHSBColorBot()[0], (float)1.0f);
        this.particleHSBColorTop[1] = MathHelper.func_76131_a((float)particleHSBColorTop[1], (float)this.getParticleHSBColorBot()[1], (float)1.0f);
        this.particleHSBColorTop[2] = MathHelper.func_76131_a((float)particleHSBColorTop[2], (float)this.getParticleHSBColorBot()[2], (float)1.0f);
        this.func_70296_d();
    }

    public int getParticleLifetimeBot() {
        return this.particleLifetimeBot;
    }

    public void setParticleLifetimeBot(int particleLifetimeBot) {
        this.particleLifetimeBot = MathHelper.func_76125_a((int)particleLifetimeBot, (int)0, (int)this.getParticleLifetimeTop());
        this.func_70296_d();
    }

    public int getParticleLifetimeTop() {
        return this.particleLifetimeTop;
    }

    public void setParticleLifetimeTop(int particleLifetimeTop) {
        this.particleLifetimeTop = MathHelper.func_76125_a((int)particleLifetimeTop, (int)this.getParticleLifetimeBot(), (int)200);
        this.func_70296_d();
    }

    public float getParticleSizeBot() {
        return this.particleSizeBot;
    }

    public void setParticleSizeBot(float particleSizeBot) {
        this.particleSizeBot = MathHelper.func_76131_a((float)particleSizeBot, (float)0.0f, (float)this.getParticleSizeTop());
        this.func_70296_d();
    }

    public float getParticleSizeTop() {
        return this.particleSizeTop;
    }

    public void setParticleSizeTop(float particleSizeTop) {
        this.particleSizeTop = MathHelper.func_76131_a((float)particleSizeTop, (float)this.getParticleSizeBot(), (float)50.0f);
        this.func_70296_d();
    }

    public float getParticleSpawnXBot() {
        return this.particleSpawnXBot;
    }

    public void setParticleSpawnXBot(float particleSpawnXBot) {
        this.particleSpawnXBot = MathHelper.func_76131_a((float)particleSpawnXBot, (float)-20.0f, (float)this.getParticleSpawnXTop());
        this.func_70296_d();
    }

    public float getParticleSpawnXTop() {
        return this.particleSpawnXTop;
    }

    public void setParticleSpawnXTop(float particleSpawnXTop) {
        this.particleSpawnXTop = MathHelper.func_76131_a((float)particleSpawnXTop, (float)this.getParticleSpawnXBot(), (float)20.0f);
        this.func_70296_d();
    }

    public float getParticleSpawnYBot() {
        return this.particleSpawnYBot;
    }

    public void setParticleSpawnYBot(float particleSpawnYBot) {
        this.particleSpawnYBot = MathHelper.func_76131_a((float)particleSpawnYBot, (float)-20.0f, (float)this.getParticleSpawnYTop());
        this.func_70296_d();
    }

    public float getParticleSpawnYTop() {
        return this.particleSpawnYTop;
    }

    public void setParticleSpawnYTop(float particleSpawnYTop) {
        this.particleSpawnYTop = MathHelper.func_76131_a((float)particleSpawnYTop, (float)this.getParticleSpawnYBot(), (float)20.0f);
        this.func_70296_d();
    }

    public float getParticleSpawnZBot() {
        return this.particleSpawnZBot;
    }

    public void setParticleSpawnZBot(float particleSpawnZBot) {
        this.particleSpawnZBot = MathHelper.func_76131_a((float)particleSpawnZBot, (float)-20.0f, (float)this.getParticleSpawnZTop());
        this.func_70296_d();
    }

    public float getParticleSpawnZTop() {
        return this.particleSpawnZTop;
    }

    public void setParticleSpawnZTop(float particleSpawnZTop) {
        this.particleSpawnZTop = MathHelper.func_76131_a((float)particleSpawnZTop, (float)this.getParticleSpawnZBot(), (float)20.0f);
        this.func_70296_d();
    }

    public float getParticleMotionXBot() {
        return this.particleMotionXBot;
    }

    public void setParticleMotionXBot(float particleMotionXBot) {
        this.particleMotionXBot = MathHelper.func_76131_a((float)particleMotionXBot, (float)-3.0f, (float)this.getParticleMotionXTop());
        this.func_70296_d();
    }

    public float getParticleMotionXTop() {
        return this.particleMotionXTop;
    }

    public void setParticleMotionXTop(float particleMotionXTop) {
        this.particleMotionXTop = MathHelper.func_76131_a((float)particleMotionXTop, (float)this.getParticleMotionXBot(), (float)3.0f);
        this.func_70296_d();
    }

    public float getParticleMotionYBot() {
        return this.particleMotionYBot;
    }

    public void setParticleMotionYBot(float particleMotionYBot) {
        this.particleMotionYBot = MathHelper.func_76131_a((float)particleMotionYBot, (float)-3.0f, (float)this.getParticleMotionYTop());
        this.func_70296_d();
    }

    public float getParticleMotionYTop() {
        return this.particleMotionYTop;
    }

    public void setParticleMotionYTop(float particleMotionYTop) {
        this.particleMotionYTop = MathHelper.func_76131_a((float)particleMotionYTop, (float)this.getParticleMotionYBot(), (float)3.0f);
        this.func_70296_d();
    }

    public float getParticleMotionZBot() {
        return this.particleMotionZBot;
    }

    public void setParticleMotionZBot(float particleMotionZBot) {
        this.particleMotionZBot = MathHelper.func_76131_a((float)particleMotionZBot, (float)-3.0f, (float)this.getParticleMotionZTop());
        this.func_70296_d();
    }

    public float getParticleMotionZTop() {
        return this.particleMotionZTop;
    }

    public void setParticleMotionZTop(float particleMotionZTop) {
        this.particleMotionZTop = MathHelper.func_76131_a((float)particleMotionZTop, (float)this.getParticleMotionZBot(), (float)3.0f);
        this.func_70296_d();
    }

    public int getParticleDelay() {
        return this.particleDelay;
    }

    public void setParticleDelay(int particleDelay) {
        this.particleDelay = MathHelper.func_76125_a((int)particleDelay, (int)1, (int)200);
        this.func_70296_d();
    }

    public float getParticleGravity() {
        return this.particleGravity;
    }

    public void setParticleGravity(float particleGravity) {
        this.particleGravity = MathHelper.func_76131_a((float)particleGravity, (float)-2.0f, (float)2.0f);
        this.func_70296_d();
    }

    public boolean isParticleCollision() {
        return this.particleCollision;
    }

    public void setParticleCollision(boolean particleCollision) {
        this.particleCollision = particleCollision;
        this.func_70296_d();
    }
}

