/*
 * Decompiled with CFR 0.152.
 */
package platinpython.vfxgenerator.util;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import platinpython.vfxgenerator.client.gui.screen.VFXGeneratorScreen;
import platinpython.vfxgenerator.client.particle.VFXParticle;
import platinpython.vfxgenerator.tileentity.VFXGeneratorTileEntity;
import platinpython.vfxgenerator.util.Constants;
import platinpython.vfxgenerator.util.registries.BlockRegistry;

@Mod.EventBusSubscriber(modid="vfxgenerator", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientUtils {
    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)BlockRegistry.VFX_GENERATOR.get()), (RenderType)RenderType.func_228643_e_());
        event.enqueueWork(() -> ItemModelsProperties.func_239418_a_((Item)((Block)BlockRegistry.VFX_GENERATOR.get()).func_199767_j(), (ResourceLocation)new ResourceLocation("vfxgenerator", "inverted"), (stack, world, entity) -> Boolean.valueOf(stack.func_190925_c("BlockStateTag").func_74779_i("inverted")) != false ? 1.0f : 0.0f));
    }

    @SubscribeEvent
    public static void onTextureStich(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)AtlasTexture.field_215262_g)) {
            Constants.ParticleConstants.PARTICLE_OPTIONS.forEach(option -> event.addSprite(new ResourceLocation("vfxgenerator", "particle/" + option)));
        }
    }

    public static void addParticle(String spriteName, int color, int lifetime, float size, Vector3d pos, Vector3d motion, float gravity, boolean collision) {
        Minecraft minecraft = Minecraft.func_71410_x();
        VFXParticle particle = new VFXParticle(minecraft.field_71441_e, minecraft.field_71452_i.field_215243_j.func_195424_a(new ResourceLocation("vfxgenerator", "particle/" + spriteName)), color, lifetime, size, pos, motion, gravity, collision);
        minecraft.field_71452_i.func_78873_a((Particle)particle);
    }

    public static void openVFXGeneratorScreen(VFXGeneratorTileEntity tileEntity) {
        Minecraft.func_71410_x().func_147108_a((Screen)new VFXGeneratorScreen(tileEntity));
    }

    public static TranslationTextComponent getGuiTranslationTextComponent(String suffix) {
        return new TranslationTextComponent("gui.vfxgenerator." + suffix);
    }
}

