/*
 * Decompiled with CFR 0.152.
 */
package platinpython.vfxgenerator.util;

import java.util.Random;

public class Color {
    private int value;

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, int a) {
        this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        this.testColorValueRange(r, g, b, a);
    }

    public Color(int rgb) {
        this.value = 0xFF000000 | rgb;
    }

    private void testColorValueRange(int r, int g, int b, int a) {
        boolean rangeError = false;
        String badComponentString = "";
        if (a < 0 || a > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Alpha";
        }
        if (r < 0 || r > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Red";
        }
        if (g < 0 || g > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Green";
        }
        if (b < 0 || b > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Blue";
        }
        if (rangeError) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + badComponentString);
        }
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public static float[] RGBtoHSB(int r, int g, int b) {
        float hue;
        int cmin;
        int cmax;
        float[] hsbvals = new float[3];
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public static Color getHSBColor(float h, float s, float b) {
        return new Color(Color.HSBtoRGB(h, s, b));
    }

    public float[] getRGBColorComponents() {
        float[] components = new float[]{(float)this.getRed() / 255.0f, (float)this.getGreen() / 255.0f, (float)this.getBlue() / 255.0f};
        return components;
    }

    public static int getRandomRGBColor(Random random, int color1, int color2) {
        int r = Math.round(random.nextFloat() * (float)((color2 >> 16 & 0xFF) - (color1 >> 16 & 0xFF)) + (float)(color1 >> 16 & 0xFF));
        int g = Math.round(random.nextFloat() * (float)((color2 >> 8 & 0xFF) - (color1 >> 8 & 0xFF)) + (float)(color1 >> 8 & 0xFF));
        int b = Math.round(random.nextFloat() * (float)((color2 >> 0 & 0xFF) - (color1 >> 0 & 0xFF)) + (float)(color1 >> 0 & 0xFF));
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public static int getRandomHSBColor(Random random, float[] hsb1, float[] hsb2) {
        float hue = random.nextFloat() * (hsb2[0] - hsb1[0]) + hsb1[0];
        float saturation = random.nextFloat() * (hsb2[1] - hsb1[1]) + hsb1[1];
        float brightness = random.nextFloat() * (hsb2[2] - hsb1[2]) + hsb1[2];
        return Color.HSBtoRGB(hue, saturation, brightness);
    }
}

