/*
 * Decompiled with CFR 0.152.
 */
package platinpython.vfxgenerator.util.network.packets;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;
import platinpython.vfxgenerator.util.ClientUtils;
import platinpython.vfxgenerator.util.Color;

public class VFXGeneratorDestroyParticlesPKT {
    private final Vector3d pos;

    public VFXGeneratorDestroyParticlesPKT(Vector3d pos) {
        this.pos = pos;
    }

    public static void encode(VFXGeneratorDestroyParticlesPKT message, PacketBuffer buffer) {
        buffer.writeDouble(message.pos.field_72450_a);
        buffer.writeDouble(message.pos.field_72448_b);
        buffer.writeDouble(message.pos.field_72449_c);
    }

    public static VFXGeneratorDestroyParticlesPKT decode(PacketBuffer buffer) {
        return new VFXGeneratorDestroyParticlesPKT(new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));
    }

    public static class Handler {
        public static void handle(VFXGeneratorDestroyParticlesPKT message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)context.get()).getDirection().getOriginationSide().isServer()) {
                    Random random = new Random();
                    for (int i = 0; i < 100; ++i) {
                        double motionX = random.nextFloat() * 0.2f - 0.1f;
                        double motionY = random.nextFloat() * 0.2f - 0.1f;
                        double motionZ = random.nextFloat() * 0.2f - 0.1f;
                        Vector3d motion = new Vector3d(motionX, motionY, motionZ);
                        ClientUtils.addParticle("circle", Color.HSBtoRGB(random.nextFloat(), 1.0f, 1.0f), Math.round(5.0f + random.nextFloat() * 10.0f), 0.3f, message.pos, motion, 0.0f, false);
                    }
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

