/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.ward_blocks.util;

import com.google.common.collect.Lists;
import com.kwpugh.ward_blocks.init.BlockInit;
import java.util.List;
import net.fabricmc.fabric.api.loot.v1.FabricLootPoolBuilder;
import net.fabricmc.fabric.api.loot.v1.FabricLootSupplierBuilder;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_55;
import net.minecraft.class_59;
import net.minecraft.class_77;
import net.minecraft.class_79;
import org.apache.commons.lang3.ArrayUtils;

public class WardBlocksLootTables {
    private static final List<LootTableInsert> INSERTS = Lists.newArrayList();

    public static void init() {
        FabricLootPoolBuilder GROWTH_WARD_BLOCK = FabricLootPoolBuilder.builder().rolls((class_59)class_44.method_289((int)1)).with((class_79.class_80)class_77.method_411((class_1935)BlockInit.GROWTH_WARD_BLOCK)).withCondition(class_219.method_932((float)0.05f).build());
        WardBlocksLootTables.insert(new LootTableInsert(GROWTH_WARD_BLOCK, new class_2960("minecraft", "chests/buried_treasure")));
        LootTableLoadingCallback.EVENT.register((resourceManager, lootManager, identifier, supplier, lootTableSetter) -> INSERTS.forEach(i -> {
            if (ArrayUtils.contains((Object[])i.tables, (Object)identifier)) {
                i.insert(supplier);
            }
        }));
        FabricLootPoolBuilder HEALTH_WARD_BLOCK = FabricLootPoolBuilder.builder().rolls((class_59)class_44.method_289((int)1)).with((class_79.class_80)class_77.method_411((class_1935)BlockInit.HEALTH_WARD_BLOCK)).withCondition(class_219.method_932((float)0.05f).build());
        WardBlocksLootTables.insert(new LootTableInsert(HEALTH_WARD_BLOCK, new class_2960("minecraft", "chests/buried_treasure")));
        LootTableLoadingCallback.EVENT.register((resourceManager, lootManager, identifier, supplier, lootTableSetter) -> INSERTS.forEach(i -> {
            if (ArrayUtils.contains((Object[])i.tables, (Object)identifier)) {
                i.insert(supplier);
            }
        }));
        FabricLootPoolBuilder DEFENSE_WARD_BLOCK = FabricLootPoolBuilder.builder().rolls((class_59)class_44.method_289((int)1)).with((class_79.class_80)class_77.method_411((class_1935)BlockInit.DEFENSE_WARD_BLOCK)).withCondition(class_219.method_932((float)0.05f).build());
        WardBlocksLootTables.insert(new LootTableInsert(DEFENSE_WARD_BLOCK, new class_2960("minecraft", "chests/pillager_outpost")));
        LootTableLoadingCallback.EVENT.register((resourceManager, lootManager, identifier, supplier, lootTableSetter) -> INSERTS.forEach(i -> {
            if (ArrayUtils.contains((Object[])i.tables, (Object)identifier)) {
                i.insert(supplier);
            }
        }));
        FabricLootPoolBuilder EXP_WARD_BLOCK = FabricLootPoolBuilder.builder().rolls((class_59)class_44.method_289((int)1)).with((class_79.class_80)class_77.method_411((class_1935)BlockInit.EXP_WARD_BLOCK)).withCondition(class_219.method_932((float)0.1f).build());
        WardBlocksLootTables.insert(new LootTableInsert(EXP_WARD_BLOCK, new class_2960("minecraft", "chests/stronghold_library")));
        LootTableLoadingCallback.EVENT.register((resourceManager, lootManager, identifier, supplier, lootTableSetter) -> INSERTS.forEach(i -> {
            if (ArrayUtils.contains((Object[])i.tables, (Object)identifier)) {
                i.insert(supplier);
            }
        }));
        FabricLootPoolBuilder ATTACK_WARD_BLOCK = FabricLootPoolBuilder.builder().rolls((class_59)class_44.method_289((int)1)).with((class_79.class_80)class_77.method_411((class_1935)BlockInit.ATTACK_WARD_BLOCK)).withCondition(class_219.method_932((float)0.1f).build());
        WardBlocksLootTables.insert(new LootTableInsert(ATTACK_WARD_BLOCK, new class_2960("minecraft", "chests/bastion_treasure")));
        LootTableLoadingCallback.EVENT.register((resourceManager, lootManager, identifier, supplier, lootTableSetter) -> INSERTS.forEach(i -> {
            if (ArrayUtils.contains((Object[])i.tables, (Object)identifier)) {
                i.insert(supplier);
            }
        }));
        FabricLootPoolBuilder LOOT_WARD_BLOCK = FabricLootPoolBuilder.builder().rolls((class_59)class_44.method_289((int)1)).with((class_79.class_80)class_77.method_411((class_1935)BlockInit.LOOT_WARD_BLOCK)).withCondition(class_219.method_932((float)0.1f).build());
        WardBlocksLootTables.insert(new LootTableInsert(LOOT_WARD_BLOCK, new class_2960("minecraft", "chests/end_city_treasure")));
        LootTableLoadingCallback.EVENT.register((resourceManager, lootManager, identifier, supplier, lootTableSetter) -> INSERTS.forEach(i -> {
            if (ArrayUtils.contains((Object[])i.tables, (Object)identifier)) {
                i.insert(supplier);
            }
        }));
    }

    public static void insert(LootTableInsert insert) {
        INSERTS.add(insert);
    }

    public static class LootTableInsert {
        public final class_2960[] tables;
        public final FabricLootPoolBuilder lootPool;

        public LootTableInsert(FabricLootPoolBuilder lootPool, class_2960 ... tables) {
            this.tables = tables;
            this.lootPool = lootPool;
        }

        public void insert(FabricLootSupplierBuilder supplier) {
            supplier.pool((class_55.class_56)this.lootPool);
        }
    }
}

