/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.config;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class WeaponThrowConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Server SERVER;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue enableCustom;
        public final ForgeConfigSpec.BooleanValue notUseWhenCooldown;
        public final ForgeConfigSpec.DoubleValue baseDamageDefault;
        public final ForgeConfigSpec.DoubleValue baseVelocityDefault;
        public final ForgeConfigSpec.DoubleValue pickaxeMultiplier;
        public final ForgeConfigSpec.DoubleValue axeMultiplier;
        public final ForgeConfigSpec.DoubleValue swordMultiplier;
        public final ForgeConfigSpec.DoubleValue hoeMultiplier;
        public final ForgeConfigSpec.DoubleValue shovelMultiplier;
        public final ForgeConfigSpec.DoubleValue baseDamageMultiplier;
        public final ForgeConfigSpec.DoubleValue stackDamageMultiplier;
        public final ForgeConfigSpec.DoubleValue modifiedDamageMultiplier;
        public final ForgeConfigSpec.DoubleValue baseVelocityMultiplier;
        public final ForgeConfigSpec.DoubleValue stackVelocityMultiplier;
        public final ForgeConfigSpec.DoubleValue modifiedVelocityMultiplier;
        public final ForgeConfigSpec.DoubleValue baseExhaustionMultiplier;
        public final ForgeConfigSpec.DoubleValue stackExhaustionMultiplier;
        public final ForgeConfigSpec.DoubleValue modifiedExhaustionMultiplier;
        public final ForgeConfigSpec.BooleanValue enablePMMOIntegration;
        public final ForgeConfigSpec.IntValue requiredCombatLoyalty;
        public final ForgeConfigSpec.BooleanValue canBreakBlocks;
        public final ForgeConfigSpec.BooleanValue shouldThrowItemsToo;
        public final ForgeConfigSpec.BooleanValue enchantAll;
        public final ForgeConfigSpec.BooleanValue throwEnchant;
        public final ForgeConfigSpec.BooleanValue conccusionEnchant;
        public final ForgeConfigSpec.BooleanValue groundedEdgeEnchant;
        public final ForgeConfigSpec.BooleanValue gravityEnchant;
        public final ForgeConfigSpec.BooleanValue gravityDrop;
        public final ForgeConfigSpec.BooleanValue returnEnchant;
        public final ForgeConfigSpec.IntValue despawnTime;
        public final ForgeConfigSpec.DoubleValue castTimeMultplier;
        public final ForgeConfigSpec.IntValue ticksUntilWeaponLoseOwner;
        public final WhiteListedItems whiteList;
        public final BlackListedBlocks blackList;
        public final NoRollListedItems noRollList;
        public final ForgeConfigSpec.DoubleValue fixedRoll;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Weapon Throw Mod Configuration Settings").push("general");
            this.enableCustom = builder.comment("Enable this if you want to apply your configuration").define("Enable Custom Values", true);
            this.notUseWhenCooldown = builder.comment("Weapon Cant be thrown if it is on cooldown").define("Not Throw If Cooldown", false);
            this.noRollList = new NoRollListedItems(builder);
            this.fixedRoll = builder.comment("Angle used for no roll list").defineInRange("Default Roll Angle", 90.0, 0.0, 356.0);
            builder.pop();
            builder.comment("If an item is whitelisted and doesn't have damage or attack speed, this values will be assigned").push("default");
            this.baseDamageDefault = builder.defineInRange("Default Base Damage", 1.0, 0.0, 256.0);
            this.baseVelocityDefault = builder.defineInRange("Default Base Velocity", 2.0, 0.0, 256.0);
            builder.pop();
            builder.push("enchantments");
            this.enchantAll = builder.comment("If this is enabled, all tools can be applied mod enchantments too").define("Enchant All", false);
            this.throwEnchant = builder.comment("Should Throw Enchantment be applied on survival?").define("Enable Throw Enchantment", true);
            this.conccusionEnchant = builder.comment("Should Conccusion Enchantment be applied on survival?").define("Enable Conccusion Enchantment", true);
            this.groundedEdgeEnchant = builder.comment("Should Grounded Edge Enchantment be applied on survival?").define("Enable Grounded Edge Enchantment", true);
            this.gravityEnchant = builder.comment("Should Gravity Enchantment be applied on survival?").define("Enable Gravity Enchantment", true);
            this.gravityDrop = builder.comment("Should gravity curse drop after some time?").define("Gravity Drop", false);
            this.returnEnchant = builder.comment("Should Return Enchantment be applied on survival?").define("Enable Return Enchantment", true);
            builder.pop();
            builder.push("experimental");
            this.shouldThrowItemsToo = builder.comment("Enable using all items as a weapon").define("Throw all items", false);
            builder.pop();
            builder.push("interactions");
            this.canBreakBlocks = builder.comment("Throwing can break blocks at landing?").define("Break Blocks", true);
            builder.pop();
            builder.push("multipliers");
            builder.comment("Specific multipliers for tools, multitools use the average from each tool that represents").push("tools");
            this.pickaxeMultiplier = builder.defineInRange("Pickaxe Multiplier", 0.8, 0.0, 256.0);
            this.axeMultiplier = builder.defineInRange("Axe Multiplier", 1.2, 0.0, 256.0);
            this.swordMultiplier = builder.defineInRange("Sword Multiplier", 1.0, 0.0, 256.0);
            this.hoeMultiplier = builder.defineInRange("Hoe Multiplier", 1.3, 0.0, 256.0);
            this.shovelMultiplier = builder.defineInRange("Shovel Multiplier", 0.9, 0.0, 256.0);
            builder.pop();
            builder.comment("Nultiplicative to the base damage of an item").push("damage");
            this.baseDamageMultiplier = builder.defineInRange("Base Damage Multiplier", 0.25, 0.0, 256.0);
            this.stackDamageMultiplier = builder.defineInRange("Stack Size Damage Multiplier", 0.0, 0.0, 256.0);
            this.modifiedDamageMultiplier = builder.defineInRange("Modified Damage Multiplier", 0.5, 0.0, 256.0);
            builder.pop();
            builder.comment("Multiplicative to the base attack speed of the item").push("velocity");
            this.baseVelocityMultiplier = builder.defineInRange("Base Velocity Multiplier", 0.25, 0.0, 64.0);
            this.stackVelocityMultiplier = builder.defineInRange("Stack Size Velocity Multiplier", 0.005, 0.0, 64.0);
            this.modifiedVelocityMultiplier = builder.defineInRange("Modified Velocity Multiplier", 0.4, 0.0, 64.0);
            builder.pop();
            builder.comment("Inversely multiplicative to the base attack speed of item").push("exhaustion");
            this.baseExhaustionMultiplier = builder.defineInRange("Base Exhaustion Multiplier", 0.075, 0.0, 256.0);
            this.stackExhaustionMultiplier = builder.defineInRange("Stack Size Exhaustion Multiplier", 0.01, 0.0, 256.0);
            this.modifiedExhaustionMultiplier = builder.defineInRange("Modified Exhaustion Multiplier", 2.0, 0.0, 256.0);
            builder.pop();
            builder.pop();
            builder.comment("Integration with Project MMO").push("pmmo");
            this.enablePMMOIntegration = builder.comment("Disable this if running Minecraft 1.16.3 and below").define("Enable PMMO Integration", true);
            this.requiredCombatLoyalty = builder.comment("Minimum Level Required to use Loyalty, 0 is none").defineInRange("Loyalty Requirement", 10, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("time");
            this.despawnTime = builder.comment("Time in ticks when the throwed items should dissapear").defineInRange("Despawn Time", 1200, 0, Integer.MAX_VALUE);
            this.castTimeMultplier = builder.comment("Attack Speed Multiplier to charging").defineInRange("Charging Multiplier", 3.0, 0.0, 256.0);
            this.ticksUntilWeaponLoseOwner = builder.comment("Time in ticks when throwed items lose their owner").defineInRange("Lose Owner Time", 140, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("All Items Whitelisted will get default values").push("whitelist-items");
            this.whiteList = new WhiteListedItems(builder);
            builder.pop();
            builder.comment("All Blacklisted blocks cannot be destroyed").push("blacklist-blocks");
            this.blackList = new BlackListedBlocks(builder);
            builder.pop();
        }

        public class NoRollListedItems
        extends ItemsList {
            NoRollListedItems(ForgeConfigSpec.Builder builder) {
                super(builder, "No Roll Items", "Stopping the rolling animation on the following items");
            }

            @Override
            public void initDefaults() {
                this.put(Items.f_42713_);
            }
        }

        public class WhiteListedItems
        extends ItemsList {
            WhiteListedItems(ForgeConfigSpec.Builder builder) {
                super(builder, "Whitelisted items", "Items here can be threw even if they are not weapons");
            }

            @Override
            public void initDefaults() {
                this.put(Items.f_42460_);
                this.put(Items.f_41904_);
            }
        }

        public class BlackListedBlocks
        extends ItemsList {
            BlackListedBlocks(ForgeConfigSpec.Builder builder) {
                super(builder, "Blacklisted blocks", "Items here cannot be broken with the pickaxe");
            }

            @Override
            public void initDefaults() {
                this.put(Items.f_42460_);
                this.put(Items.f_41829_);
            }
        }

        public abstract class ItemsList {
            private final Optional<HolderLookup.RegistryLookup<Item>> lookup;
            List<String> serializedDefaults = new ArrayList<String>();
            public ForgeConfigSpec.ConfigValue<List<? extends String>> whiteList;

            ItemsList(ForgeConfigSpec.Builder builder, String name, String comment) {
                this.initDefaults();
                this.lookup = VanillaRegistries.m_255371_().m_254861_(Registries.f_256913_);
                this.whiteList = builder.comment(comment).defineList(name, this.serializedDefaults, o -> o instanceof String);
            }

            public void put(String name) {
                this.serializedDefaults.add(name);
            }

            public void put(Item item) {
                this.serialize(new ItemStack((ItemLike)item));
            }

            public void put(Item item, Function<ItemStack, ItemStack> fn) {
                this.serialize(fn.apply(new ItemStack((ItemLike)item)));
            }

            private void serialize(ItemStack stack) {
                this.put(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString() + (stack.m_41783_() != null ? stack.m_41783_().m_7916_() : ""));
            }

            public List<ItemStack> get() {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                List selectedItems = (Boolean)WeaponThrowConfig.SERVER.enableCustom.get() != false && this.lookup.isPresent() ? (List)this.whiteList.get() : this.serializedDefaults;
                for (String entry : selectedItems) {
                    StringReader reader = new StringReader(entry);
                    try {
                        ItemParser.ItemResult itemparser = ItemParser.m_235305_((HolderLookup)((HolderLookup)this.lookup.get()), (StringReader)reader);
                        ItemInput input = new ItemInput(itemparser.f_235328_(), itemparser.f_235329_());
                        items.add(input.m_120980_(1, false));
                    }
                    catch (CommandSyntaxException commandSyntaxException) {}
                }
                return items;
            }

            public abstract void initDefaults();
        }
    }
}

