/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.events;

import com.dainxt.weaponthrow.projectile.WeaponThrowEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Cancelable;

public class WeaponThrowEvent
extends PlayerEvent {
    ItemStack throwedStack;

    public WeaponThrowEvent(ItemStack stack, Player player) {
        super(player);
        this.throwedStack = stack;
    }

    public ItemStack getThrowedStack() {
        return this.throwedStack;
    }

    @Cancelable
    public static class OnImpact
    extends WeaponThrowEvent {
        WeaponThrowEntity entity;
        HitResult rayTrace;

        public OnImpact(WeaponThrowEntity item, Player player, HitResult result) {
            super(item.getItemStack(), player);
            this.entity = item;
            this.rayTrace = result;
        }

        public WeaponThrowEntity getItemThrowed() {
            return this.entity;
        }

        public HitResult getRayTraceResult() {
            return this.rayTrace;
        }
    }

    public static class OnThrow
    extends WeaponThrowEvent {
        public double totalDamage;
        public double totalVelocity;
        public double totalExhaustion;

        public OnThrow(ItemStack stack, Player player, double damage, double velocity, double exhaustion) {
            super(stack, player);
            this.totalDamage = damage;
            this.totalVelocity = velocity;
            this.totalExhaustion = exhaustion;
        }
    }

    @Cancelable
    public static class TestThrow
    extends WeaponThrowEvent {
        public TestThrow(ItemStack stack, Player player) {
            super(stack, player);
        }
    }
}

