/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.coordinates.LocalCoordinates;
import net.minecraft.commands.arguments.coordinates.WorldCoordinate;

public abstract class Coordinate<T extends Number> {
    protected T value;
    protected Type type;

    protected Coordinate(T value) {
        this(value, Type.ABSOLUTE);
    }

    protected Coordinate(T value, Type type) {
        this.value = value;
        this.type = type;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    @Nullable
    public String serialize() {
        if (this.value == null) {
            return null;
        }
        if (this.zero().equals(this.value) && !Type.ABSOLUTE.equals((Object)this.type)) {
            return this.type.getPrefix();
        }
        return this.type.getPrefix() + this.value.toString();
    }

    public abstract T zero();

    public static enum Type {
        ABSOLUTE(""),
        RELATIVE("~"),
        LOCAL("^");

        private final String prefix;

        private Type(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public static class Doubles
    extends Coordinate<Double> {
        public static final Doubles ZERO = new Doubles();

        public Doubles() {
            super(0.0);
        }

        public Doubles(Double value) {
            super(value);
        }

        public Doubles(Type type) {
            super(0.0, type);
        }

        public Doubles(Double value, Type type) {
            super(value, type);
        }

        @Override
        public Double zero() {
            return 0.0;
        }

        @Nullable
        public static Doubles parse(String string) {
            try {
                StringReader reader = new StringReader(string);
                if (reader.canRead() && reader.peek() == '^') {
                    return new Doubles(LocalCoordinates.m_119908_((StringReader)reader, (int)0), Type.LOCAL);
                }
                WorldCoordinate wc = WorldCoordinate.m_120869_((StringReader)reader);
                return new Doubles(wc.m_120867_(0.0), wc.m_120866_() ? Type.RELATIVE : Type.ABSOLUTE);
            }
            catch (CommandSyntaxException e) {
                return null;
            }
        }
    }

    public static class Ints
    extends Coordinate<Integer> {
        public static final Ints ZERO = new Ints();

        public Ints() {
            super(0);
        }

        public Ints(Integer value) {
            super(value);
        }

        public Ints(Type type) {
            super(0, type);
        }

        public Ints(Integer value, Type type) {
            super(value, type);
        }

        @Override
        public Integer zero() {
            return 0;
        }

        @Nullable
        public static Ints parse(String string) {
            try {
                StringReader reader = new StringReader(string);
                if (reader.canRead() && reader.peek() == '^') {
                    return new Ints((int)LocalCoordinates.m_119908_((StringReader)reader, (int)0), Type.LOCAL);
                }
                WorldCoordinate wc = WorldCoordinate.m_120869_((StringReader)reader);
                return new Ints((int)wc.m_120867_(0.0), wc.m_120866_() ? Type.RELATIVE : Type.ABSOLUTE);
            }
            catch (CommandSyntaxException e) {
                return null;
            }
        }
    }
}

