/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.argument;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import exopandora.worldhandler.builder.argument.IDeserializableArgument;
import exopandora.worldhandler.builder.argument.tag.ITagProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;

public class TagArgument
implements IDeserializableArgument {
    private List<ITagProvider> providers;
    private CompoundTag tag;

    protected TagArgument() {
    }

    public void addTagProvider(ITagProvider provider) {
        if (this.providers == null) {
            this.providers = new ArrayList<ITagProvider>();
        }
        this.providers.add(provider);
    }

    public void setTag(@Nullable CompoundTag tag) {
        this.tag = tag;
    }

    @Nullable
    public CompoundTag getTag() {
        return this.tag;
    }

    @Override
    public void deserialize(@Nullable String string) {
        if (string != null) {
            try {
                this.tag = TagParser.m_129359_((String)string);
            }
            catch (CommandSyntaxException e) {
                this.tag = null;
            }
        } else {
            this.tag = null;
        }
    }

    @Override
    @Nullable
    public String serialize() {
        CompoundTag compound;
        if (this.tag == null && (this.providers == null || this.providers.isEmpty())) {
            return null;
        }
        CompoundTag compoundTag = compound = this.tag == null ? new CompoundTag() : this.tag.m_6426_();
        if (this.providers != null) {
            for (ITagProvider provider : this.providers) {
                Tag tag = provider.value();
                if (tag == null) continue;
                String key = provider.key();
                if (key != null) {
                    compound.m_128365_(key, tag);
                    continue;
                }
                if (!(tag instanceof CompoundTag)) continue;
                compound.m_128391_((CompoundTag)tag);
            }
        }
        if (compound.m_128456_()) {
            return null;
        }
        return compound.toString();
    }

    @Override
    public boolean isDefault() {
        return this.tag == null && (this.providers == null || this.providers.isEmpty() || this.providers.stream().allMatch(provider -> provider.value() == null));
    }
}

