/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.impl.ExperienceCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.button.GuiSlider;
import exopandora.worldhandler.gui.widget.button.LogicSliderSimple;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ContentExperience
extends Content {
    private final ExperienceCommandBuilder builderExperience = new ExperienceCommandBuilder();
    private final IContent.CommandPreview preview = new IContent.CommandPreview(this.builderExperience, null);
    private GuiButtonBase buttonAdd;
    private GuiButtonBase buttonRemove;

    public ContentExperience() {
        this.builderExperience.amount().set(0);
    }

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.preview;
    }

    @Override
    public void init(Container container) {
        if ((double)this.builderExperience.amount().get().intValue() > Config.getSliders().getMaxExperience()) {
            this.builderExperience.amount().set((int)Config.getSliders().getMaxExperience());
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        boolean enabled;
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        container.add(new GuiSlider(x + 58, y, 114, 20, 0.0, Config.getSliders().getMaxExperience(), 0.0, container, new LogicSliderSimple("experience", Component.m_237115_((String)"gui.worldhandler.title.player.experience"), value -> this.builderExperience.amount().set((Integer)value))));
        this.buttonAdd = new GuiButtonBase(x + 58, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.actions.add"), () -> {
            CommandHelper.sendCommand(container.getPlayer(), this.builderExperience, (Object)ExperienceCommandBuilder.Label.ADD_LEVELS);
            container.m_7856_();
        });
        container.add(this.buttonAdd);
        this.buttonRemove = new GuiButtonBase(x + 58, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.actions.remove"), () -> {
            ExperienceCommandBuilder builder = new ExperienceCommandBuilder();
            builder.targets().setTarget(this.builderExperience.targets().getTarget());
            builder.amount().set(-this.builderExperience.amount().get().intValue());
            CommandHelper.sendCommand(container.getPlayer(), builder, (Object)ExperienceCommandBuilder.Label.ADD_LEVELS);
        });
        container.add(this.buttonRemove);
        container.add(new GuiButtonTooltip(x + 58, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.actions.reset"), (Component)Component.m_237115_((String)"gui.worldhandler.actions.set_to_0"), () -> {
            ExperienceCommandBuilder builder = new ExperienceCommandBuilder();
            builder.amount().set(0);
            builder.targets().setTarget(this.builderExperience.targets().getTarget());
            CommandHelper.sendCommand(container.getPlayer(), builder, (Object)ExperienceCommandBuilder.Label.SET_POINTS);
        }));
        this.buttonAdd.f_93623_ = enabled = this.builderExperience.amount().get() > 0;
        this.buttonRemove.f_93623_ = enabled;
    }

    @Override
    public void tick(Container container) {
        boolean enabled;
        this.buttonAdd.f_93623_ = enabled = this.builderExperience.amount().get() > 0;
        this.buttonRemove.f_93623_ = enabled;
    }

    @Override
    public Category getCategory() {
        return Categories.PLAYER;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.player.experience");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.player.experience");
    }

    @Override
    public Content getActiveContent() {
        return Contents.EXPERIENCE;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderExperience.targets().setTarget(username);
    }
}

