/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.impl.LocateCommandBuilder;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.widget.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import exopandora.worldhandler.util.RegistryHelper;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ContentLocate
extends Content {
    private final LocateCommandBuilder builderLocate = new LocateCommandBuilder();
    private final IContent.CommandPreview previewLocateBiome = new IContent.CommandPreview(this.builderLocate, (Object)LocateCommandBuilder.Label.BIOME);
    private final IContent.CommandPreview previewLocateStructure = new IContent.CommandPreview(this.builderLocate, (Object)LocateCommandBuilder.Label.STRUCTURE);
    private final IContent.CommandPreview previewLocatePoi = new IContent.CommandPreview(this.builderLocate, (Object)LocateCommandBuilder.Label.POI);
    private Page page = Page.BIOME;

    @Override
    public IContent.CommandPreview getCommandPreview() {
        if (Page.BIOME.equals((Object)this.page)) {
            return this.previewLocateBiome;
        }
        if (Page.STRUCTURE.equals((Object)this.page)) {
            return this.previewLocateStructure;
        }
        if (Page.POI.equals((Object)this.page)) {
            return this.previewLocatePoi;
        }
        return null;
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        if (Page.BIOME.equals((Object)this.page)) {
            ArrayList biomes = new ArrayList(ForgeRegistries.BIOMES.getKeys());
            MenuPageList<ResourceLocation> list = new MenuPageList<ResourceLocation>(x + 118, y, biomes, 114, 20, 3, container, new ILogicPageList<ResourceLocation>(){

                @Override
                public MutableComponent translate(ResourceLocation biome) {
                    return Component.m_237115_((String)biome.m_214296_("biome"));
                }

                @Override
                public MutableComponent toTooltip(ResourceLocation biome) {
                    return Component.m_237113_((String)biome.toString());
                }

                @Override
                public void onClick(ResourceLocation biome) {
                    ContentLocate.this.builderLocate.biome().set(biome);
                    container.initButtons();
                }

                @Override
                public GuiButtonBase onRegister(int x, int y, int width, int height, MutableComponent text, ResourceLocation biome, ActionHandler actionHandler) {
                    return new GuiButtonTooltip(x, y, width, height, (Component)text, (Component)this.toTooltip(biome), actionHandler);
                }

                @Override
                public String getId() {
                    return "biomes";
                }
            });
            container.add(list);
        } else if (Page.STRUCTURE.equals((Object)this.page)) {
            ArrayList structures = new ArrayList(((Registry)((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_6632_(Registry.f_235725_).get()).m_6566_());
            MenuPageList<ResourceLocation> list = new MenuPageList<ResourceLocation>(x + 118, y, structures, 114, 20, 3, container, new ILogicPageList<ResourceLocation>(){

                @Override
                public MutableComponent translate(ResourceLocation structure) {
                    return Component.m_237113_((String)structure.toString());
                }

                @Override
                public MutableComponent toTooltip(ResourceLocation structure) {
                    return Component.m_237113_((String)structure.toString());
                }

                @Override
                public void onClick(ResourceLocation structure) {
                    ContentLocate.this.builderLocate.structure().set(structure);
                    container.initButtons();
                }

                @Override
                public GuiButtonBase onRegister(int x, int y, int width, int height, MutableComponent text, ResourceLocation structure, ActionHandler actionHandler) {
                    return new GuiButtonTooltip(x, y, width, height, (Component)text, (Component)this.toTooltip(structure), actionHandler);
                }

                @Override
                public String getId() {
                    return "structures";
                }
            });
            container.add(list);
        } else if (Page.POI.equals((Object)this.page)) {
            ArrayList pois = new ArrayList(ForgeRegistries.POI_TYPES.getKeys());
            MenuPageList<ResourceLocation> list = new MenuPageList<ResourceLocation>(x + 118, y, pois, 114, 20, 3, container, new ILogicPageList<ResourceLocation>(){

                @Override
                public MutableComponent translate(ResourceLocation poi) {
                    String result = RegistryHelper.translate(poi);
                    if (result != null) {
                        return Component.m_237115_((String)result);
                    }
                    return Component.m_237113_((String)poi.toString());
                }

                @Override
                public MutableComponent toTooltip(ResourceLocation poi) {
                    return Component.m_237113_((String)poi.toString());
                }

                @Override
                public void onClick(ResourceLocation poi) {
                    ContentLocate.this.builderLocate.poi().set(poi);
                    container.initButtons();
                }

                @Override
                public GuiButtonBase onRegister(int x, int y, int width, int height, MutableComponent text, ResourceLocation poi, ActionHandler actionHandler) {
                    return new GuiButtonTooltip(x, y, width, height, (Component)text, (Component)this.toTooltip(poi), actionHandler);
                }

                @Override
                public String getId() {
                    return "pois";
                }
            });
            container.add(list);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, "gui.worldhandler.generic.back", () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, "gui.worldhandler.generic.backToGame", ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, "gui.worldhandler.locate.biome", () -> this.changePage(container, Page.BIOME));
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, "gui.worldhandler.locate.structure", () -> this.changePage(container, Page.STRUCTURE));
        container.add(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, "gui.worldhandler.locate.poi", () -> this.changePage(container, Page.POI));
        container.add(button3);
        container.add(new GuiButtonBase(x, y + 72, 114, 20, "gui.worldhandler.locate.locate", () -> CommandHelper.sendCommand(container.getPlayer(), this.builderLocate, (Object)this.page.getLabel())));
        button1.f_93623_ = !Page.BIOME.equals((Object)this.page);
        button2.f_93623_ = !Page.STRUCTURE.equals((Object)this.page);
        button3.f_93623_ = !Page.POI.equals((Object)this.page);
    }

    private void changePage(Container container, Page page) {
        this.page = page;
        container.m_7856_();
    }

    @Override
    public Category getCategory() {
        return Categories.WORLD;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.world.locate");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.world.locate");
    }

    @Override
    public Content getActiveContent() {
        return Contents.LOCATE;
    }

    private static enum Page {
        BIOME(LocateCommandBuilder.Label.BIOME),
        STRUCTURE(LocateCommandBuilder.Label.STRUCTURE),
        POI(LocateCommandBuilder.Label.POI);

        private final LocateCommandBuilder.Label label;

        private Page(LocateCommandBuilder.Label label) {
            this.label = label;
        }

        public LocateCommandBuilder.Label getLabel() {
            return this.label;
        }
    }
}

