/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.argument.tag.CustomPotionEffectsTag;
import exopandora.worldhandler.builder.argument.tag.EffectInstance;
import exopandora.worldhandler.builder.impl.EffectCommandBuilder;
import exopandora.worldhandler.builder.impl.GiveCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.content.impl.ContentChild;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.button.GuiSlider;
import exopandora.worldhandler.gui.widget.button.LogicSliderSimple;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.widget.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import exopandora.worldhandler.util.TextUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class ContentPotions
extends ContentChild {
    private final EffectCommandBuilder builderPotion = new EffectCommandBuilder();
    private final CustomPotionEffectsTag effects = new CustomPotionEffectsTag();
    private final GiveCommandBuilder builderPotionItem = new GiveCommandBuilder();
    private final IContent.CommandPreview preview = new IContent.CommandPreview().add(this.builderPotion, (Object)EffectCommandBuilder.Label.GIVE_SECONDS_AMPLIFIER_HIDEPARTICLES).add(this.builderPotionItem, (Object)GiveCommandBuilder.Label.GIVE_COUNT);
    private int potionPage;

    public ContentPotions() {
        this.builderPotionItem.item().addTagProvider(this.effects);
        this.builderPotion.amplifier().set((byte)0);
        this.builderPotion.hideParticles().set(false);
    }

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.preview;
    }

    @Override
    public void init(Container container) {
        if ((double)this.builderPotion.amplifier().get().byteValue() > Config.getSliders().getMaxPotionAmplifier()) {
            this.builderPotion.amplifier().set((byte)Config.getSliders().getMaxPotionAmplifier());
        }
        for (MobEffect effect : this.effects.getMobEffects()) {
            EffectInstance tag = this.effects.getOrCreate(effect);
            if (!((double)tag.getAmplifier() > Config.getSliders().getMaxPotionAmplifier())) continue;
            tag.setAmplifier((byte)Config.getSliders().getMaxPotionAmplifier());
        }
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        MenuPageList<MobEffect> potions = new MenuPageList<MobEffect>(x, y, new ArrayList(ForgeRegistries.MOB_EFFECTS.getValues()), 114, 20, 3, container, new ILogicPageList<MobEffect>(){

            @Override
            public MutableComponent translate(MobEffect effect) {
                return Component.m_237115_((String)effect.m_19481_());
            }

            @Override
            public MutableComponent toTooltip(MobEffect effect) {
                return Component.m_237113_((String)ForgeRegistries.MOB_EFFECTS.getKey((Object)effect).toString());
            }

            @Override
            public void onClick(MobEffect effect) {
                ContentPotions.this.builderPotion.effect().set(effect);
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, MutableComponent text, MobEffect effect, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, (Component)text, (Component)this.toTooltip(effect), actionHandler);
            }

            @Override
            public String getId() {
                return "potions";
            }
        });
        container.add(potions);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        GuiButtonBase button1;
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        if (this.potionPage == 0) {
            container.add(new GuiButtonBase(x + 118, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.potions.effect.give"), () -> this.next(container)));
            container.add(new GuiButtonBase(x + 118, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.potions.effect.remove"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotion, (Object)EffectCommandBuilder.Label.CLEAR_TARGETS_EFFECT);
                container.m_7856_();
            }));
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.potions.effect.remove_all"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotion, (Object)EffectCommandBuilder.Label.CLEAR);
                container.m_7856_();
            }));
            container.add(new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.actions.reset_all"), () -> {
                this.builderPotion.amplifier().set((byte)1);
                this.builderPotion.seconds().set(0);
                this.builderPotion.hideParticles().set(false);
                this.effects.clear();
                this.resetPersistence();
                container.m_7856_();
            }));
        } else if (this.potionPage == 1) {
            MobEffect effect = this.builderPotion.effect().getEffect();
            EffectInstance tag = this.effects.getOrCreate(effect);
            container.add(new GuiButtonBase(x + 118, y + 24, 114, 20, (Component)Component.m_237110_((String)"gui.worldhandler.potions.effect.ambient", (Object[])new Object[]{tag.isAmbient() ? Component.m_237115_((String)"gui.worldhandler.generic.on") : Component.m_237115_((String)"gui.worldhandler.generic.off")}), () -> {
                tag.setAmbient(!tag.isAmbient());
                container.m_7856_();
            }));
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)Component.m_237110_((String)"gui.worldhandler.potions.effect.particles", (Object[])new Object[]{this.builderPotion.hideParticles().get() != false ? Component.m_237115_((String)"gui.worldhandler.generic.off") : Component.m_237115_((String)"gui.worldhandler.generic.on")}), () -> {
                this.builderPotion.hideParticles().set(this.builderPotion.hideParticles().get() == false);
                tag.setShowParticles(!tag.doShowParticles());
                container.m_7856_();
            }));
            container.add(new GuiSlider(x + 118, y, 114, 20, 1.0, Config.getSliders().getMaxPotionAmplifier(), 1.0, container, new LogicSliderSimple("amplifier" + ForgeRegistries.MOB_EFFECTS.getKey((Object)effect), Component.m_237115_((String)"gui.worldhandler.potions.effect.amplifier"), value -> {
                this.builderPotion.amplifier().set((byte)(value.byteValue() - 1));
                tag.setAmplifier(value.byteValue());
            })));
        } else if (this.potionPage == 2) {
            MobEffect effect = this.builderPotion.effect().getEffect();
            EffectInstance tag = this.effects.getOrCreate(effect);
            container.add(new GuiSlider(x + 118, y, 114, 20, 0.0, 59.0, 0.0, container, new LogicSliderSimple("s" + ForgeRegistries.MOB_EFFECTS.getKey((Object)effect), Component.m_237115_((String)"gui.worldhandler.potion.time.seconds"), value -> {
                tag.setSeconds((int)value);
                this.builderPotion.seconds().set(tag.toSeconds());
            })));
            container.add(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, 59.0, 0.0, container, new LogicSliderSimple("m" + ForgeRegistries.MOB_EFFECTS.getKey((Object)effect), Component.m_237115_((String)"gui.worldhandler.potion.time.minutes"), value -> {
                tag.setMinutes((int)value);
                this.builderPotion.seconds().set(tag.toSeconds());
            })));
            container.add(new GuiSlider(x + 118, y + 48, 114, 20, 0.0, 99.0, 0.0, container, new LogicSliderSimple("h" + ForgeRegistries.MOB_EFFECTS.getKey((Object)effect), Component.m_237115_((String)"gui.worldhandler.potion.time.hours"), value -> {
                tag.setHours((int)value);
                this.builderPotion.seconds().set(tag.toSeconds());
            })));
        } else if (this.potionPage == 3) {
            boolean enabled;
            button1 = new GuiButtonBase(x + 118, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.potions.effect"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotion, (Object)EffectCommandBuilder.Label.GIVE_SECONDS_AMPLIFIER_HIDEPARTICLES);
                this.potionPage = 0;
                container.m_7856_();
            });
            container.add(button1);
            GuiButtonTooltip button2 = new GuiButtonTooltip(x + 118, y + 24, 56, 20, (Component)Component.m_237115_((String)"gui.worldhandler.potions.effect.tipped_arrow"), (Component)Component.m_237115_((String)"gui.worldhandler.potions.effect.hold_shift_to_apply_all_effects_at_once"), () -> {
                this.giveItem(container.getPlayer(), Items.f_42738_, 0.125f, Screen.m_96638_());
                this.potionPage = 0;
                container.m_7856_();
            });
            container.add(button2);
            GuiButtonTooltip button3 = new GuiButtonTooltip(x + 178, y + 24, 55, 20, (Component)Component.m_237115_((String)"gui.worldhandler.potions.effect.bottle"), (Component)Component.m_237115_((String)"gui.worldhandler.potions.effect.hold_shift_to_apply_all_effects_at_once"), () -> {
                this.giveItem(container.getPlayer(), Items.f_42589_, 1.0f, Screen.m_96638_());
                this.potionPage = 0;
                container.m_7856_();
            });
            container.add(button3);
            GuiButtonTooltip button4 = new GuiButtonTooltip(x + 118, y + 48, 56, 20, (Component)Component.m_237115_((String)"gui.worldhandler.potions.effect.splash"), (Component)Component.m_237115_((String)"gui.worldhandler.potions.effect.hold_shift_to_apply_all_effects_at_once"), () -> {
                this.giveItem(container.getPlayer(), Items.f_42736_, 1.0f, Screen.m_96638_());
                this.potionPage = 0;
                container.m_7856_();
            });
            container.add(button4);
            GuiButtonTooltip button5 = new GuiButtonTooltip(x + 178, y + 48, 55, 20, (Component)Component.m_237115_((String)"gui.worldhandler.potions.effect.lingering"), (Component)Component.m_237115_((String)"gui.worldhandler.potions.effect.hold_shift_to_apply_all_effects_at_once"), () -> {
                this.giveItem(container.getPlayer(), Items.f_42739_, 0.25f, Screen.m_96638_());
                this.potionPage = 0;
                container.m_7856_();
            });
            container.add(button5);
            button1.f_93623_ = enabled = this.builderPotion.amplifier().get() >= 0 && this.builderPotion.seconds().get() > 0;
            button2.f_93623_ = enabled;
            button3.f_93623_ = enabled;
            button4.f_93623_ = enabled;
            button5.f_93623_ = enabled;
        }
        if (this.potionPage > 0) {
            container.add(new GuiButtonBase(x + 118, y + 72, 56, 20, TextUtils.ARROW_LEFT, () -> {
                --this.potionPage;
                container.m_7856_();
            }));
            button1 = new GuiButtonBase(x + 118 + 60, y + 72, 55, 20, TextUtils.ARROW_RIGHT, () -> this.next(container));
            container.add(button1);
            button1.f_93623_ = this.potionPage < 3;
        }
    }

    private void next(Container container) {
        ++this.potionPage;
        container.m_7856_();
    }

    private void giveItem(String player, Item item, float modifier, boolean applyAllEffects) {
        CustomPotionEffectsTag effects = new CustomPotionEffectsTag();
        if (applyAllEffects) {
            for (MobEffect effect : this.effects.getMobEffects()) {
                System.out.println(effect);
                EffectInstance source = this.effects.getOrCreate(effect);
                EffectInstance target = effects.getOrCreate(effect);
                source.copyTo(target, modifier);
            }
        } else {
            MobEffect effect = this.builderPotion.effect().getEffect();
            EffectInstance source = this.effects.getOrCreate(effect);
            EffectInstance target = effects.getOrCreate(effect);
            source.copyTo(target, modifier);
        }
        GiveCommandBuilder builder = new GiveCommandBuilder();
        builder.targets().setTarget(this.builderPotionItem.targets().getTarget());
        builder.item().set(item);
        builder.item().addTagProvider(effects);
        CommandHelper.sendCommand(player, builder, (Object)GiveCommandBuilder.Label.GIVE);
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.potions");
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderPotion.targets().setTarget(username);
        this.builderPotionItem.targets().setTarget(username);
    }
}

