/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.UsercontentCommandBuilder;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.usercontent.ScriptEngineAdapter;
import exopandora.worldhandler.usercontent.UsercontentAPI;
import exopandora.worldhandler.usercontent.UsercontentConfig;
import exopandora.worldhandler.usercontent.VisibleActiveObject;
import exopandora.worldhandler.usercontent.VisibleObject;
import exopandora.worldhandler.usercontent.factory.ActionHandlerFactory;
import exopandora.worldhandler.usercontent.factory.MenuFactory;
import exopandora.worldhandler.usercontent.factory.WidgetFactory;
import exopandora.worldhandler.usercontent.model.AbstractJsonWidget;
import exopandora.worldhandler.usercontent.model.JsonCommand;
import exopandora.worldhandler.usercontent.model.JsonLabel;
import exopandora.worldhandler.usercontent.model.JsonMenu;
import exopandora.worldhandler.usercontent.model.JsonUsercontent;
import exopandora.worldhandler.usercontent.model.JsonWidget;
import exopandora.worldhandler.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ContentUsercontent
extends Content {
    private final String id;
    private final JsonUsercontent content;
    private final ScriptEngineAdapter engineAdapter;
    private final Map<String, VisibleObject<UsercontentCommandBuilder>> builders;
    private final Map<String, VisibleActiveObject<EditBox>> textfields = new HashMap<String, VisibleActiveObject<EditBox>>();
    private final List<VisibleActiveObject<AbstractWidget>> widgets = new ArrayList<VisibleActiveObject<AbstractWidget>>();
    private final UsercontentAPI api;
    private final WidgetFactory widgetFactory;
    private final MenuFactory menuFactory;

    public ContentUsercontent(UsercontentConfig config) throws Exception {
        this.id = config.getId();
        this.content = config.getContent();
        this.engineAdapter = new ScriptEngineAdapter(config.getScriptEngine());
        this.builders = this.createBuilders(this.content.getCommands());
        this.api = new UsercontentAPI(this.builders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (UsercontentCommandBuilder)((VisibleObject)entry.getValue()).get())));
        ActionHandlerFactory actionHandlerFactory = new ActionHandlerFactory(this.api, this.builders, this.engineAdapter);
        this.widgetFactory = new WidgetFactory(this.api, actionHandlerFactory);
        this.menuFactory = new MenuFactory(this.api, actionHandlerFactory);
        this.engineAdapter.addObject("api", this.api);
        this.engineAdapter.eval(config.getJs());
    }

    @Override
    public IContent.CommandPreview getCommandPreview() {
        List<UsercontentCommandBuilder> builders = this.builders.values().stream().filter(builder -> builder.isVisible(this.engineAdapter)).map(VisibleObject::get).collect(Collectors.toList());
        if (builders.isEmpty()) {
            return null;
        }
        IContent.CommandPreview preview = new IContent.CommandPreview();
        builders.forEach(builder -> preview.add((ICommandBuilder)builder, builder.getLabel()));
        return preview;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.textfields.clear();
        this.widgets.clear();
        for (JsonWidget json : this.getWidgets(this.content.getGui().getWidgets(), AbstractJsonWidget.Type.BUTTON)) {
            AbstractWidget widget = this.widgetFactory.createWidget(json, this, container, x, y);
            if (JsonWidget.Type.TEXTFIELD.equals((Object)json.getType())) {
                VisibleActiveObject<EditBox> visObj = new VisibleActiveObject<EditBox>(json, (EditBox)widget);
                this.textfields.put(json.getAttributes().getId(), visObj);
                continue;
            }
            this.widgets.add(new VisibleActiveObject<AbstractWidget>(json, widget));
        }
        for (JsonMenu menu : this.getWidgets(this.content.getGui().getMenus(), AbstractJsonWidget.Type.MENU)) {
            container.add(this.menuFactory.createMenu(menu, this, container, x, y));
        }
        this.updateTextfields();
        this.updateButtons();
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        Stream.concat(this.textfields.values().stream(), this.widgets.stream()).map(VisibleObject::get).forEach(container::add);
    }

    @Override
    public void tick(Container container) {
        for (VisibleObject visibleObject : this.textfields.values()) {
            if (!visibleObject.isVisible(this.engineAdapter)) continue;
            ((EditBox)visibleObject.get()).m_94120_();
        }
        this.updateButtons();
        this.updateTextfields();
    }

    @Override
    public void drawScreen(PoseStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        for (VisibleObject visibleObject : this.textfields.values()) {
            if (!((EditBox)visibleObject.get()).f_93624_) continue;
            ((EditBox)visibleObject.get()).m_6303_(matrix, mouseX, mouseY, partialTicks);
        }
        if (this.content.getGui() != null && this.content.getGui().getLabels() != null) {
            for (JsonLabel jsonLabel : this.content.getGui().getLabels()) {
                if (jsonLabel.getVisible() != null && !jsonLabel.getVisible().eval(this.engineAdapter)) continue;
                container.getMinecraft().f_91062_.m_92889_(matrix, (Component)TextUtils.formatNonnull(jsonLabel.getText(), new Object[0]), (float)(jsonLabel.getX() + x), (float)(jsonLabel.getY() + y), jsonLabel.getColor());
            }
        }
    }

    @Override
    public Category getCategory() {
        return Categories.getRegisteredCategory(this.content.getGui().getTab().getCategory());
    }

    @Override
    public MutableComponent getTitle() {
        return TextUtils.formatNonnull(this.content.getGui().getTitle(), new Object[0]);
    }

    @Override
    public MutableComponent getTabTitle() {
        return TextUtils.formatNonnull(this.content.getGui().getTab().getTitle(), new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        if (this.content.getGui().getTab().getActiveContent() == null) {
            return this;
        }
        return Contents.getRegisteredContent(this.content.getGui().getTab().getActiveContent());
    }

    @Override
    public Content getBackContent() {
        if (this.content.getGui().getTab().getActiveContent() == null) {
            return super.getBackContent();
        }
        return Contents.getRegisteredContent(this.content.getGui().getTab().getBackContent());
    }

    @Override
    public void onPlayerNameChanged(String username) {
        for (VisibleObject<UsercontentCommandBuilder> visObj : this.builders.values()) {
            visObj.get().setPlayerName(username);
        }
    }

    private Map<String, VisibleObject<UsercontentCommandBuilder>> createBuilders(Map<String, JsonCommand> commands) {
        TreeMap<String, VisibleObject<UsercontentCommandBuilder>> builders = new TreeMap<String, VisibleObject<UsercontentCommandBuilder>>();
        if (commands != null) {
            for (Map.Entry<String, JsonCommand> command : commands.entrySet()) {
                JsonCommand root = command.getValue();
                if (root.getSyntax() == null) continue;
                root.getSyntax().validate();
                UsercontentCommandBuilder builder = new UsercontentCommandBuilder(root.getSyntax(), root.getLabel());
                builders.put(command.getKey(), new VisibleObject<UsercontentCommandBuilder>(root.getVisible(), builder));
            }
        }
        return builders;
    }

    private <T extends AbstractJsonWidget<?>> List<T> getWidgets(List<T> list, AbstractJsonWidget.Type type) {
        ArrayList<AbstractJsonWidget> result = new ArrayList<AbstractJsonWidget>();
        if (list == null) {
            return result;
        }
        for (int x = 0; x < list.size(); ++x) {
            AbstractJsonWidget widget = (AbstractJsonWidget)list.get(x);
            try {
                widget.validate();
                result.add(widget);
                continue;
            }
            catch (Exception e) {
                this.printError(type.toString().toLowerCase(), x, e);
            }
        }
        return result;
    }

    private void printError(String type, int index, Throwable e) {
        MutableComponent message = Component.m_237113_((String)("<World Handler:" + this.id + ":" + type + ":" + index + "> " + e.getMessage())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        Minecraft.m_91087_().f_91074_.m_213846_((Component)message);
    }

    private void updateTextfields() {
        for (VisibleActiveObject<EditBox> visObj : this.textfields.values()) {
            ((EditBox)visObj.get()).m_94186_(visObj.isEnabled(this.engineAdapter));
            ((EditBox)visObj.get()).m_94194_(visObj.isVisible(this.engineAdapter));
        }
    }

    private void updateButtons() {
        for (VisibleActiveObject<AbstractWidget> visObj : this.widgets) {
            ((AbstractWidget)visObj.get()).f_93623_ = visObj.isEnabled(this.engineAdapter);
            ((AbstractWidget)visObj.get()).f_93624_ = visObj.isVisible(this.engineAdapter);
        }
    }
}

