/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.argument;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import exopandora.worldhandler.builder.argument.TagArgument;
import exopandora.worldhandler.util.BlockPredicateParser;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStateArgument
extends TagArgument {
    private BlockState state;

    protected BlockStateArgument() {
    }

    public void set(@Nullable ResourceLocation block) {
        if (block != null) {
            this.set((Block)ForgeRegistries.BLOCKS.getValue(block));
        } else {
            this.state = null;
        }
    }

    public void set(@Nullable Block block) {
        this.state = block != null ? block.m_49966_() : null;
    }

    public void set(@Nullable BlockState state) {
        this.state = state;
    }

    public void set(@Nullable BlockState state, CompoundTag tag) {
        this.set(state);
        this.setTag(tag);
    }

    @Nullable
    public BlockState getBlockState() {
        return this.state;
    }

    @Override
    public void deserialize(@Nullable String string) {
        if (string == null) {
            this.reset();
        } else {
            try {
                BlockPredicateParser parser = new BlockPredicateParser(string);
                parser.parse(false);
                parser.getBlock().ifPresentOrElse(block -> {
                    this.state = block.m_49966_();
                    this.setTag(parser.getNbt());
                }, this::reset);
            }
            catch (CommandSyntaxException e) {
                this.reset();
            }
        }
    }

    private void reset() {
        this.state = null;
        this.setTag(null);
    }

    @Override
    @Nullable
    public String serialize() {
        if (this.state == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(this.state.toString());
        String block = this.state.m_60734_().toString();
        builder.replace(0, block.length(), ForgeRegistries.BLOCKS.getKey((Object)this.state.m_60734_()).toString());
        String nbt = super.serialize();
        if (nbt != null && this.state.m_155947_()) {
            builder.append(nbt);
        }
        return builder.toString();
    }

    @Override
    public boolean isDefault() {
        return super.isDefault() && this.state == null;
    }
}

