/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import exopandora.worldhandler.event.ClientEventHandler;
import exopandora.worldhandler.util.CommandHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class CommandWorldHandler {
    private static final SimpleCommandExceptionType NOT_IN_SINGLEPLAYER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.worldhandler.allow_commands.not_in_singleplayer"));
    private static final SimpleCommandExceptionType COMMANDS_ALREADY_ALLOWED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.worldhandler.allow_commands.commands_already_allowed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"worldhandler").then(Commands.m_82127_((String)"help").executes(context -> CommandWorldHandler.help((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"display").executes(context -> CommandWorldHandler.display((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"version").executes(context -> CommandWorldHandler.version((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"allow_commands").executes(context -> CommandWorldHandler.allowCommands((CommandSourceStack)context.getSource()))));
    }

    private static int help(CommandSourceStack source) throws CommandSyntaxException {
        CommandHelper.sendFeedback(source, "/worldhandler help");
        CommandHelper.sendFeedback(source, "/worldhandler display");
        CommandHelper.sendFeedback(source, "/worldhandler version");
        CommandHelper.sendFeedback(source, "/worldhandler allow_commands");
        return 1;
    }

    private static int display(CommandSourceStack source) throws CommandSyntaxException {
        ClientEventHandler.openGui = true;
        return 1;
    }

    private static int version(CommandSourceStack source) throws CommandSyntaxException {
        CommandHelper.sendFeedback(source, "Installed: 1.19-3.3");
        ComparableVersion target = VersionChecker.getResult((IModInfo)((ModContainer)ModList.get().getModContainerById("worldhandler").get()).getModInfo()).target();
        CommandHelper.sendFeedback(source, "Latest: 1.19-" + (Comparable)(target != null ? target : "3.3"));
        return 1;
    }

    private static int allowCommands(CommandSourceStack source) throws CommandSyntaxException {
        if (!Minecraft.m_91087_().m_91091_()) {
            throw NOT_IN_SINGLEPLAYER.create();
        }
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        PrimaryLevelData worldData = (PrimaryLevelData)server.m_129910_();
        LevelSettings settings = worldData.f_78443_;
        if (settings.m_46932_()) {
            throw COMMANDS_ALREADY_ALLOWED.create();
        }
        worldData.f_78443_ = new LevelSettings(settings.m_46917_(), settings.m_46929_(), settings.m_46930_(), settings.m_46931_(), true, settings.m_46933_(), settings.m_46934_(), settings.getLifecycle());
        int operatorPermissionLevel = server.m_7022_();
        Minecraft.m_91087_().f_91074_.m_108648_(operatorPermissionLevel);
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            server.m_129892_().m_82095_(player);
        }
        source.m_81354_((Component)Component.m_237115_((String)"commands.worldhandler.allow_commands.success"), false);
        return operatorPermissionLevel;
    }
}

