/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.category;

import com.google.common.collect.Lists;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.usercontent.UsercontentConfig;
import exopandora.worldhandler.usercontent.UsercontentLoader;
import exopandora.worldhandler.usercontent.model.JsonTab;
import exopandora.worldhandler.util.RegistryHelper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;

public class Category {
    public static IForgeRegistry<Category> REGISTRY;
    public static final ResourceKey<Registry<Category>> REGISTRY_KEY;
    private final List<ResourceLocation> contents;

    public Category() {
        this.contents = Lists.newArrayList();
    }

    public Category(List<ResourceLocation> contents) {
        this.contents = contents;
    }

    public Category(ResourceLocation ... contents) {
        this(Lists.newArrayList((Object[])contents));
    }

    public Category(String ... keys) {
        this(Arrays.stream(keys).map(key -> new ResourceLocation("worldhandler", key)).collect(Collectors.toList()));
    }

    public Category add(int index, ResourceLocation content) {
        this.contents.add(Math.min(index, this.getSize()), content);
        return this;
    }

    public Category add(int index, String key) {
        return this.add(index, new ResourceLocation("worldhandler", key));
    }

    public List<ResourceLocation> getContents() {
        return this.contents;
    }

    public int getSize() {
        return this.contents.size();
    }

    @Nullable
    public Content getContent(int index) {
        return (Content)Content.REGISTRY.getValue(this.contents.get(index));
    }

    @SubscribeEvent
    public static void createRegistry(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setName(REGISTRY_KEY.m_135782_()).disableSaving().disableSync(), registry -> {
            REGISTRY = registry;
        });
    }

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        if (event.getRegistryKey().equals(REGISTRY_KEY)) {
            RegistryHelper.register(event, REGISTRY_KEY, "main", () -> new Category("main", "containers", "multiplayer"));
            RegistryHelper.register(event, REGISTRY_KEY, "entities", () -> new Category("summon", "butcher"));
            RegistryHelper.register(event, REGISTRY_KEY, "items", () -> new Category("custom_item", "enchantment", "recipes"));
            RegistryHelper.register(event, REGISTRY_KEY, "blocks", () -> new Category("edit_blocks", "sign_editor", "note_editor"));
            RegistryHelper.register(event, REGISTRY_KEY, "world", () -> new Category("world", "gamerules"));
            RegistryHelper.register(event, REGISTRY_KEY, "player", () -> new Category("player", "experience", "advancements"));
            RegistryHelper.register(event, REGISTRY_KEY, "scoreboard", () -> new Category("scoreboard_objectives", "scoreboard_teams", "scoreboard_players"));
            for (UsercontentConfig config : UsercontentLoader.CONFIGS) {
                if (config.getContent().getGui() == null || config.getContent().getGui().getTab() == null) continue;
                Category.registerCategory(event, config.getId(), config.getContent().getGui().getTab());
            }
        }
    }

    private static void registerCategory(RegisterEvent event, String id, JsonTab tab) {
        if (tab.getCategory() != null && !tab.getCategory().isEmpty()) {
            if (!Categories.isRegistered(tab.getCategory())) {
                RegistryHelper.register(event, REGISTRY_KEY, tab.getCategory(), () -> new Category(id));
            } else {
                Categories.getRegisteredCategory(tab.getCategory()).add(tab.getCategoryIndex(), id);
            }
        }
    }

    static {
        REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("worldhandler", "category"));
    }
}

