/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.widget.IWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.MutableComponent;

public interface IContent
extends IWidget {
    public Category getCategory();

    public MutableComponent getTitle();

    public MutableComponent getTabTitle();

    public Content getActiveContent();

    @Nonnull
    default public Content getBackContent() {
        return Contents.MAIN;
    }

    @Nullable
    default public CommandPreview getCommandPreview() {
        return null;
    }

    default public void onGuiClosed() {
    }

    public static class CommandPreview {
        private final List<Entry> builders = new ArrayList<Entry>();

        public CommandPreview() {
        }

        public CommandPreview(ICommandBuilder builder, Object label) {
            this.add(builder, label);
        }

        public CommandPreview add(ICommandBuilder builder, Object label) {
            this.builders.add(new Entry(builder, label));
            return this;
        }

        public String toString() {
            if (this.builders.isEmpty()) {
                return null;
            }
            return this.builders.stream().map(entry -> entry.builder().toCommand(entry.label(), true)).collect(Collectors.joining(" | "));
        }

        private record Entry(ICommandBuilder builder, Object label) {
            public Entry {
                Objects.requireNonNull(builder);
            }
        }
    }
}

