/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.argument.Coordinate;
import exopandora.worldhandler.builder.impl.ExecuteCommandBuilder;
import exopandora.worldhandler.builder.impl.FillCommandBuilder;
import exopandora.worldhandler.builder.impl.SetBlockCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.util.CommandHelper;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSetCommandBlockPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.ArrayUtils;

public class BlockHelper {
    private static BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos(0, -64, 0);
    private static BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos(0, -64, 0);
    private static final Block[] BLACKLIST = new Block[]{Blocks.f_50016_, Blocks.f_49990_, Blocks.f_49991_};

    @Nonnull
    public static BlockPos getFocusedBlockPos() {
        BlockHitResult blockResult;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        HitResult result = Minecraft.m_91087_().f_91077_;
        if (result != null && HitResult.Type.BLOCK.equals((Object)result.m_6662_()) && level != null && !ArrayUtils.contains((Object[])BLACKLIST, (Object)level.m_8055_((blockResult = (BlockHitResult)result).m_82425_()).m_60734_())) {
            return blockResult.m_82425_();
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            return player.m_20183_();
        }
        return BlockPos.f_121853_;
    }

    @Nonnull
    public static Block getFocusedBlock() {
        return BlockHelper.getBlock(BlockHelper.getFocusedBlockPos());
    }

    @Nonnull
    public static Block getBlock(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            return level.m_8055_(pos).m_60734_();
        }
        return Blocks.f_50016_;
    }

    public static boolean setCommandBlockNearPlayer(String player, ICommandBuilder command, Object label) {
        if (CommandHelper.canPlayerIssueCommand() && Minecraft.m_91087_().m_91403_() != null) {
            BlockPos pos = Minecraft.m_91087_().f_91074_.m_20183_().m_7918_(0, 3, 0);
            FillCommandBuilder place = new FillCommandBuilder();
            place.from().set(pos);
            place.to().set(pos.m_7494_());
            place.block().set(Blocks.f_50272_);
            FillCommandBuilder remove = new FillCommandBuilder();
            remove.from().setX(new Coordinate.Ints(0, Coordinate.Type.RELATIVE));
            remove.from().setY(new Coordinate.Ints(-1, Coordinate.Type.RELATIVE));
            remove.from().setZ(new Coordinate.Ints(0, Coordinate.Type.RELATIVE));
            remove.to().setX(new Coordinate.Ints(0, Coordinate.Type.RELATIVE));
            remove.to().setY(new Coordinate.Ints(0, Coordinate.Type.RELATIVE));
            remove.to().setZ(new Coordinate.Ints(0, Coordinate.Type.RELATIVE));
            remove.block().set(Blocks.f_50016_);
            Minecraft.m_91087_().f_91074_.m_234156_(place.toCommand((Object)FillCommandBuilder.Label.FILL, false).substring(1));
            ExecuteCommandBuilder execute = new ExecuteCommandBuilder();
            ExecuteCommandBuilder.AtOptionalArgument at = new ExecuteCommandBuilder.AtOptionalArgument(ExecuteCommandBuilder.AtOptionalArgument.Label.AT);
            at.targets().setTarget(player);
            execute.modifiers().add(at);
            execute.command().set(command, label);
            Minecraft.m_91087_().m_91403_().m_104955_((Packet)new ServerboundSetCommandBlockPacket(pos, execute.toCommand((Object)ExecuteCommandBuilder.Label.RUN, false), CommandBlockEntity.Mode.REDSTONE, true, false, true));
            Minecraft.m_91087_().m_91403_().m_104955_((Packet)new ServerboundSetCommandBlockPacket(pos.m_7494_(), remove.toCommand((Object)FillCommandBuilder.Label.FILL, false), CommandBlockEntity.Mode.REDSTONE, true, false, true));
            return true;
        }
        return false;
    }

    public static void setBlockNearPlayer(String player, Block block) {
        SetBlockCommandBuilder builder = new SetBlockCommandBuilder();
        builder.pos().setX(new Coordinate.Ints(Coordinate.Type.LOCAL));
        builder.pos().setY(new Coordinate.Ints(Coordinate.Type.LOCAL));
        builder.pos().setZ(new Coordinate.Ints(2, Coordinate.Type.LOCAL));
        BlockState state = block.m_49966_();
        if (Minecraft.m_91087_().f_91074_ != null && state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Minecraft.m_91087_().f_91074_.m_6350_().m_122424_());
        }
        builder.block().set(state);
        switch (Config.getSettings().getBlockPlacingMode()) {
            case KEEP: {
                CommandHelper.sendCommand(player, builder, (Object)SetBlockCommandBuilder.Label.KEEP);
                break;
            }
            case REPLACE: {
                CommandHelper.sendCommand(player, builder, (Object)SetBlockCommandBuilder.Label.REPLACE);
                break;
            }
            case DESTROY: {
                CommandHelper.sendCommand(player, builder, (Object)SetBlockCommandBuilder.Label.DESTROY);
            }
        }
    }

    public static BlockPos.MutableBlockPos pos1() {
        return pos1;
    }

    public static BlockPos.MutableBlockPos pos2() {
        return pos2;
    }
}

