/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.util.ResourceHelper;
import exopandora.worldhandler.util.TextUtils;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;

public class RenderUtils {
    public static final double EPS = (double)0.002f;

    public static void drawWatchIntoGui(PoseStack matrix, GuiComponent gui, int width, int height, long worldTicks, boolean smooth) {
        float hour = TextUtils.toHour(worldTicks);
        float minute = TextUtils.toMinute(worldTicks);
        if (smooth) {
            hour = (float)(worldTicks + 6000L) / 1000.0f;
            minute = (float)(((double)((float)worldTicks + 6000.0f) - Math.floor(hour) * 1000.0) * 6.0 / 100.0);
        }
        float rotationHour = 30.0f * (hour >= 12.0f ? hour - 12.0f : hour) - 180.0f;
        float rotationMinute = 6.0f * minute - 180.0f;
        matrix.m_85836_();
        matrix.m_85837_((double)(width + 5), (double)(height + 5), 0.0);
        matrix.m_85841_(0.25f, 0.25f, 0.25f);
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(rotationHour));
        GuiComponent.m_93172_((PoseStack)matrix, (int)-1, (int)-1, (int)1, (int)11, (int)-13092808);
        matrix.m_85845_(Vector3f.f_122226_.m_122240_(rotationHour));
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(rotationMinute));
        GuiComponent.m_93172_((PoseStack)matrix, (int)-1, (int)-1, (int)1, (int)15, (int)-9474193);
        matrix.m_85845_(Vector3f.f_122226_.m_122240_(rotationMinute));
        matrix.m_85849_();
        RenderUtils.colorDefaultButton();
        RenderSystem.m_157456_((int)0, (ResourceLocation)ResourceHelper.iconTexture());
        gui.m_93228_(matrix, width + 0, height, 48, 0, 10, 10);
        matrix.m_85836_();
        matrix.m_85841_(0.5f, 0.5f, 0.5f);
        GuiComponent.m_93172_((PoseStack)matrix, (int)((width + 5) * 2 - 1), (int)((height + 4) * 2 + 1), (int)((width + 6) * 2 - 1), (int)((height + 5) * 2 + 1), (int)-16777216);
        matrix.m_85849_();
    }

    public static void colorDefaultButton() {
        float r = Config.getSkin().getButtonRed();
        float g = Config.getSkin().getButtonGreen();
        float b = Config.getSkin().getButtonBlue();
        float a = Config.getSkin().getButtonAlpha();
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
    }

    public static void colorDefaultBackground() {
        RenderUtils.colorDefaultBackground(1.0);
    }

    public static void colorDefaultBackground(double alpha) {
        float r = Config.getSkin().getBackgroundRed();
        float g = Config.getSkin().getBackgroundGreen();
        float b = Config.getSkin().getBackgroundBlue();
        float a = (float)alpha * Config.getSkin().getBackgroundAlpha();
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
    }

    public static void colorDarkBackground() {
        float r = Config.getSkin().getBackgroundRed();
        float g = Config.getSkin().getBackgroundGreen();
        float b = Config.getSkin().getBackgroundBlue();
        float a = Config.getSkin().getBackgroundAlpha();
        RenderSystem.m_157429_((float)Math.max(0.0f, r - 0.3f), (float)Math.max(0.0f, g - 0.3f), (float)Math.max(0.0f, b - 0.3f), (float)a);
    }

    public static void drawTexturedTriangleBL(PoseStack matrix, GuiComponent gui, int x, int y, int textureX, int textureY, int size) {
        for (int i = 0; i < size; ++i) {
            gui.m_93228_(matrix, x, y + i, textureX, textureY + i, i + 1, 1);
        }
    }

    public static void drawTexturedTriangleBR(PoseStack matrix, GuiComponent gui, int x, int y, int textureX, int textureY, int size) {
        for (int i = 0; i < size; ++i) {
            gui.m_93228_(matrix, x + size - i - 1, y + i, textureX + size - i - 1, textureY + i, i + 1, 1);
        }
    }

    public static void drawTexturedTriangleTL(PoseStack matrix, GuiComponent gui, int x, int y, int textureX, int textureY, int size) {
        for (int i = 0; i < size; ++i) {
            gui.m_93228_(matrix, x, y + i, textureX, textureY, size - i, 1);
        }
    }

    public static void drawTexturedTriangleTR(PoseStack matrix, GuiComponent gui, int x, int y, int textureX, int textureY, int size) {
        for (int i = 0; i < size; ++i) {
            gui.m_93228_(matrix, x + i, y + i, textureX + i, textureY, size - i, 1);
        }
    }

    public static void drawTexturedWedgeGradientTR(PoseStack matrix, GuiComponent gui, int x, int y, int textureX, int textureY, int width, int height) {
        RenderSystem.m_69478_();
        for (int i = 0; i < height; ++i) {
            double w = (double)(height - i) / (double)(height + 1);
            int z = width - (int)(w * (double)width);
            RenderUtils.colorDefaultBackground(w);
            gui.m_93228_(matrix, x + z, y + i, textureX + z, textureY + i, width - z, 1);
        }
        RenderSystem.m_69461_();
    }

    public static void drawTexturedWedgeGradientTL(PoseStack matrix, GuiComponent gui, int x, int y, int textureX, int textureY, int width, int height) {
        RenderSystem.m_69478_();
        for (int i = 0; i < height; ++i) {
            double w = (double)(height - i) / (double)(height + 1);
            int z = (int)(w * (double)width);
            RenderUtils.colorDefaultBackground(w);
            gui.m_93228_(matrix, x, y + i, textureX, textureY + i, z, 1);
        }
        RenderSystem.m_69461_();
    }
}

