/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.builder.impl.SetBlockCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.event.KeyHandler;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonPiano;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.BlockHelper;
import exopandora.worldhandler.util.CommandHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;

public class ContentNoteEditor
extends Content {
    private static final ResourceLocation NOTE = new ResourceLocation("worldhandler", "textures/misc/note.png");
    private final SetBlockCommandBuilder builderNoteEditor = new SetBlockCommandBuilder();
    private final IContent.CommandPreview preview = new IContent.CommandPreview(this.builderNoteEditor, (Object)SetBlockCommandBuilder.Label.REPLACE);
    private boolean isActive;

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.isActive ? this.preview : null;
    }

    @Override
    public void init(Container container) {
        this.isActive = BlockHelper.getFocusedBlock() instanceof NoteBlock;
        this.builderNoteEditor.pos().set(BlockHelper.getFocusedBlockPos());
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        if (this.isActive) {
            BlockPos pos = this.builderNoteEditor.pos().getBlockPos();
            SoundEvent sound = this.getSoundEvent(pos.m_7495_());
            container.add(new GuiButtonPiano(x - 3 + 15, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.g"), sound, 0.53f, GuiButtonPiano.Type.NORMAL, () -> this.setNote(container.getPlayer(), 1)));
            container.add(new GuiButtonPiano(x - 3 + 30, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.a"), sound, 0.6f, GuiButtonPiano.Type.NORMAL, () -> this.setNote(container.getPlayer(), 3)));
            container.add(new GuiButtonPiano(x - 3 + 45, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.b"), sound, 0.67f, GuiButtonPiano.Type.RIGHT, () -> this.setNote(container.getPlayer(), 5)));
            container.add(new GuiButtonPiano(x - 3 + 60, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.c"), sound, 0.7f, GuiButtonPiano.Type.LEFT, () -> this.setNote(container.getPlayer(), 6)));
            container.add(new GuiButtonPiano(x - 3 + 75, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.d"), sound, 0.8f, GuiButtonPiano.Type.NORMAL, () -> this.setNote(container.getPlayer(), 8)));
            container.add(new GuiButtonPiano(x - 3 + 90, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.e"), sound, 0.9f, GuiButtonPiano.Type.RIGHT, () -> this.setNote(container.getPlayer(), 10)));
            container.add(new GuiButtonPiano(x - 3 + 105, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.f"), sound, 0.95f, GuiButtonPiano.Type.LEFT, () -> this.setNote(container.getPlayer(), 11)));
            container.add(new GuiButtonPiano(x - 3 + 120, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.g"), sound, 1.05f, GuiButtonPiano.Type.NORMAL, () -> this.setNote(container.getPlayer(), 13)));
            container.add(new GuiButtonPiano(x - 3 + 135, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.a"), sound, 1.2f, GuiButtonPiano.Type.NORMAL, () -> this.setNote(container.getPlayer(), 15)));
            container.add(new GuiButtonPiano(x - 3 + 150, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.b"), sound, 1.32f, GuiButtonPiano.Type.RIGHT, () -> this.setNote(container.getPlayer(), 17)));
            container.add(new GuiButtonPiano(x - 3 + 165, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.c"), sound, 1.4f, GuiButtonPiano.Type.LEFT, () -> this.setNote(container.getPlayer(), 18)));
            container.add(new GuiButtonPiano(x - 3 + 180, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.d"), sound, 1.6f, GuiButtonPiano.Type.NORMAL, () -> this.setNote(container.getPlayer(), 20)));
            container.add(new GuiButtonPiano(x - 3 + 195, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.e"), sound, 1.8f, GuiButtonPiano.Type.RIGHT, () -> this.setNote(container.getPlayer(), 22)));
            container.add(new GuiButtonPiano(x - 3 + 210, y, 14, 92, (Component)Component.m_237115_((String)"gui.worldhandler.blocks.note_block_editor.f"), sound, 1.9f, GuiButtonPiano.Type.LEFT, () -> this.setNote(container.getPlayer(), 23)));
            container.add(new GuiButtonPiano(x - 3 - 5 + 15, y, 9, 58, (Component)Component.m_237113_((String)"F#"), sound, 0.5f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 0)));
            container.add(new GuiButtonPiano(x - 3 - 5 + 30, y, 9, 58, (Component)Component.m_237113_((String)"G#"), sound, 0.56f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 2)));
            container.add(new GuiButtonPiano(x - 3 - 5 + 45, y, 9, 58, (Component)Component.m_237113_((String)"A#"), sound, 0.63f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 4)));
            container.add(new GuiButtonPiano(x - 3 - 5 + 75, y, 9, 58, (Component)Component.m_237113_((String)"C#"), sound, 0.75f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 7)));
            container.add(new GuiButtonPiano(x - 3 - 5 + 90, y, 9, 58, (Component)Component.m_237113_((String)"D#"), sound, 0.85f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 9)));
            container.add(new GuiButtonPiano(x - 3 - 5 + 120, y, 9, 58, (Component)Component.m_237113_((String)"F#"), sound, 1.0f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 12)));
            container.add(new GuiButtonPiano(x - 3 - 5 + 135, y, 9, 58, (Component)Component.m_237113_((String)"G#"), sound, 1.1f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 14)));
            container.add(new GuiButtonPiano(x - 3 - 5 + 150, y, 9, 58, (Component)Component.m_237113_((String)"A#"), sound, 1.25f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 16)));
            container.add(new GuiButtonPiano(x - 3 - 5 + 180, y, 9, 58, (Component)Component.m_237113_((String)"C#"), sound, 1.5f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 19)));
            container.add(new GuiButtonPiano(x - 3 - 5 + 195, y, 9, 58, (Component)Component.m_237113_((String)"D#"), sound, 1.7f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 21)));
            container.add(new GuiButtonPiano(x - 3 - 5 + 225, y, 9, 58, (Component)Component.m_237113_((String)"F#"), sound, 2.0f, GuiButtonPiano.Type.BLACK, () -> this.setNote(container.getPlayer(), 24)));
        }
    }

    private void setNote(String player, int note) {
        SetBlockCommandBuilder builder = new SetBlockCommandBuilder();
        builder.pos().set(this.builderNoteEditor.pos().getBlockPos());
        NoteBlockInstrument instrument = NoteBlockInstrument.m_61666_((BlockState)Minecraft.m_91087_().f_91073_.m_8055_(this.builderNoteEditor.pos().getBlockPos().m_7495_()));
        BlockState state = (BlockState)((BlockState)Blocks.f_50065_.m_49966_().m_61124_((Property)BlockStateProperties.f_61395_, (Comparable)instrument)).m_61124_((Property)BlockStateProperties.f_61424_, (Comparable)Integer.valueOf(note));
        builder.block().set(state);
        CommandHelper.sendCommand(player, builder, (Object)SetBlockCommandBuilder.Label.REPLACE);
    }

    @Override
    public void drawScreen(PoseStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.isActive) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)NOTE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            container.m_93228_(matrix, x - 1, y - 1, 0, 0, 8, 59);
            container.m_93228_(matrix, x - 1, y - 1 + 59, 0, 59, 13, 35);
            container.m_93228_(matrix, x - 1 + 232 - 5, y - 1, 18, 0, 7, 59);
            container.m_93228_(matrix, x - 1 + 232 - 10, y - 1 + 59, 13, 59, 12, 35);
            container.m_93228_(matrix, x - 1 + 8, y - 1, 0, 94, 219, 1);
            container.m_93228_(matrix, x - 1 + 13, y - 1 + 93, 0, 94, 209, 1);
        } else {
            float scale = 4.0f;
            PoseStack posestack = RenderSystem.m_157191_();
            posestack.m_85836_();
            posestack.m_85837_((double)((float)(container.f_96543_ / 2) - 8.5f * scale), (double)((float)(container.f_96544_ / 2 - 15) - 8.5f * scale), 0.0);
            posestack.m_85841_(scale, scale, scale);
            Minecraft.m_91087_().m_91291_().m_115123_(new ItemStack((ItemLike)Items.f_41859_), 0, 0);
            posestack.m_85849_();
            RenderSystem.m_157182_();
            MutableComponent text = Component.m_237110_((String)"gui.worldhandler.blocks.note_block_editor.look_at_note_block", (Object[])new Object[]{KeyHandler.KEY_WORLD_HANDLER.m_90863_()});
            Font font = Minecraft.m_91087_().f_91062_;
            font.m_92889_(matrix, (Component)text, (float)(x + 116 - font.m_92852_((FormattedText)text) / 2), (float)(y + 70), Config.getSkin().getLabelColor());
        }
    }

    private SoundEvent getSoundEvent(BlockPos blockPos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            return NoteBlockInstrument.m_61666_((BlockState)level.m_8055_(blockPos)).m_61668_();
        }
        return null;
    }

    @Override
    public Category getCategory() {
        return Categories.BLOCKS;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.blocks.note_block_editor");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.blocks.note_block_editor");
    }

    @Override
    public Content getActiveContent() {
        return Contents.NOTE_EDITOR;
    }
}

