/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.impl.ContentChild;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.widget.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ContentSettings
extends ContentChild {
    private static final List<Setting<?>> SETTINGS = new ArrayList();
    private Setting<?> setting;
    private GuiTextFieldTooltip valueField;

    @Override
    public void initGui(final Container container, int x, int y) {
        MenuPageList settings = new MenuPageList(x, y, SETTINGS, 114, 20, 3, container, new ILogicPageList<Setting<?>>(){

            @Override
            public MutableComponent translate(Setting<?> item) {
                return Component.m_237115_((String)("gui.worldhandler.config.settings." + item.getKey()));
            }

            @Override
            public MutableComponent toTooltip(Setting<?> item) {
                return null;
            }

            @Override
            public void onClick(Setting<?> item) {
                ContentSettings.this.setting = item;
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, MutableComponent text, Setting<?> item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, (Component)text, (Component)this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "settings";
            }
        });
        container.add(settings);
        this.valueField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.value"));
        this.valueField.m_94153_(string -> {
            if (string == null) {
                return false;
            }
            if (!string.isEmpty()) {
                try {
                    Integer.parseInt(string);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        });
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        if (this.setting instanceof Setting.BooleanSetting) {
            Setting.BooleanSetting setting = (Setting.BooleanSetting)this.setting;
            GuiButtonBase button1 = new GuiButtonBase(x + 118, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.enable"), () -> {
                setting.set(true);
                container.m_7856_();
            });
            container.add(button1);
            GuiButtonBase button2 = new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.disable"), () -> {
                setting.set(false);
                container.m_7856_();
            });
            container.add(button2);
            boolean enabled = (Boolean)setting.get();
            button1.f_93623_ = !enabled;
            button2.f_93623_ = enabled;
        } else if (this.setting instanceof Setting.IntegerSetting) {
            Setting.IntegerSetting setting = (Setting.IntegerSetting)this.setting;
            this.valueField.m_94144_(String.valueOf(setting.get()));
            container.add(this.valueField);
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.actions.set"), () -> {
                String text = this.valueField.m_94155_();
                if (text.isEmpty()) {
                    setting.set(0);
                } else {
                    setting.set(Integer.parseInt(text));
                }
                container.m_7856_();
            }));
        }
    }

    @Override
    public void tick(Container container) {
        if (this.setting instanceof Setting.IntegerSetting) {
            this.valueField.m_94120_();
        }
    }

    @Override
    public void drawScreen(PoseStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.setting instanceof Setting.IntegerSetting) {
            this.valueField.m_6303_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.shortcuts.tooltip.settings");
    }

    static {
        SETTINGS.add(new Setting.BooleanSetting("command_syntax", Config.CLIENT.getSettings()::commandSyntax, Config.CLIENT.getSettings()::setCommandSyntax));
        SETTINGS.add(new Setting.BooleanSetting("shortcuts", Config.CLIENT.getSettings()::shortcuts, Config.CLIENT.getSettings()::setShortcuts));
        SETTINGS.add(new Setting.BooleanSetting("tooltips", Config.CLIENT.getSettings()::tooltips, Config.CLIENT.getSettings()::setTooltips));
        SETTINGS.add(new Setting.BooleanSetting("watch", Config.CLIENT.getSettings()::watch, Config.CLIENT.getSettings()::setWatch));
        SETTINGS.add(new Setting.BooleanSetting("smooth_watch", Config.CLIENT.getSettings()::smoothWatch, Config.CLIENT.getSettings()::setSmoothWatch));
        SETTINGS.add(new Setting.BooleanSetting("pause_game", Config.CLIENT.getSettings()::pause, Config.CLIENT.getSettings()::setPause));
        SETTINGS.add(new Setting.BooleanSetting("custom_times", Config.CLIENT.getSettings()::customTimes, Config.CLIENT.getSettings()::setCustomTimes));
        SETTINGS.add(new Setting.BooleanSetting("permission_query", Config.CLIENT.getSettings()::permissionQuery, Config.CLIENT.getSettings()::setPermissionQuery));
        SETTINGS.add(new Setting.BooleanSetting("highlight_blocks", Config.CLIENT.getSettings()::highlightBlocks, Config.CLIENT.getSettings()::setHighlightBlocks));
        SETTINGS.add(new Setting.IntegerSetting("custom_time_dawn", Config.CLIENT.getSettings()::getDawn, Config.CLIENT.getSettings()::setDawn));
        SETTINGS.add(new Setting.IntegerSetting("custom_time_noon", Config.CLIENT.getSettings()::getNoon, Config.CLIENT.getSettings()::setNoon));
        SETTINGS.add(new Setting.IntegerSetting("custom_time_sunset", Config.CLIENT.getSettings()::getSunset, Config.CLIENT.getSettings()::setSunset));
        SETTINGS.add(new Setting.IntegerSetting("custom_time_midnight", Config.CLIENT.getSettings()::getMidnight, Config.CLIENT.getSettings()::setMidnight));
    }

    public static abstract class Setting<T> {
        private final String key;
        private final Supplier<T> getter;
        private final Consumer<T> setter;

        public Setting(String key, Supplier<T> getter, Consumer<T> setter) {
            this.key = key;
            this.getter = getter;
            this.setter = setter;
        }

        public String getKey() {
            return this.key;
        }

        public T get() {
            return this.getter.get();
        }

        public void set(T value) {
            this.setter.accept(value);
        }

        public static class IntegerSetting
        extends Setting<Integer> {
            public IntegerSetting(String key, Supplier<Integer> getter, Consumer<Integer> setter) {
                super(key, getter, setter);
            }
        }

        public static class BooleanSetting
        extends Setting<Boolean> {
            public BooleanSetting(String key, Supplier<Boolean> getter, Consumer<Boolean> setter) {
                super(key, getter, setter);
            }
        }
    }
}

