/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.argument.Gamemode;
import exopandora.worldhandler.builder.impl.DifficultyCommandBuilder;
import exopandora.worldhandler.builder.impl.GamemodeCommandBuilder;
import exopandora.worldhandler.builder.impl.TimeCommandBuilder;
import exopandora.worldhandler.builder.impl.WeatherCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.container.impl.GuiWorldHandler;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.impl.ContentChild;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.BlockHelper;
import exopandora.worldhandler.util.CommandHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.SignBlock;

public class ActionHelper {
    public static void backToGame() {
        Minecraft.m_91087_().m_91152_(null);
        Minecraft.m_91087_().f_91067_.m_91601_();
    }

    public static void back(Content content) throws Exception {
        if (content.getBackContent() != null) {
            ActionHelper.open(content.getBackContent());
        }
    }

    public static void open(String id) throws Exception {
        if (id != null) {
            ActionHelper.open(Contents.getRegisteredContent(id));
        }
    }

    public static void open(Content content) throws Exception {
        if (content != null) {
            if (content instanceof ContentChild && Minecraft.m_91087_().f_91080_ != null && Minecraft.m_91087_().f_91080_ instanceof GuiWorldHandler) {
                Minecraft.m_91087_().m_91152_((Screen)new GuiWorldHandler(((ContentChild)content).withParent(((GuiWorldHandler)Minecraft.m_91087_().f_91080_).getContent())));
            } else {
                Minecraft.m_91087_().m_91152_((Screen)new GuiWorldHandler(content));
            }
        }
    }

    public static void timeDawn() {
        ActionHelper.setDayTime(Config.getSettings().getDawn());
    }

    public static void timeNoon() {
        ActionHelper.setDayTime(Config.getSettings().getNoon());
    }

    public static void timeSunset() {
        ActionHelper.setDayTime(Config.getSettings().getSunset());
    }

    public static void timeMidnight() {
        ActionHelper.setDayTime(Config.getSettings().getMidnight());
    }

    public static void setDayTime(int time) {
        TimeCommandBuilder builder = new TimeCommandBuilder();
        builder.time().set(Float.valueOf(time));
        CommandHelper.sendCommand(Minecraft.m_91087_().m_91094_().m_92546_(), builder, (Object)TimeCommandBuilder.Label.SET);
    }

    public static void weatherClear() {
        CommandHelper.sendCommand(Minecraft.m_91087_().m_91094_().m_92546_(), new WeatherCommandBuilder(), (Object)WeatherCommandBuilder.Label.CLEAR);
    }

    public static void weatherRain() {
        CommandHelper.sendCommand(Minecraft.m_91087_().m_91094_().m_92546_(), new WeatherCommandBuilder(), (Object)WeatherCommandBuilder.Label.RAIN);
    }

    public static void weatherThunder() {
        CommandHelper.sendCommand(Minecraft.m_91087_().m_91094_().m_92546_(), new WeatherCommandBuilder(), (Object)WeatherCommandBuilder.Label.THUNDER);
    }

    public static void difficultyPeaceful() {
        ActionHelper.setDifficulty(Difficulty.PEACEFUL);
    }

    public static void difficultyEasy() {
        ActionHelper.setDifficulty(Difficulty.EASY);
    }

    public static void difficultyNormal() {
        ActionHelper.setDifficulty(Difficulty.NORMAL);
    }

    public static void difficultyHard() {
        ActionHelper.setDifficulty(Difficulty.HARD);
    }

    private static void setDifficulty(Difficulty difficulty) {
        DifficultyCommandBuilder builder = new DifficultyCommandBuilder();
        builder.difficulty().set(difficulty);
        CommandHelper.sendCommand(Minecraft.m_91087_().m_91094_().m_92546_(), builder, (Object)DifficultyCommandBuilder.Label.DIFFICULTY);
    }

    public static void gamemodeSurvival() {
        ActionHelper.setGamemode(Gamemode.SURVIVAL);
    }

    public static void gamemodeCreative() {
        ActionHelper.setGamemode(Gamemode.CREATIVE);
    }

    public static void gamemodeAdventure() {
        ActionHelper.setGamemode(Gamemode.ADVENTURE);
    }

    public static void gamemodeSpectator() {
        ActionHelper.setGamemode(Gamemode.SPECTATOR);
    }

    private static void setGamemode(Gamemode gamemode) {
        GamemodeCommandBuilder builder = new GamemodeCommandBuilder();
        builder.gamemode().set(gamemode);
        CommandHelper.sendCommand(Minecraft.m_91087_().m_91094_().m_92546_(), builder, (Object)GamemodeCommandBuilder.Label.GAMEMODE);
    }

    public static void tryRun(ActionHandler action) {
        try {
            if (action != null) {
                action.run();
            }
        }
        catch (Exception e) {
            Minecraft.m_91087_().m_91152_(null);
            Minecraft.m_91087_().f_91067_.m_91601_();
            MutableComponent message = Component.m_237110_((String)"<World Handler> %s", (Object[])new Object[]{Component.m_237115_((String)"worldhandler.error.gui")}).m_130940_(ChatFormatting.RED);
            MutableComponent cause = Component.m_237113_((String)(" " + e.getClass().getCanonicalName() + ": " + e.getMessage())).m_130940_(ChatFormatting.RED);
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)message);
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)cause);
            WorldHandler.LOGGER.throwing((Throwable)e);
        }
    }

    public static void displayGui() {
        if (Config.getSettings().permissionQuery() && !CommandHelper.canPlayerIssueCommand()) {
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"worldhandler.permission.refused").m_130940_(ChatFormatting.RED));
            if (Minecraft.m_91087_().m_91091_()) {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"worldhandler.permission.refused.singleplayer", (Object[])new Object[]{I18n.m_118938_((String)"gui.worldhandler.config.settings.permission_query", (Object[])new Object[0])}).m_130940_(ChatFormatting.RED));
            } else {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"worldhandler.permission.refused.multiplayer", (Object[])new Object[]{I18n.m_118938_((String)"gui.worldhandler.config.settings.permission_query", (Object[])new Object[0])}).m_130940_(ChatFormatting.RED));
            }
        } else {
            ActionHelper.tryRun(() -> {
                if (BlockHelper.getFocusedBlock() instanceof SignBlock) {
                    ActionHelper.open(Contents.SIGN_EDITOR);
                } else if (BlockHelper.getFocusedBlock() instanceof NoteBlock) {
                    ActionHelper.open(Contents.NOTE_EDITOR);
                } else {
                    ActionHelper.open(Contents.MAIN);
                }
            });
        }
    }
}

