/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.argument;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import exopandora.worldhandler.builder.argument.TagArgument;
import exopandora.worldhandler.util.BlockPredicateParser;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockPredicateArgument
extends TagArgument {
    private ResourceLocation resource;
    private boolean isTag;
    private Map<String, String> properties;

    protected BlockPredicateArgument() {
    }

    public void set(@Nullable ResourceLocation resource) {
        this.resource = resource;
    }

    public void set(@Nullable BlockState state) {
        if (state != null) {
            this.resource = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
            this.properties = BlockPredicateArgument.propertiesToString(state.m_61148_());
        } else {
            this.resource = null;
            this.properties = null;
        }
        this.isTag = false;
    }

    public void set(@Nullable Map<Property<?>, Comparable<?>> properties) {
        this.properties = properties != null ? BlockPredicateArgument.propertiesToString(properties) : null;
    }

    public void set(Property<?> key, @Nullable Comparable<?> value) {
        String name = key.m_61708_();
        if (value == null) {
            if (this.properties != null && this.properties.containsKey(name)) {
                this.properties.remove(name);
            }
        } else {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            this.properties.put(name, BlockPredicateArgument.getName(key, value));
        }
    }

    public void set(@Nullable BlockState state, CompoundTag tag) {
        this.set(state);
        this.setTag(tag);
        this.isTag = false;
    }

    public void set(boolean isTag) {
        this.isTag = isTag;
    }

    @Nullable
    public ResourceLocation getResourceLocation() {
        return this.resource;
    }

    public boolean isTag() {
        return this.isTag;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public void deserialize(@Nullable String predicate) {
        if (predicate == null) {
            this.reset();
        } else {
            try {
                BlockPredicateParser parser = new BlockPredicateParser(predicate);
                parser.parse(true);
                this.resource = parser.getResourceLocation();
                this.isTag = parser.isTag();
                this.properties = parser.getVagueProperties();
                this.setTag(parser.getNbt());
            }
            catch (CommandSyntaxException e) {
                this.reset();
            }
        }
    }

    private void reset() {
        this.resource = null;
        this.properties = null;
        this.isTag = false;
        this.setTag(null);
    }

    @Override
    @Nullable
    public String serialize() {
        String nbt;
        if (this.resource == null || this.resource.m_135815_().isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (this.isTag) {
            builder.append('#');
        }
        builder.append(this.resource.toString());
        if (this.properties != null && !this.properties.isEmpty()) {
            builder.append('[');
            builder.append(this.properties.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(",")));
            builder.append(']');
        }
        if ((nbt = super.serialize()) != null) {
            builder.append(nbt);
        }
        return builder.toString();
    }

    @Override
    public boolean isDefault() {
        return super.isDefault() && this.resource == null && (this.properties == null || this.properties.isEmpty());
    }

    private static Map<String, String> propertiesToString(Map<Property<?>, Comparable<?>> properties) {
        return properties.entrySet().stream().map(entry -> {
            Property property = (Property)entry.getKey();
            return new AbstractMap.SimpleEntry<String, String>(property.m_61708_(), BlockPredicateArgument.getName(property, (Comparable)entry.getValue()));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static <T extends Comparable<T>> String getName(Property<T> key, Comparable<?> value) {
        return key.m_6940_(value);
    }
}

