/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.config;

import exopandora.worldhandler.config.Config;
import java.util.Arrays;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigCategorySkin {
    private final ForgeConfigSpec.ConfigValue<EnumIconSize> iconSize;
    private final ForgeConfigSpec.IntValue labelColor;
    private final ForgeConfigSpec.IntValue headlineColor;
    private final ForgeConfigSpec.IntValue backgroundRed;
    private final ForgeConfigSpec.IntValue backgroundGreen;
    private final ForgeConfigSpec.IntValue backgroundBlue;
    private final ForgeConfigSpec.IntValue backgroundAlpha;
    private final ForgeConfigSpec.IntValue buttonRed;
    private final ForgeConfigSpec.IntValue buttonGreen;
    private final ForgeConfigSpec.IntValue buttonBlue;
    private final ForgeConfigSpec.IntValue buttonAlpha;
    private final ForgeConfigSpec.ConfigValue<String> type;
    private final ForgeConfigSpec.BooleanValue sharpEdges;
    private final ForgeConfigSpec.BooleanValue drawBackground;

    public ConfigCategorySkin(ForgeConfigSpec.Builder builder) {
        builder.push("skin");
        this.iconSize = builder.translation("gui.worldhandler.config.skin.icons").comment("Size of the icons").defineEnum("icon_size", (Enum)EnumIconSize.x16, (Enum[])EnumIconSize.values());
        this.labelColor = builder.translation("gui.worldhandler.config.skin.label_color").comment("Label color").defineInRange("label_color", 0x1F1F1F, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.headlineColor = builder.translation("gui.worldhandler.config.skin.headline_color").comment("Headline color").defineInRange("headline_color", 0x4F4F4F, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.backgroundRed = builder.translation("gui.worldhandler.config.skin.background_red").comment("Background red").defineInRange("background_red", 255, 0, 255);
        this.backgroundGreen = builder.translation("gui.worldhandler.config.skin.background_green").comment("Background green").defineInRange("background_green", 255, 0, 255);
        this.backgroundBlue = builder.translation("gui.worldhandler.config.skin.background_blue").comment("Background blue").defineInRange("background_blue", 255, 0, 255);
        this.backgroundAlpha = builder.translation("gui.worldhandler.config.skin.background_alpha").comment("Background alpha").defineInRange("background_alpha", 255, 0, 255);
        this.buttonRed = builder.translation("gui.worldhandler.config.skin.button_red").comment("Button red").defineInRange("button_red", 255, 0, 255);
        this.buttonGreen = builder.translation("gui.worldhandler.config.skin.button_green").comment("Button green").defineInRange("button_green", 255, 0, 255);
        this.buttonBlue = builder.translation("gui.worldhandler.config.skin.button_blue").comment("Button blue").defineInRange("button_blue", 255, 0, 255);
        this.buttonAlpha = builder.translation("gui.worldhandler.config.skin.button_alpha").comment("Button alpha").defineInRange("button_alpha", 255, 0, 255);
        this.type = builder.translation("gui.worldhandler.config.skin.textures").comment("Background texture (resourcepack, vanilla)").defineInList("textures", (Object)"resourcepack", Arrays.asList("resourcepack", "vanilla"));
        this.sharpEdges = builder.translation("gui.worldhandler.config.skin.sharp_tab_edges").comment("Whether or not the gui has sharp or smooth tab edges").define("sharp_tab_edges", false);
        this.drawBackground = builder.translation("gui.worldhandler.config.skin.draw_background").comment("Whether or not to enable background drawing").define("draw_background", true);
        builder.pop();
    }

    public EnumIconSize getIconSize() {
        return (EnumIconSize)((Object)this.iconSize.get());
    }

    public void setIconSize(EnumIconSize size) {
        Config.set(this.iconSize, size);
    }

    public int getLabelColor() {
        return (Integer)this.labelColor.get();
    }

    public void setLabelColor(int color) {
        Config.set(this.labelColor, color);
    }

    public int getHeadlineColor() {
        return (Integer)this.headlineColor.get();
    }

    public void setHeadlineColor(int color) {
        Config.set(this.headlineColor, color);
    }

    public int getBackgroundRedInt() {
        return (Integer)this.backgroundRed.get();
    }

    public float getBackgroundRed() {
        return (float)this.getBackgroundRedInt() / 255.0f;
    }

    public void setBackgroundRed(int red) {
        Config.set(this.backgroundRed, red);
    }

    public int getBackgroundGreenInt() {
        return (Integer)this.backgroundGreen.get();
    }

    public float getBackgroundGreen() {
        return (float)this.getBackgroundGreenInt() / 255.0f;
    }

    public void setBackgroundGreen(int green) {
        Config.set(this.backgroundGreen, green);
    }

    public int getBackgroundBlueInt() {
        return (Integer)this.backgroundBlue.get();
    }

    public float getBackgroundBlue() {
        return (float)this.getBackgroundBlueInt() / 255.0f;
    }

    public void setBackgroundBlue(int blue) {
        Config.set(this.backgroundBlue, blue);
    }

    public int getButtonRedInt() {
        return (Integer)this.buttonRed.get();
    }

    public float getButtonRed() {
        return (float)this.getButtonRedInt() / 255.0f;
    }

    public void setButtonRed(int red) {
        Config.set(this.backgroundRed, red);
    }

    public int getButtonGreenInt() {
        return (Integer)this.buttonGreen.get();
    }

    public float getButtonGreen() {
        return (float)this.getButtonGreenInt() / 255.0f;
    }

    public void setButtonGreen(int green) {
        Config.set(this.buttonGreen, green);
    }

    public int getButtonBlueInt() {
        return (Integer)this.buttonBlue.get();
    }

    public float getButtonBlue() {
        return (float)this.getButtonBlueInt() / 255.0f;
    }

    public void setButtonBlue(int blue) {
        Config.set(this.buttonBlue, blue);
    }

    public String getTextureType() {
        return (String)this.type.get();
    }

    public void setTextureType(String type) {
        Config.set(this.type, type);
    }

    public boolean sharpEdges() {
        return (Boolean)this.sharpEdges.get();
    }

    public void setSharpEdges(boolean enabled) {
        Config.set(this.sharpEdges, enabled);
    }

    public boolean drawBackground() {
        return (Boolean)this.drawBackground.get();
    }

    public void setDrawBackground(boolean enabled) {
        Config.set(this.drawBackground, enabled);
    }

    public int getBackgroundAlphaInt() {
        return (Integer)this.backgroundAlpha.get();
    }

    public float getBackgroundAlpha() {
        return (float)this.getBackgroundAlphaInt() / 255.0f;
    }

    public void setBackgroundAlpha(int alpha) {
        Config.set(this.backgroundAlpha, alpha);
    }

    public int getButtonAlphaInt() {
        return (Integer)this.buttonAlpha.get();
    }

    public float getButtonAlpha() {
        return (float)this.getButtonAlphaInt() / 255.0f;
    }

    public void setButtonAlpha(int alpha) {
        Config.set(this.buttonAlpha, alpha);
    }

    public static enum EnumIconSize {
        x16,
        x32,
        x64;

    }
}

