/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.config;

import exopandora.worldhandler.config.Config;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigCategorySliders {
    private final ForgeConfigSpec.DoubleValue maxPotionAmplifier;
    private final ForgeConfigSpec.DoubleValue maxItemEnchantment;
    private final ForgeConfigSpec.DoubleValue maxItemAttributes;
    private final ForgeConfigSpec.DoubleValue maxSummonPotionAmplifier;
    private final ForgeConfigSpec.DoubleValue maxSummonPotionMinutes;
    private final ForgeConfigSpec.DoubleValue maxSummonAttributes;
    private final ForgeConfigSpec.DoubleValue maxExperience;
    private final ForgeConfigSpec.DoubleValue maxPlayerPoints;
    private final ForgeConfigSpec.DoubleValue maxTriggerValue;

    public ConfigCategorySliders(ForgeConfigSpec.Builder builder) {
        builder.push("sliders");
        this.maxPotionAmplifier = builder.translation("gui.worldhandler.config.sliders.max_potion_amplifier").comment("Maximum value for the potion amplifier").defineInRange("max_potion_amplifier", 100.0, 0.0, 127.0);
        this.maxItemEnchantment = builder.translation("gui.worldhandler.config.sliders.max_item_enchantment").comment("Maximum value for an item enchantment").defineInRange("max_item_enchantment", 100.0, 0.0, 2.147483647E9);
        this.maxItemAttributes = builder.translation("gui.worldhandler.config.sliders.max_item_attributes").comment("Maximum value for an item attribute").defineInRange("max_item_attributes", 100.0, 0.0, Double.MAX_VALUE);
        this.maxSummonPotionAmplifier = builder.translation("gui.worldhandler.config.sliders.max_summon_potion_amplifier").comment("Maximum value for the potion amplifier for summon").defineInRange("max_summon_potion_amplifier", 100.0, 0.0, 127.0);
        this.maxSummonPotionMinutes = builder.translation("gui.worldhandler.config.sliders.max_summon_potion_minutes").comment("Maximum value for the potion duration in minutes for summon").defineInRange("max_summon_potion_minutes", 100.0, 0.0, 16000.0);
        this.maxSummonAttributes = builder.translation("gui.worldhandler.config.sliders.max_summon_attributes").comment("Maximum value for attributes").defineInRange("max_summon_attributes", 100.0, 0.0, Double.MAX_VALUE);
        this.maxExperience = builder.translation("gui.worldhandler.config.sliders.max_experience").comment("Maximum value for experience").defineInRange("max_experience", 100.0, 0.0, 100000.0);
        this.maxPlayerPoints = builder.translation("gui.worldhandler.config.sliders.max_player_points").comment("Maximum value for player points").defineInRange("max_player_points", 100.0, 0.0, 100000.0);
        this.maxTriggerValue = builder.translation("gui.worldhandler.config.sliders.max_trigger_value").comment("Maximum value for triggers").defineInRange("max_trigger_value", 100.0, 0.0, 100000.0);
        builder.pop();
    }

    public double getMaxPotionAmplifier() {
        return (Double)this.maxPotionAmplifier.get();
    }

    public void setMaxPotionAmplifier(double max) {
        Config.set(this.maxPotionAmplifier, max);
    }

    public double getMaxItemEnchantment() {
        return (Double)this.maxItemEnchantment.get();
    }

    public void setMaxItemEnchantment(double max) {
        Config.set(this.maxItemEnchantment, max);
    }

    public double getMaxItemAttributes() {
        return (Double)this.maxItemAttributes.get();
    }

    public void setMaxItemAttributes(double max) {
        Config.set(this.maxItemAttributes, max);
    }

    public double getMaxSummonPotionAmplifier() {
        return (Double)this.maxSummonPotionAmplifier.get();
    }

    public void setMaxSummonPotionAmplifier(double max) {
        Config.set(this.maxSummonPotionAmplifier, max);
    }

    public double getMaxSummonPotionMinutes() {
        return (Double)this.maxSummonPotionMinutes.get();
    }

    public void setMaxSummonPotionMinutes(double max) {
        Config.set(this.maxSummonPotionMinutes, max);
    }

    public double getMaxSummonAttributes() {
        return (Double)this.maxSummonAttributes.get();
    }

    public void setMaxSummonAttributes(double max) {
        Config.set(this.maxSummonAttributes, max);
    }

    public double getMaxExperience() {
        return (Double)this.maxExperience.get();
    }

    public void setMaxExperience(double max) {
        Config.set(this.maxExperience, max);
    }

    public double getMaxPlayerPoints() {
        return (Double)this.maxPlayerPoints.get();
    }

    public void setMaxPlayerPoints(double max) {
        Config.set(this.maxPlayerPoints, max);
    }

    public double getMaxTriggerValue() {
        return (Double)this.maxTriggerValue.get();
    }

    public void setMaxTriggerValue(double max) {
        Config.set(this.maxTriggerValue, max);
    }
}

