/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.builder.argument.tag.AbstractAttributeTag;
import exopandora.worldhandler.builder.argument.tag.AttributeModifiersTag;
import exopandora.worldhandler.builder.argument.tag.DisplayTag;
import exopandora.worldhandler.builder.argument.tag.EnchantmentsTag;
import exopandora.worldhandler.builder.impl.GiveCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiSlider;
import exopandora.worldhandler.gui.widget.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.widget.button.LogicSliderAttribute;
import exopandora.worldhandler.gui.widget.button.LogicSliderSimple;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.widget.menu.impl.MenuColorField;
import exopandora.worldhandler.gui.widget.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import exopandora.worldhandler.util.TextUtils;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class ContentCustomItem
extends Content {
    private GuiTextFieldTooltip itemField;
    private GuiTextFieldTooltip itemLore1Field;
    private GuiTextFieldTooltip itemLore2Field;
    private final GiveCommandBuilder builderCutomItem = new GiveCommandBuilder();
    private final AttributeModifiersTag attributes = new AttributeModifiersTag();
    private final DisplayTag display = new DisplayTag();
    private final EnchantmentsTag enchantments = new EnchantmentsTag();
    private final IContent.CommandPreview preview = new IContent.CommandPreview(this.builderCutomItem, (Object)GiveCommandBuilder.Label.GIVE);
    private int startPage;
    private Page page = Page.START;
    private String item;

    public ContentCustomItem() {
        this.builderCutomItem.item().addTagProvider(this.attributes);
        this.builderCutomItem.item().addTagProvider(this.display);
        this.builderCutomItem.item().addTagProvider(this.enchantments);
    }

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.preview;
    }

    @Override
    public void init(Container container) {
        for (Attribute attribute : this.attributes.getAttributes()) {
            double range;
            double value = this.attributes.get(attribute);
            if (value > (range = Config.getSliders().getMaxItemAttributes())) {
                this.attributes.set(attribute, range);
                continue;
            }
            if (!(value < -range)) continue;
            this.attributes.set(attribute, -range);
        }
        for (Enchantment enchantment : this.enchantments.getEnchantments()) {
            short level = this.enchantments.get(enchantment);
            if (!((double)level > Config.getSliders().getMaxItemEnchantment())) continue;
            this.enchantments.set(enchantment, (short)Config.getSliders().getMaxItemEnchantment());
        }
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        this.itemField = new GuiTextFieldTooltip(x + 118, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.items.custom_item.start.item_id"));
        this.itemField.m_94153_((Predicate)Predicates.notNull());
        this.itemField.m_94144_(this.item);
        this.itemField.m_94151_(text -> {
            this.item = text;
            this.builderCutomItem.item().deserialize(this.item.replace(' ', '_'));
            container.initButtons();
        });
        this.itemLore1Field = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.items.custom_item.start.lore_1"));
        this.itemLore1Field.m_94153_((Predicate)Predicates.notNull());
        this.itemLore1Field.setText(this.display.getLore1());
        this.itemLore1Field.m_94151_(text -> {
            this.display.setLore1((Component)Component.m_237113_((String)text));
            container.initButtons();
        });
        this.itemLore2Field = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.items.custom_item.start.lore_2"));
        this.itemLore2Field.m_94153_((Predicate)Predicates.notNull());
        this.itemLore2Field.setText(this.display.getLore2());
        this.itemLore2Field.m_94151_(text -> {
            this.display.setLore2((Component)Component.m_237113_((String)text));
            container.initButtons();
        });
        if (Page.START.equals((Object)this.page)) {
            if (this.startPage == 1) {
                container.addMenu(new MenuColorField(x, y, "gui.worldhandler.items.custom_item.start.custom_name", this.display.getName()));
            }
        } else if (Page.ENCHANT.equals((Object)this.page)) {
            MenuPageList<Enchantment> enchantments = new MenuPageList<Enchantment>(x + 118, y, new ArrayList(ForgeRegistries.ENCHANTMENTS.getValues()), 114, 20, 3, container, new ILogicPageList<Enchantment>(){

                @Override
                public MutableComponent translate(Enchantment item) {
                    return Component.m_237115_((String)item.m_44704_());
                }

                @Override
                public MutableComponent toTooltip(Enchantment item) {
                    return Component.m_237113_((String)ForgeRegistries.ENCHANTMENTS.getKey((Object)item).toString());
                }

                @Override
                public void onClick(Enchantment item) {
                }

                @Override
                public GuiButtonBase onRegister(int x, int y, int width, int height, MutableComponent text, Enchantment item, ActionHandler actionHandler) {
                    return new GuiSlider(x, y, width, height, 0.0, Config.getSliders().getMaxItemEnchantment(), 0.0, container, new LogicSliderSimple(ForgeRegistries.ENCHANTMENTS.getKey((Object)item).toString(), text, value -> ContentCustomItem.this.enchantments.set(item, value.shortValue())));
                }

                @Override
                public boolean doDisable() {
                    return false;
                }

                @Override
                public String getId() {
                    return "enchantments";
                }
            });
            container.addMenu(enchantments);
        } else if (Page.ATTRIBUTES.equals((Object)this.page)) {
            MenuPageList<Attribute> attributes = new MenuPageList<Attribute>(x + 118, y, AbstractAttributeTag.ATTRIBUTES, 114, 20, 3, container, new ILogicPageList<Attribute>(){

                @Override
                public MutableComponent translate(Attribute attribute) {
                    return Component.m_237115_((String)attribute.m_22087_());
                }

                @Override
                public MutableComponent toTooltip(Attribute attribute) {
                    return Component.m_237113_((String)ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString());
                }

                @Override
                public void onClick(Attribute attribute) {
                }

                @Override
                public GuiButtonBase onRegister(int x, int y, int width, int height, MutableComponent text, Attribute attribute, ActionHandler actionHandler) {
                    return new GuiSlider(x, y, width, height, -Config.getSliders().getMaxItemAttributes(), Config.getSliders().getMaxItemAttributes(), 0.0, container, new LogicSliderAttribute(attribute, text, value -> ContentCustomItem.this.attributes.set(attribute, value.intValue())));
                }

                @Override
                public boolean doDisable() {
                    return false;
                }

                @Override
                public String getId() {
                    return "attributes";
                }
            });
            container.addMenu(attributes);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.m_142416_(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.items.custom_item.start"), () -> {
            this.page = Page.START;
            container.m_7856_();
        });
        container.m_142416_(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.items.custom_item.enchantment"), () -> {
            this.page = Page.ENCHANT;
            container.m_7856_();
        });
        container.m_142416_(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.items.custom_item.attributes"), () -> {
            this.page = Page.ATTRIBUTES;
            container.m_7856_();
        });
        container.m_142416_(button3);
        if (Page.START.equals((Object)this.page)) {
            button1.f_93623_ = false;
            GuiButtonBase button5 = new GuiButtonBase(x + 118, y + 72, 56, 20, TextUtils.ARROW_LEFT, () -> {
                --this.startPage;
                container.m_7856_();
            });
            container.m_142416_(button5);
            GuiButtonBase button6 = new GuiButtonBase(x + 118 + 60, y + 72, 55, 20, TextUtils.ARROW_RIGHT, () -> {
                ++this.startPage;
                container.m_7856_();
            });
            container.m_142416_(button6);
            if (this.startPage == 0) {
                button5.f_93623_ = false;
                container.m_142416_(this.itemField);
                container.m_142416_(this.itemLore1Field);
                container.m_142416_(this.itemLore2Field);
            } else if (this.startPage == 1) {
                button6.f_93623_ = false;
            }
        } else if (Page.ENCHANT.equals((Object)this.page)) {
            button2.f_93623_ = false;
        } else if (Page.ATTRIBUTES.equals((Object)this.page)) {
            button3.f_93623_ = false;
        }
        if (!this.builderCutomItem.needsCommandBlock((Object)GiveCommandBuilder.Label.GIVE, false) && !this.display.getName().isStyled()) {
            button4 = new GuiButtonBase(x, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.items.custom_item.custom_item"), () -> this.giveItem(container.getPlayer()));
            container.m_142416_(button4);
        } else {
            button4 = new GuiButtonBase(x, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.actions.place_command_block"), () -> this.giveItem(container.getPlayer()));
            container.m_142416_(button4);
        }
        button4.f_93623_ = this.builderCutomItem.item().hasValue();
    }

    private void giveItem(String player) {
        CommandHelper.sendCommand(player, this.builderCutomItem, (Object)GiveCommandBuilder.Label.GIVE, this.display.getName().isStyled());
    }

    @Override
    public void tick(Container container) {
        if (Page.START.equals((Object)this.page) && this.startPage == 0) {
            this.itemField.m_94120_();
            this.itemLore1Field.m_94120_();
            this.itemLore2Field.m_94120_();
        }
    }

    @Override
    public void drawScreen(PoseStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (Page.START.equals((Object)this.page) && this.startPage == 0) {
            this.itemField.m_6303_(matrix, mouseX, mouseY, partialTicks);
            this.itemLore1Field.m_6303_(matrix, mouseX, mouseY, partialTicks);
            this.itemLore2Field.m_6303_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public Category getCategory() {
        return Categories.ITEMS;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.items.custom_item");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.items.custom_item");
    }

    @Override
    public Content getActiveContent() {
        return Contents.CUSTOM_ITEM;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderCutomItem.targets().setTarget(username);
    }

    public static enum Page {
        START,
        ENCHANT,
        ATTRIBUTES;

    }
}

