/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.builder.impl.ClearInventoryCommandBuilder;
import exopandora.worldhandler.builder.impl.KillCommandBuilder;
import exopandora.worldhandler.builder.impl.SetSpawnCommandBuilder;
import exopandora.worldhandler.builder.impl.SetWorldSpawnCommandBuilder;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiTextFieldTooltip;
import exopandora.worldhandler.util.ActionHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;

public class ContentPlayer
extends Content {
    private Page page = Page.START;
    private GuiTextFieldTooltip posXField;
    private GuiTextFieldTooltip posYField;
    private GuiTextFieldTooltip posZField;
    private GuiTextFieldTooltip scoreField;
    private GuiTextFieldTooltip coinsField;
    private GuiTextFieldTooltip xpField;
    private final SetWorldSpawnCommandBuilder builderSetWorldSpawn = new SetWorldSpawnCommandBuilder();
    private final SetSpawnCommandBuilder builderSpawnpoint = new SetSpawnCommandBuilder();
    private final KillCommandBuilder builderKill = new KillCommandBuilder();
    private final ClearInventoryCommandBuilder builderClear = new ClearInventoryCommandBuilder();
    private final IContent.CommandPreview preview = new IContent.CommandPreview().add(this.builderSetWorldSpawn, (Object)SetWorldSpawnCommandBuilder.Label.SET_WORLD_SPAWN).add(this.builderSpawnpoint, (Object)SetSpawnCommandBuilder.Label.SPAWNPOINT).add(this.builderKill, (Object)KillCommandBuilder.Label.KILL).add(this.builderClear, (Object)ClearInventoryCommandBuilder.Label.CLEAR);

    @Override
    public IContent.CommandPreview getCommandPreview() {
        if (Page.MISC.equals((Object)this.page)) {
            return this.preview;
        }
        return null;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.posXField = new GuiTextFieldTooltip(x + 118, y, 114, 20);
        this.posYField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20);
        this.posZField = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20);
        this.scoreField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20);
        this.coinsField = new GuiTextFieldTooltip(x + 118, y + 36, 114, 20);
        this.xpField = new GuiTextFieldTooltip(x + 118, y + 60, 114, 20);
        this.tick(container);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.m_142416_(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.entities.player.start"), () -> {
            this.page = Page.START;
            container.m_7856_();
        });
        container.m_142416_(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.entities.player.score"), () -> {
            this.page = Page.SCORE;
            container.m_7856_();
        });
        container.m_142416_(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.entities.player.position"), () -> {
            this.page = Page.POSITION;
            container.m_7856_();
        });
        container.m_142416_(button3);
        GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.entities.player.miscellaneous"), () -> {
            this.page = Page.MISC;
            container.m_7856_();
        });
        container.m_142416_(button4);
        if (Page.START.equals((Object)this.page)) {
            button1.f_93623_ = false;
        } else if (Page.SCORE.equals((Object)this.page)) {
            button2.f_93623_ = false;
        } else if (Page.POSITION.equals((Object)this.page)) {
            button3.f_93623_ = false;
            container.m_142416_(new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.entities.player.position.copy_position"), () -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    BlockPos position = player.m_20183_();
                    Minecraft.m_91087_().f_91068_.m_90911_(position.m_123341_() + " " + position.m_123342_() + " " + position.m_123343_());
                }
            }));
        } else if (Page.MISC.equals((Object)this.page)) {
            button4.f_93623_ = false;
            container.m_142416_(new GuiButtonBase(x + 118, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.entities.player.miscellaneous.set_spawn").m_130940_(ChatFormatting.RED), () -> ActionHelper.open(Contents.CONTINUE.withBuilder(this.builderSpawnpoint, (Object)SetSpawnCommandBuilder.Label.SPAWNPOINT))));
            container.m_142416_(new GuiButtonBase(x + 118, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.entities.player.miscellaneous.set_global_spawn").m_130940_(ChatFormatting.RED), () -> ActionHelper.open(Contents.CONTINUE.withBuilder(this.builderSetWorldSpawn, (Object)SetWorldSpawnCommandBuilder.Label.SET_WORLD_SPAWN))));
            container.m_142416_(new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.entities.player.miscellaneous.kill").m_130940_(ChatFormatting.RED), () -> ActionHelper.open(Contents.CONTINUE.withBuilder(this.builderKill, (Object)KillCommandBuilder.Label.KILL))));
            container.m_142416_(new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.entities.player.miscellaneous.clear_inventory").m_130940_(ChatFormatting.RED), () -> ActionHelper.open(Contents.CONTINUE.withBuilder(this.builderClear, (Object)ClearInventoryCommandBuilder.Label.CLEAR))));
        }
    }

    @Override
    public void tick(Container container) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            BlockPos position = player.m_20183_();
            this.posXField.m_94144_("X: " + position.m_123341_());
            this.posYField.m_94144_("Y: " + position.m_123342_());
            this.posZField.m_94144_("Z: " + position.m_123343_());
            this.scoreField.m_94144_(I18n.m_118938_((String)"gui.worldhandler.entities.player.score", (Object[])new Object[0]) + ": " + player.m_36344_());
            this.coinsField.m_94144_(I18n.m_118938_((String)"gui.worldhandler.entities.player.score.experience", (Object[])new Object[0]) + ": " + player.f_36078_ + "L");
            this.xpField.m_94144_(I18n.m_118938_((String)"gui.worldhandler.entities.player.score.experience_coins", (Object[])new Object[0]) + ": " + player.f_36079_);
        }
    }

    @Override
    public void drawScreen(PoseStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (Page.START.equals((Object)this.page) && Minecraft.m_91087_().f_91074_ != null) {
            int xPos = x + 175;
            int yPos = y + 82;
            int playerNameWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)Minecraft.m_91087_().f_91074_.m_7755_()) / 2;
            GuiComponent.m_93172_((PoseStack)matrix, (int)(container.f_96543_ / 2 - playerNameWidth - 1 + 59), (int)(yPos - 74), (int)(container.f_96543_ / 2 + playerNameWidth + 1 + 59), (int)(yPos - 65), (int)0x3F000000);
            Minecraft.m_91087_().f_91062_.m_92889_(matrix, Minecraft.m_91087_().f_91074_.m_7755_(), (float)(container.f_96543_ / 2 - playerNameWidth + 59), (float)(yPos - 73), 0xE0E0E0);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            InventoryScreen.m_98850_((int)xPos, (int)yPos, (int)30, (float)(xPos - mouseX), (float)(yPos - mouseY - 44), (LivingEntity)Minecraft.m_91087_().f_91074_);
            RenderSystem.m_69453_();
        } else if (Page.SCORE.equals((Object)this.page)) {
            this.scoreField.m_6303_(matrix, mouseX, mouseY, partialTicks);
            this.xpField.m_6303_(matrix, mouseX, mouseY, partialTicks);
            this.coinsField.m_6303_(matrix, mouseX, mouseY, partialTicks);
        } else if (Page.POSITION.equals((Object)this.page)) {
            this.posXField.m_6303_(matrix, mouseX, mouseY, partialTicks);
            this.posYField.m_6303_(matrix, mouseX, mouseY, partialTicks);
            this.posZField.m_6303_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderSpawnpoint.targets().setTarget(username);
        this.builderKill.targets().setTarget(username);
    }

    @Override
    public Category getCategory() {
        return Categories.PLAYER;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.player.player");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.player.player");
    }

    @Override
    public Content getActiveContent() {
        return Contents.PLAYER;
    }

    public static enum Page {
        START,
        SCORE,
        POSITION,
        MISC;

    }
}

