/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.builder.argument.Coordinate;
import exopandora.worldhandler.builder.argument.tag.AbstractAttributeTag;
import exopandora.worldhandler.builder.argument.tag.ActiveEffectsTag;
import exopandora.worldhandler.builder.argument.tag.AttributesTag;
import exopandora.worldhandler.builder.argument.tag.EffectInstance;
import exopandora.worldhandler.builder.argument.tag.EntityTag;
import exopandora.worldhandler.builder.argument.tag.MutableTag;
import exopandora.worldhandler.builder.impl.SummonCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.EnumIcon;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonIcon;
import exopandora.worldhandler.gui.widget.button.GuiButtonItem;
import exopandora.worldhandler.gui.widget.button.GuiSlider;
import exopandora.worldhandler.gui.widget.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.widget.button.LogicSliderAttribute;
import exopandora.worldhandler.gui.widget.button.LogicSliderSimple;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicColorMenu;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.widget.menu.impl.MenuColorField;
import exopandora.worldhandler.gui.widget.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import exopandora.worldhandler.util.TextUtils;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ContentSummon
extends Content {
    private static final ResourceLocation BEACON_LOCATION = new ResourceLocation("textures/gui/container/beacon.png");
    private static final Item[] HELMETS = new Item[]{Items.f_41852_, Items.f_42407_, Items.f_42468_, Items.f_42464_, Items.f_42476_, Items.f_42472_, Items.f_42480_};
    private static final Item[] CHESTPLATES = new Item[]{Items.f_41852_, Items.f_42408_, Items.f_42469_, Items.f_42465_, Items.f_42477_, Items.f_42473_, Items.f_42481_};
    private static final Item[] LEGGINGS = new Item[]{Items.f_41852_, Items.f_42462_, Items.f_42470_, Items.f_42466_, Items.f_42478_, Items.f_42474_, Items.f_42482_};
    private static final Item[] BOOTS = new Item[]{Items.f_41852_, Items.f_42463_, Items.f_42471_, Items.f_42467_, Items.f_42479_, Items.f_42475_, Items.f_42483_};
    private static final Item[] SWORDS = new Item[]{Items.f_41852_, Items.f_42420_, Items.f_42425_, Items.f_42383_, Items.f_42430_, Items.f_42388_, Items.f_42393_};
    private static final Item[][] ARMOR = new Item[][]{HELMETS, CHESTPLATES, LEGGINGS, BOOTS};
    private static final Item[][] HANDS = new Item[][]{SWORDS, SWORDS};
    private static final Random RANDOM = new Random();
    private GuiTextFieldTooltip mobField;
    private GuiTextFieldTooltip nbtField;
    private int potionPage = 0;
    private boolean editColor;
    private Page page = Page.START;
    private String mob;
    private String nbt;
    private final SummonCommandBuilder builderSummon = new SummonCommandBuilder();
    private final EntityTag entity = new EntityTag();
    private final AttributesTag attributes = new AttributesTag();
    private final ActiveEffectsTag effects = new ActiveEffectsTag();
    private final MutableTag mutable = new MutableTag();
    private final IContent.CommandPreview preview = new IContent.CommandPreview(this.builderSummon, (Object)SummonCommandBuilder.Label.SUMMON_POS_NBT);

    public ContentSummon() {
        this.builderSummon.pos().setX(new Coordinate.Ints(Coordinate.Type.LOCAL));
        this.builderSummon.pos().setY(new Coordinate.Ints(Coordinate.Type.LOCAL));
        this.builderSummon.pos().setZ(new Coordinate.Ints(2, Coordinate.Type.LOCAL));
        this.builderSummon.nbt().addTagProvider(this.entity);
        this.builderSummon.nbt().addTagProvider(this.attributes);
        this.builderSummon.nbt().addTagProvider(this.effects);
        this.builderSummon.nbt().addTagProvider(this.mutable);
    }

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.preview;
    }

    @Override
    public void init(Container container) {
        for (Attribute attribute : this.attributes.getAttributes()) {
            double range;
            double value = this.attributes.get(attribute);
            if (value > (range = Config.getSliders().getMaxSummonAttributes())) {
                this.attributes.set(attribute, range);
                continue;
            }
            if (!(value < -range)) continue;
            this.attributes.set(attribute, -range);
        }
        for (MobEffect effect : this.effects.getMobEffects()) {
            EffectInstance tag = this.effects.getOrCreate(effect);
            if ((double)tag.getAmplifier() > Config.getSliders().getMaxSummonPotionAmplifier()) {
                tag.setAmplifier((byte)Config.getSliders().getMaxSummonPotionAmplifier());
            }
            if (!((double)tag.getMinutes() > Config.getSliders().getMaxSummonPotionMinutes())) continue;
            tag.setMinutes((int)Config.getSliders().getMaxSummonPotionMinutes());
        }
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        this.mobField = new GuiTextFieldTooltip(x + 118, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.entities.summon.start.mob_id"));
        this.mobField.m_94153_((Predicate)Predicates.notNull());
        this.mobField.m_94144_(this.mob);
        this.mobField.m_94151_(text -> {
            this.mob = text;
            this.builderSummon.entity().deserialize(this.mob);
            this.updateMutableTag();
            container.initButtons();
        });
        this.nbtField = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.entities.summon.start.custom_nbt"));
        this.nbtField.m_94153_((Predicate)Predicates.notNull());
        this.nbtField.m_94144_(this.nbt);
        this.nbtField.m_94151_(text -> {
            this.nbt = text;
            this.entity.setNBT(this.nbt);
            container.initButtons();
        });
        if (Page.START.equals((Object)this.page)) {
            MenuColorField customName = new MenuColorField(x, y, "gui.worldhandler.entities.summon.start.custom_name", this.entity.getCustomName(), new ILogicColorMenu(){

                @Override
                public boolean doDrawButtons() {
                    return ContentSummon.this.editColor;
                }

                @Override
                public boolean doDrawTextField() {
                    return ContentSummon.this.editColor;
                }

                @Override
                public String getId() {
                    return "custom_name";
                }
            });
            container.addMenu(customName);
        } else if (Page.ATTRIBUTES.equals((Object)this.page)) {
            MenuPageList<Attribute> attributes = new MenuPageList<Attribute>(x + 118, y, AbstractAttributeTag.ATTRIBUTES, 114, 20, 3, container, new ILogicPageList<Attribute>(){

                @Override
                public MutableComponent translate(Attribute attribute) {
                    return Component.m_237115_((String)attribute.m_22087_());
                }

                @Override
                public MutableComponent toTooltip(Attribute attribute) {
                    return Component.m_237113_((String)ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString());
                }

                @Override
                public void onClick(Attribute item) {
                }

                @Override
                public GuiButtonBase onRegister(int x, int y, int width, int height, MutableComponent text, Attribute attribute, ActionHandler actionHandler) {
                    return new GuiSlider(x, y, width, height, -Config.getSliders().getMaxSummonAttributes(), Config.getSliders().getMaxSummonAttributes(), 0.0, container, new LogicSliderAttribute(attribute, text, value -> ContentSummon.this.attributes.set(attribute, value.intValue())));
                }

                @Override
                public boolean doDisable() {
                    return false;
                }

                @Override
                public String getId() {
                    return "attributes";
                }
            });
            container.addMenu(attributes);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.m_142416_(new GuiButtonBase(x, y + 96, 114, 20, "gui.worldhandler.generic.back", () -> ActionHelper.back(this)));
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, "gui.worldhandler.generic.backToGame", ActionHelper::backToGame));
        GuiButtonBase button4 = new GuiButtonBase(x, y, 114, 20, "gui.worldhandler.entities.summon.start", () -> this.changePage(container, Page.START));
        container.m_142416_(button4);
        GuiButtonBase button5 = new GuiButtonBase(x, y + 24, 114, 20, "gui.worldhandler.entities.summon.potion_effects", () -> this.changePage(container, Page.POTIONS));
        container.m_142416_(button5);
        GuiButtonBase button6 = new GuiButtonBase(x, y + 48, 114, 20, "gui.worldhandler.entities.summon.attributes", () -> this.changePage(container, Page.ATTRIBUTES));
        container.m_142416_(button6);
        GuiButtonBase button7 = new GuiButtonBase(x, y + 72, 114, 20, "gui.worldhandler.entities.summon.equipment", () -> this.changePage(container, Page.EQUIPMENT));
        container.m_142416_(button7);
        if (Page.START.equals((Object)this.page)) {
            button4.f_93623_ = false;
            if (this.editColor) {
                container.m_142416_(new GuiButtonBase(x + 118, y + 72, 114, 20, "gui.worldhandler.generic.done", () -> this.toggleEditColor(container)));
            } else {
                container.m_142416_(this.mobField);
                container.m_142416_(new GuiButtonBase(x + 118, y + 24, 114, 20, "gui.worldhandler.entities.summon.start.custom_name", () -> this.toggleEditColor(container)));
                container.m_142416_(this.nbtField);
                if (!this.builderSummon.needsCommandBlock((Object)SummonCommandBuilder.Label.SUMMON_POS_NBT, false) && !this.entity.getCustomName().isStyled()) {
                    button3 = new GuiButtonBase(x + 118, y + 72, 114, 20, "gui.worldhandler.title.entities.summon", () -> this.send(container.getPlayer()));
                    container.m_142416_(button3);
                } else {
                    button3 = new GuiButtonBase(x + 118, y + 72, 114, 20, "gui.worldhandler.actions.place_command_block", () -> this.send(container.getPlayer()));
                    container.m_142416_(button3);
                }
                button3.f_93623_ = this.builderSummon.entity().hasValue();
            }
        } else if (Page.POTIONS.equals((Object)this.page)) {
            button5.f_93623_ = false;
            GuiButtonBase button1 = new GuiButtonBase(x + 118, y + 72, 56, 20, TextUtils.ARROW_LEFT, () -> {
                --this.potionPage;
                container.m_7856_();
            });
            container.m_142416_(button1);
            GuiButtonBase button2 = new GuiButtonBase(x + 118 + 60, y + 72, 55, 20, TextUtils.ARROW_RIGHT, () -> {
                ++this.potionPage;
                container.m_7856_();
            });
            container.m_142416_(button2);
            int count = 0;
            for (ResourceLocation location : this.sortedEffects()) {
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(location);
                if (effect.equals(MobEffects.f_19602_) || effect.equals(MobEffects.f_19601_)) continue;
                if (this.potionPage == 0) {
                    button1.f_93623_ = false;
                }
                if (this.potionPage == ForgeRegistries.MOB_EFFECTS.getKeys().size() - 3) {
                    button2.f_93623_ = false;
                }
                if (count == this.potionPage) {
                    EffectInstance tag = this.effects.getOrCreate(effect);
                    container.m_142416_(new GuiSlider(x + 118, y, 114, 20, 0.0, Config.getSliders().getMaxSummonPotionAmplifier(), 0.0, container, new LogicSliderSimple("amplifier" + ForgeRegistries.MOB_EFFECTS.getKey((Object)effect), Component.m_237115_((String)effect.m_19481_()), value -> tag.setAmplifier(value.byteValue()))));
                    container.m_142416_(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, Config.getSliders().getMaxSummonPotionMinutes(), 0.0, container, new LogicSliderSimple("duration" + ForgeRegistries.MOB_EFFECTS.getKey((Object)effect), Component.m_237115_((String)"gui.worldhandler.potion.time.minutes"), value -> tag.setMinutes((int)value))));
                    container.m_142416_(new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)Component.m_237110_((String)"gui.worldhandler.potions.effect.particles", (Object[])new Object[]{tag.doShowParticles() ? Component.m_237115_((String)"gui.worldhandler.generic.on") : Component.m_237115_((String)"gui.worldhandler.generic.off")}), () -> {
                        tag.setShowParticles(!tag.doShowParticles());
                        container.m_7856_();
                    }));
                    break;
                }
                ++count;
            }
        } else if (Page.ATTRIBUTES.equals((Object)this.page)) {
            button6.f_93623_ = false;
        } else if (Page.EQUIPMENT.equals((Object)this.page)) {
            GuiButtonItem button1;
            int index;
            int i;
            for (i = 0; i < 4; ++i) {
                index = i;
                container.m_142416_(new GuiButtonBase(x + 118, y + 24 * i, 20, 20, TextUtils.ARROW_LEFT, () -> {
                    this.entity.setArmorItem(3 - index, ARMOR[index][Math.floorMod(ArrayUtils.indexOf((Object[])ARMOR[index], (Object)this.entity.getArmorItem(3 - index)) - 1, ARMOR[index].length)]);
                    container.m_7856_();
                }));
                button1 = new GuiButtonItem(x + 118 + 24, y + 24 * i, 20, 20, this.entity.getArmorItem(3 - i), null);
                container.m_142416_(button1);
                container.m_142416_(new GuiButtonBase(x + 118 + 47, y + 24 * i, 20, 20, TextUtils.ARROW_RIGHT, () -> {
                    this.entity.setArmorItem(3 - index, ARMOR[index][Math.floorMod(ArrayUtils.indexOf((Object[])ARMOR[index], (Object)this.entity.getArmorItem(3 - index)) + 1, ARMOR[index].length)]);
                    container.m_7856_();
                }));
                button1.f_93623_ = false;
            }
            for (i = 0; i < 2; ++i) {
                index = i;
                container.m_142416_(new GuiButtonIcon(x + 118 + 70 + 24 * i, y + 12, 20, 20, EnumIcon.ARROW_UP, null, () -> {
                    this.entity.setHandItem(index, HANDS[index][Math.floorMod(ArrayUtils.indexOf((Object[])HANDS[index], (Object)this.entity.getHandItem(index)) - 1, HANDS[index].length)]);
                    container.m_7856_();
                }));
                button1 = new GuiButtonItem(x + 118 + 70 + 24 * i, y + 36, 20, 20, this.entity.getHandItem(i), null);
                container.m_142416_(button1);
                container.m_142416_(new GuiButtonIcon(x + 118 + 70 + 24 * i, y + 60, 20, 20, EnumIcon.ARROW_DOWN, null, () -> {
                    this.entity.setHandItem(index, HANDS[index][Math.floorMod(ArrayUtils.indexOf((Object[])HANDS[index], (Object)this.entity.getHandItem(index)) + 1, HANDS[index].length)]);
                    container.m_7856_();
                }));
                button1.f_93623_ = false;
            }
            button7.f_93623_ = false;
        }
    }

    private void send(String player) {
        CommandHelper.sendCommand(player, this.builderSummon, (Object)SummonCommandBuilder.Label.SUMMON_POS_NBT, this.entity.getCustomName().isStyled());
    }

    private void updateMutableTag() {
        EntityType<?> entity = this.builderSummon.entity().getEntity();
        if (EntityType.f_20553_.equals(entity)) {
            this.mutable.setKey("CatType");
            this.mutable.setTag((Tag)IntTag.m_128679_((int)RANDOM.nextInt(11)));
        } else if (EntityType.f_20492_.equals(entity)) {
            for (VillagerProfession profession : ForgeRegistries.VILLAGER_PROFESSIONS) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)this.mob, (CharSequence)profession.toString())) continue;
                CompoundTag villagerData = new CompoundTag();
                villagerData.m_128359_("profession", ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)profession).toString());
                this.mutable.setKey("VillagerData");
                this.mutable.setTag((Tag)villagerData);
                return;
            }
            this.mutable.reset();
        } else if (EntityType.f_20501_.equals(entity) && StringUtils.containsIgnoreCase((CharSequence)this.mob, (CharSequence)"Baby")) {
            this.mutable.setKey("IsBaby");
            this.mutable.setTag((Tag)ByteTag.m_128266_((byte)1));
        } else if (EntityType.f_20555_.equals(entity) && StringUtils.containsIgnoreCase((CharSequence)this.mob, (CharSequence)"Jockey") && !this.entity.hasPassengers()) {
            ListTag list = new ListTag();
            EntityTag zombie = new EntityTag(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20501_));
            zombie.setIsBaby(true);
            list.add((Object)zombie.value());
            this.mutable.setKey("Passengers");
            this.mutable.setTag((Tag)list);
        } else if (EntityType.f_20479_.equals(entity) && StringUtils.containsIgnoreCase((CharSequence)this.mob, (CharSequence)"Jockey") && !this.entity.hasPassengers()) {
            ListTag list = new ListTag();
            EntityTag skeleton = new EntityTag(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20524_));
            skeleton.setHandItem(0, Items.f_42411_);
            list.add((Object)skeleton.value());
            this.mutable.setKey("Passengers");
            this.mutable.setTag((Tag)list);
        } else {
            this.mutable.reset();
        }
    }

    @Override
    public void tick(Container container) {
        if (Page.START.equals((Object)this.page) && !this.editColor) {
            this.mobField.m_94120_();
            this.nbtField.m_94120_();
        }
    }

    @Override
    public void drawScreen(PoseStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (Page.START.equals((Object)this.page)) {
            if (!this.editColor) {
                this.mobField.m_6303_(matrix, mouseX, mouseY, partialTicks);
                this.nbtField.m_6303_(matrix, mouseX, mouseY, partialTicks);
            }
        } else if (Page.POTIONS.equals((Object)this.page)) {
            Minecraft.m_91087_().f_91062_.m_92883_(matrix, this.potionPage + 1 + "/" + (ForgeRegistries.MOB_EFFECTS.getKeys().size() - 2), (float)(x + 118), (float)(y - 11), Config.getSkin().getHeadlineColor());
        } else if (Page.EQUIPMENT.equals((Object)this.page)) {
            int i;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)BEACON_LOCATION);
            container.m_93250_(0);
            for (i = 0; i < 4; ++i) {
                if (!Items.f_41852_.equals(this.entity.getArmorItem(3 - i))) continue;
                container.m_93228_(matrix, x + 118 + 24 + 2, y + 2 + 24 * i, 112, 221, 16, 16);
            }
            for (i = 0; i < 2; ++i) {
                if (!Items.f_41852_.equals(this.entity.getHandItem(i))) continue;
                container.m_93228_(matrix, x + 118 + 70 + 2 + 24 * i, y + 2 + 36, 112, 221, 16, 16);
            }
        }
    }

    private List<ResourceLocation> sortedEffects() {
        return ForgeRegistries.MOB_EFFECTS.getKeys().stream().sorted((a, b) -> I18n.m_118938_((String)((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(a)).m_19481_(), (Object[])new Object[0]).compareTo(I18n.m_118938_((String)((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(b)).m_19481_(), (Object[])new Object[0]))).collect(Collectors.toList());
    }

    private void toggleEditColor(Container container) {
        this.editColor = !this.editColor;
        container.m_7856_();
    }

    private void changePage(Container container, Page page) {
        this.page = page;
        container.m_7856_();
    }

    @Override
    public Category getCategory() {
        return Categories.ENTITIES;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.entities.summon");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.entities.summon");
    }

    @Override
    public Content getActiveContent() {
        return Contents.SUMMON;
    }

    public static enum Page {
        START,
        POTIONS,
        ATTRIBUTES,
        EQUIPMENT;

    }
}

