/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.widget.menu.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.menu.Menu;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicPageList;
import exopandora.worldhandler.util.TextUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MenuPageList<T>
extends Menu {
    private final List<T> items;
    private final ILogicPageList<T> logic;
    private final Persistence persistence;
    private final int width;
    private final int height;
    private final int length;

    public MenuPageList(int x, int y, List<T> items, int width, int height, int length, Container container, ILogicPageList<T> logic) {
        super(x, y);
        this.items = Objects.requireNonNull(items);
        this.width = width;
        this.height = height;
        this.length = length;
        this.logic = Objects.requireNonNull(logic);
        this.items.sort((a, b) -> this.logic.translate(a).getString().compareTo(this.logic.translate(b).getString()));
        this.persistence = container.getContent().getPersistence(logic.getId(), Persistence::new);
        if (!this.items.isEmpty()) {
            this.logic.onClick(this.items.get(this.persistence.getSelectedIndex()));
        }
    }

    @Override
    public void initGui(Container container) {
    }

    @Override
    public void initButtons(Container container) {
        boolean extended;
        boolean bl = extended = this.items.size() == this.length + 1;
        if (!extended) {
            int buttonWidth = (this.width - 4) / 2;
            GuiButtonBase left = new GuiButtonBase(this.x, this.y + (this.height + 4) * this.length, buttonWidth + 1, this.height, TextUtils.ARROW_LEFT, () -> this.goLeft(container));
            left.f_93623_ = this.persistence.getPage() > 0;
            container.m_142416_(left);
            GuiButtonBase right = new GuiButtonBase(this.x + 5 + buttonWidth, this.y + (this.height + 4) * this.length, buttonWidth, this.height, TextUtils.ARROW_RIGHT, () -> this.goRight(container));
            right.f_93623_ = this.persistence.getPage() < this.getTotalPages() - 1;
            container.m_142416_(right);
        }
        int length = extended ? this.length + 1 : this.length;
        for (int x = 0; x < length; ++x) {
            GuiButtonBase button;
            int index = this.persistence.getPage() * length + x;
            if (index < this.items.size()) {
                T item = this.items.get(index);
                MutableComponent text = TextUtils.stripText(this.logic.translate(item), this.width, Minecraft.m_91087_().f_91062_);
                button = this.logic.onRegister(this.x, this.y + (this.height + 4) * x, this.width, this.height, text, item, () -> {
                    this.persistence.setSelectedIndex(index);
                    this.logic.onClick(item);
                });
                if (this.logic.doDisable()) {
                    button.f_93623_ = this.persistence.getSelectedIndex() != index;
                }
            } else {
                button = new GuiButtonBase(this.x, this.y + (this.height + 4) * x, this.width, this.height, (Component)Component.m_237119_(), null);
                button.f_93623_ = false;
            }
            container.m_142416_(button);
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public void draw(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        Minecraft.m_91087_().f_91062_.m_92883_(matrix, String.format("%d/%d", this.persistence.getPage() + 1, this.getTotalPages()), (float)this.x, (float)(this.y - 11), Config.getSkin().getHeadlineColor());
    }

    private void goLeft(Container container) {
        int page = this.persistence.getPage();
        if (Screen.m_96638_()) {
            this.persistence.setPage(page - Math.min(10, page));
        } else {
            this.persistence.setPage(page - 1);
        }
        container.initButtons();
    }

    private void goRight(Container container) {
        int page = this.persistence.getPage();
        if (Screen.m_96638_()) {
            this.persistence.setPage(page + Math.min(10, this.getTotalPages() - 1 - page));
        } else {
            this.persistence.setPage(page + 1);
        }
        container.initButtons();
    }

    private int getTotalPages() {
        return Math.max((int)Math.ceil((float)this.items.size() / (float)this.length), 1);
    }

    public static class Persistence {
        private int page;
        private int selectedIndex;

        public Persistence() {
            this(0, 0);
        }

        public Persistence(int page, int selectedIndex) {
            this.page = page;
            this.selectedIndex = selectedIndex;
        }

        public int getPage() {
            return this.page;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }
    }
}

