/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import exopandora.worldhandler.builder.argument.tag.EntityTag;
import exopandora.worldhandler.builder.argument.tag.ITagProvider;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class NBTHelper {
    public static Tag serialize(BlockState blockState) {
        return blockState != null ? NbtUtils.m_129202_((BlockState)blockState) : null;
    }

    public static Tag serialize(double[] vector) {
        if (vector.length == 3 && (vector[0] != 0.0 || vector[1] != 0.0 || vector[2] != 0.0)) {
            ListTag list = new ListTag();
            list.add((Object)DoubleTag.m_128500_((double)vector[0]));
            list.add((Object)DoubleTag.m_128500_((double)vector[1]));
            list.add((Object)DoubleTag.m_128500_((double)vector[2]));
            return list;
        }
        return null;
    }

    public static Tag serialize(ResourceLocation resource) {
        if (resource != null) {
            return StringTag.m_129297_((String)resource.toString());
        }
        return null;
    }

    public static Tag serialize(Item[] itemArray) {
        if (Arrays.stream(itemArray).allMatch(Items.f_41852_::equals)) {
            return null;
        }
        ListTag list = new ListTag();
        for (Item item : itemArray) {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("id", ForgeRegistries.ITEMS.getKey((Object)item).toString());
            compound.m_128405_("Count", 1);
            list.add((Object)compound);
        }
        return list;
    }

    public static Tag serialize(List<EntityTag> entities) {
        ListTag list = new ListTag();
        for (EntityTag entity : entities) {
            Tag nbt = entity.value();
            if (nbt == null) continue;
            list.add((Object)nbt);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public static void append(CompoundTag compound, ITagProvider component) {
        NBTHelper.append(compound, component.key(), component.value());
    }

    public static void append(CompoundTag compound, String tag, Tag nbt) {
        if (nbt != null && !compound.m_128441_(tag)) {
            compound.m_128365_(tag, nbt);
        }
    }
}

