/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.argument;

import exopandora.worldhandler.builder.argument.IDeserializableArgument;
import exopandora.worldhandler.util.ResourceHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class EntitySummonArgument
implements IDeserializableArgument {
    private static final Map<String, ResourceLocation> ALIASES = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put("RedCow", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20504_));
        map.put("ChickenJockey", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20555_));
        map.put("Pigman", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20511_));
        map.put("ZombiePig", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20511_));
        map.put("ZombiePigman", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20511_));
        map.put("Dog", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20499_));
        map.put("Dragon", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20565_));
        map.put("SnowMan", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20528_));
        map.put("LavaCube", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20468_));
        map.put("MagmaSlime", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20468_));
        map.put("LavaSlime", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20468_));
        map.put("SpiderJockey", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20479_));
        map.put("VillagerGolem", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20460_));
        map.put("Ozelot", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20505_));
        map.put("Kitty", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20553_));
        map.put("Kitten", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20553_));
        map.put("TESTIFICATE", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20492_));
        map.put("Octopus", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20480_));
        map.put("GlowingOctopus", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20480_));
        map.put("Exwife", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20453_));
        map.put("CommandMinecart", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20471_));
        map.put("Wizard", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20568_));
        map.put("Johnny", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20493_));
        map.put("BabyZombie", ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20501_));
        ForgeRegistries.VILLAGER_PROFESSIONS.getEntries().stream().forEach(profession -> map.put(((ResourceKey)profession.getKey()).m_135782_().m_135815_(), ((ResourceKey)profession.getKey()).m_135782_()));
    });
    private EntityType<?> entity;

    protected EntitySummonArgument() {
    }

    public void set(@Nullable EntityType<?> entity) {
        this.entity = entity != null && entity.m_20654_() ? entity : null;
    }

    public void set(@Nullable ResourceLocation entity) {
        if (entity != null) {
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entity);
            ResourceLocation location = ForgeRegistries.ENTITY_TYPES.getKey((Object)type);
            if (!ForgeRegistries.ENTITY_TYPES.getDefaultKey().equals((Object)location) || location.equals((Object)entity)) {
                this.set(type);
            } else {
                this.entity = null;
            }
        } else {
            this.entity = null;
        }
    }

    @Nullable
    public EntityType<?> getEntity() {
        return this.entity;
    }

    @Override
    public void deserialize(@Nullable String entity) {
        if (entity == null) {
            this.entity = null;
        } else {
            String stripped = entity.replace(" ", "");
            for (Map.Entry<String, ResourceLocation> entry : ALIASES.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(stripped)) continue;
                this.set(entry.getValue());
                return;
            }
            this.set(ResourceHelper.stringToResourceLocation(entity));
        }
    }

    @Override
    @Nullable
    public String serialize() {
        if (this.entity == null) {
            return null;
        }
        return ForgeRegistries.ENTITY_TYPES.getKey(this.entity).toString();
    }

    @Override
    public boolean isDefault() {
        return this.entity == null;
    }
}

