/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.impl.AdvancementCommandBuilder;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonList;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicMapped;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.widget.menu.impl.MenuPageList;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.AdvancementHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ContentAdvancements
extends Content {
    private final AdvancementCommandBuilder builderAdvancement = new AdvancementCommandBuilder();
    private Mode mode = Mode.ONLY;

    @Override
    public IContent.CommandPreview getCommandPreview() {
        IContent.CommandPreview preview = new IContent.CommandPreview().add(this.builderAdvancement, (Object)this.mode.getGrant()).add(this.builderAdvancement, (Object)this.mode.getRevoke());
        return preview;
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        List advancements = AdvancementHelper.getInstance().getAdvancements().stream().filter(advancement -> advancement.m_138320_() != null).collect(Collectors.toList());
        MenuPageList<Advancement> list = new MenuPageList<Advancement>(x, y, advancements, 114, 20, 3, container, new ILogicPageList<Advancement>(){

            @Override
            public MutableComponent translate(Advancement item) {
                return (MutableComponent)item.m_138320_().m_14977_();
            }

            @Override
            public MutableComponent toTooltip(Advancement item) {
                return Component.m_237113_((String)item.m_138327_().toString());
            }

            @Override
            public void onClick(Advancement item) {
                ContentAdvancements.this.builderAdvancement.advancement().set(item.m_138327_());
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, MutableComponent text, Advancement item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, (Component)text, (Component)this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "advancement";
            }
        });
        container.addMenu(list);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.m_142416_(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        container.m_142416_(new GuiButtonList<Mode>(x + 118, y, Arrays.asList(Mode.values()), 114, 20, container, new ILogicMapped<Mode>(){

            @Override
            public MutableComponent translate(Mode mode) {
                return Component.m_237115_((String)("gui.worldhandler.advancements." + mode.toString()));
            }

            @Override
            public MutableComponent toTooltip(Mode mode) {
                return Component.m_237113_((String)mode.toString());
            }

            @Override
            public void onClick(Mode mode) {
                ContentAdvancements.this.mode = mode;
            }

            @Override
            public String getId() {
                return "mode";
            }
        }));
        container.m_142416_(new GuiButtonBase(x + 118, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.advancements.grant"), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderAdvancement, (Object)this.mode.getGrant())));
        container.m_142416_(new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.advancements.revoke"), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderAdvancement, (Object)this.mode.getRevoke())));
        container.m_142416_(new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.actions.reset").m_130940_(ChatFormatting.RED), () -> ActionHelper.open(Contents.CONTINUE.withBuilder(this.builderAdvancement, (Object)AdvancementCommandBuilder.Label.REVOKE_EVERYTHING))));
    }

    @Override
    public Category getCategory() {
        return Categories.PLAYER;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.player.advancements");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.player.advancements");
    }

    @Override
    public Content getActiveContent() {
        return Contents.ADVANCEMENTS;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderAdvancement.targets().setTarget(username);
    }

    private static enum Mode {
        ONLY(AdvancementCommandBuilder.Label.GRANT_ONLY, AdvancementCommandBuilder.Label.REVOKE_ONLY),
        UNTIL(AdvancementCommandBuilder.Label.GRANT_UNTIL, AdvancementCommandBuilder.Label.REVOKE_UNTIL),
        FROM(AdvancementCommandBuilder.Label.GRANT_FROM, AdvancementCommandBuilder.Label.REVOKE_FROM),
        THROUGH(AdvancementCommandBuilder.Label.GRANT_THROUGH, AdvancementCommandBuilder.Label.REVOKE_THROUGH);

        private final AdvancementCommandBuilder.Label grant;
        private final AdvancementCommandBuilder.Label revoke;

        private Mode(AdvancementCommandBuilder.Label grant, AdvancementCommandBuilder.Label revoke) {
            this.grant = grant;
            this.revoke = revoke;
        }

        public AdvancementCommandBuilder.Label getGrant() {
            return this.grant;
        }

        public AdvancementCommandBuilder.Label getRevoke() {
            return this.revoke;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

