/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.impl.KillCommandBuilder;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiTextFieldTooltip;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ContentButcher
extends Content {
    private GuiTextFieldTooltip radiusField;
    private String radius;
    private final KillCommandBuilder builderKill = new KillCommandBuilder();
    private final IContent.CommandPreview preview = new IContent.CommandPreview(this.builderKill, (Object)KillCommandBuilder.Label.KILL_TARGETS);

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.preview;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.radiusField = new GuiTextFieldTooltip(x + 58, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.butcher.radius"));
        this.radiusField.m_94153_(string -> {
            if (string == null) {
                return false;
            }
            if (!string.isEmpty()) {
                try {
                    Integer.parseInt(string);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        });
        this.radiusField.m_94144_(this.radius);
        this.radiusField.m_94151_(text -> {
            this.radius = text;
            if (!this.radius.isEmpty()) {
                this.builderKill.targets().setDistance(Double.valueOf(this.radius));
            } else {
                this.builderKill.targets().setDistance(0.0);
            }
            container.initButtons();
        });
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.m_142416_(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        container.m_142416_(this.radiusField);
        container.m_142416_(new GuiButtonBase(x + 58, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.butcher.configure"), () -> ActionHelper.open(Contents.BUTCHER_SETTINGS)));
        boolean enabled = this.radius != null && !this.radius.isEmpty();
        GuiButtonBase slaughter = new GuiButtonBase(x + 58, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.butcher.slaughter"), () -> {
            Collection entities = Config.getButcher().getEntities().stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getValue(arg_0)).filter((Predicate<EntityType>)Predicates.notNull()).collect(Collectors.toList());
            ContentButcher.slaughter(container.getPlayer(), entities, Integer.parseInt(this.radius));
        });
        container.m_142416_(slaughter);
        slaughter.f_93623_ = enabled && !Config.getButcher().getEntities().isEmpty();
        slaughter = new GuiButtonBase(x + 58, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.butcher.presets"), () -> ActionHelper.open(Contents.BUTCHER_PRESETS.withBuilder(this.builderKill, (Object)KillCommandBuilder.Label.KILL_TARGETS).withRadius(Double.parseDouble(this.radius))));
        container.m_142416_(slaughter);
        slaughter.f_93623_ = enabled;
    }

    public static void slaughter(String username, Collection<EntityType<?>> entities, double radius) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (player != null && level != null) {
            AABB aabb = new AABB(player.m_20183_()).m_82400_(radius);
            for (EntityType<?> entity : entities) {
                List targets = level.m_142425_(entity, aabb, (Predicate)Predicates.alwaysTrue());
                targets.removeIf(arg_0 -> ContentButcher.lambda$slaughter$6((Player)player, arg_0));
                if (targets.isEmpty()) continue;
                KillCommandBuilder kill = new KillCommandBuilder();
                kill.targets().setSelectorType("e");
                kill.targets().setType(ForgeRegistries.ENTITY_TYPES.getKey(entity));
                kill.targets().setDistanceMax(radius);
                CommandHelper.sendCommand(username, kill, (Object)KillCommandBuilder.Label.KILL_TARGETS);
            }
        }
    }

    @Override
    public void tick(Container container) {
        this.radiusField.m_94120_();
    }

    @Override
    public Category getCategory() {
        return Categories.ENTITIES;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.entities.butcher");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.entities.butcher");
    }

    @Override
    public Content getActiveContent() {
        return Contents.BUTCHER;
    }

    private static /* synthetic */ boolean lambda$slaughter$6(Player player, Entity target) {
        return player.equals((Object)target);
    }
}

