/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.argument.Coordinate;
import exopandora.worldhandler.builder.argument.tag.EntityTag;
import exopandora.worldhandler.builder.impl.FillCommandBuilder;
import exopandora.worldhandler.builder.impl.KillCommandBuilder;
import exopandora.worldhandler.builder.impl.SetBlockCommandBuilder;
import exopandora.worldhandler.builder.impl.SummonCommandBuilder;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.content.impl.ContentChild;
import exopandora.worldhandler.gui.widget.button.EnumIcon;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonIcon;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.button.GuiTextFieldTooltip;
import exopandora.worldhandler.util.ActionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class ContentCommandStack
extends ContentChild {
    private static final int HEAD_LENGTH = 1;
    private static final int TAIL_LENGTH = 2;
    private static final Component PLUS = Component.m_237113_((String)"+");
    private static final Component MINUS = Component.m_237113_((String)"-");
    private final List<GuiTextFieldTooltip> textfields = new ArrayList<GuiTextFieldTooltip>();
    private int scroll;
    private GuiButtonBase buttonCopy;
    private final SummonCommandBuilder builderCommandStack = new SummonCommandBuilder();
    private final IContent.CommandPreview preview = new IContent.CommandPreview(this.builderCommandStack, (Object)SummonCommandBuilder.Label.SUMMON_POS_NBT);
    private final EntityTag activatorRail = new EntityTag();

    public ContentCommandStack() {
        this.builderCommandStack.entity().set(EntityType.f_20450_);
        this.builderCommandStack.pos().setX(new Coordinate.Doubles(Coordinate.Type.RELATIVE));
        this.builderCommandStack.pos().setY(new Coordinate.Doubles(0.5, Coordinate.Type.RELATIVE));
        this.builderCommandStack.pos().setZ(new Coordinate.Doubles(Coordinate.Type.RELATIVE));
        this.activatorRail.setMotion(0.0, 0.315, 0.0);
        this.activatorRail.setTime(1);
        this.activatorRail.setBlockState(Blocks.f_50285_.m_49966_());
        this.builderCommandStack.nbt().addTagProvider(this.activatorRail);
        EntityTag redstoneBlock = new EntityTag(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20450_));
        redstoneBlock.setTime(1);
        redstoneBlock.setBlockState(Blocks.f_50330_.m_49966_());
        this.activatorRail.addPassenger(redstoneBlock);
        this.addCommand(0);
        EntityTag blockRemover = new EntityTag(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20471_));
        SetBlockCommandBuilder builder = new SetBlockCommandBuilder();
        builder.pos().setX(new Coordinate.Ints(Coordinate.Type.RELATIVE));
        builder.pos().setY(new Coordinate.Ints(-2, Coordinate.Type.RELATIVE));
        builder.pos().setZ(new Coordinate.Ints(Coordinate.Type.RELATIVE));
        builder.block().set(Blocks.f_50447_);
        CompoundTag commandBlock = new CompoundTag();
        commandBlock.m_128344_("auto", (byte)1);
        FillCommandBuilder fill = new FillCommandBuilder();
        fill.from().setX(new Coordinate.Ints(Coordinate.Type.RELATIVE));
        fill.from().setY(new Coordinate.Ints(Coordinate.Type.RELATIVE));
        fill.from().setZ(new Coordinate.Ints(Coordinate.Type.RELATIVE));
        fill.to().setX(new Coordinate.Ints(Coordinate.Type.RELATIVE));
        fill.to().setY(new Coordinate.Ints(2, Coordinate.Type.RELATIVE));
        fill.to().setZ(new Coordinate.Ints(Coordinate.Type.RELATIVE));
        fill.block().set(Blocks.f_50016_);
        commandBlock.m_128359_("Command", fill.toCommand((Object)FillCommandBuilder.Label.FILL, false));
        builder.block().setTag(commandBlock);
        blockRemover.setCommand(builder.toCommand((Object)SetBlockCommandBuilder.Label.DESTROY, false));
        this.activatorRail.addPassenger(blockRemover);
        EntityTag entityRemover = new EntityTag(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20471_));
        KillCommandBuilder kill = new KillCommandBuilder();
        kill.targets().setSelectorType("e");
        kill.targets().setType(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20471_));
        kill.targets().setDistanceMax(1.0);
        entityRemover.setCommand(kill.toCommand((Object)KillCommandBuilder.Label.KILL_TARGETS, false));
        this.activatorRail.addPassenger(entityRemover);
    }

    @Override
    public IContent.CommandPreview getCommandPreview() {
        return this.preview;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.textfields.clear();
        for (int index = 0; index < 3; ++index) {
            int command = index + this.scroll;
            GuiTextFieldTooltip textfield = new GuiTextFieldTooltip(x, y + 24 * index, 184, 20, (Component)Component.m_237110_((String)"gui.worldhandler.command_stack.command_n", (Object[])new Object[]{command + 1}));
            textfield.m_94153_((Predicate)Predicates.notNull());
            textfield.m_94144_(command < this.getCommandCount() ? this.getCommand(command) : null);
            textfield.m_94151_(text -> {
                this.setCommand(command, (String)text);
                this.updateCopyButton();
            });
            this.textfields.add(textfield);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.m_142416_(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        this.iterate(index -> {
            GuiButtonIcon buttonUp = new GuiButtonIcon(x + 232 - 20 - 24, y + index * 24 - 1, 20, 10, EnumIcon.ARROW_UP, (Component)Component.m_237115_((String)"gui.worldhandler.actions.move_up"), () -> {
                this.swapCommands(index + this.scroll, index + this.scroll - 1);
                container.m_7856_();
            });
            container.m_142416_(buttonUp);
            GuiButtonIcon buttonDown = new GuiButtonIcon(x + 232 - 20 - 24, y + index * 24 + 11, 20, 10, EnumIcon.ARROW_DOWN, (Component)Component.m_237115_((String)"gui.worldhandler.actions.move_down"), () -> {
                this.swapCommands(index + this.scroll, index + this.scroll + 1);
                container.m_7856_();
            });
            container.m_142416_(buttonDown);
            GuiButtonTooltip buttonRemove = new GuiButtonTooltip(x + 232 - 20, y + index * 24 - 1, 20, 10, MINUS, (Component)Component.m_237115_((String)"gui.worldhandler.command_stack.remove_command"), () -> {
                int pos = index + this.scroll;
                this.removeCommand(pos);
                if (this.scroll + 3 > this.getCommandCount()) {
                    this.scrollUp();
                }
                container.m_7856_();
            });
            container.m_142416_(buttonRemove);
            container.m_142416_(new GuiButtonTooltip(x + 232 - 20, y + index * 24 + 11, 20, 10, PLUS, (Component)Component.m_237115_((String)"gui.worldhandler.command_stack.insert_command"), () -> {
                int pos = index + this.scroll + 1;
                this.addCommand(pos);
                if (index == 2) {
                    this.scrollDown();
                }
                container.m_7856_();
            }));
            container.m_142416_(this.textfields.get((int)index));
            buttonRemove.f_93623_ = this.getCommandCount() > 1;
            buttonUp.f_93623_ = index + this.scroll > 0;
            buttonDown.f_93623_ = index + this.scroll + 1 < this.getCommandCount();
        });
        this.buttonCopy = new GuiButtonBase(x, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.command_stack.copy_command"), () -> Minecraft.m_91087_().f_91068_.m_90911_(this.builderCommandStack.toCommand((Object)SummonCommandBuilder.Label.SUMMON_POS_NBT, false)));
        container.m_142416_(this.buttonCopy);
        GuiButtonIcon buttonScrollUp = new GuiButtonIcon(x + 118, y + 72, 56, 20, EnumIcon.ARROW_UP, (Component)Component.m_237115_((String)"gui.worldhandler.actions.move_up"), () -> {
            this.scrollUp();
            container.m_7856_();
        });
        container.m_142416_(buttonScrollUp);
        GuiButtonIcon buttonScrollDown = new GuiButtonIcon(x + 118 + 60, y + 72, 54, 20, EnumIcon.ARROW_DOWN, (Component)Component.m_237115_((String)"gui.worldhandler.actions.move_down"), () -> {
            this.scrollDown();
            container.m_7856_();
        });
        container.m_142416_(buttonScrollDown);
        this.updateCopyButton();
        buttonScrollUp.f_93623_ = this.scroll > 0;
        buttonScrollDown.f_93623_ = this.scroll < this.getCommandCount() - 3;
    }

    @Override
    public void tick(Container container) {
        this.iterate(index -> this.textfields.get((int)index).m_94120_());
    }

    private void iterate(Consumer<Integer> consumer) {
        for (int x = 0; x < this.textfields.size() && x + this.scroll < this.getCommandCount(); ++x) {
            consumer.accept(x);
        }
    }

    private void scrollUp() {
        this.scroll = Math.max(0, this.scroll - (Screen.m_96638_() ? 10 : 1));
    }

    private void scrollDown() {
        this.scroll = Math.min(this.getCommandCount() - 3, this.scroll + (Screen.m_96638_() ? 10 : 1));
    }

    private void updateCopyButton() {
        boolean active = false;
        for (int x = 0; x < this.getCommandCount() && !active; ++x) {
            String command = this.getCommand(x);
            if (command == null || command.isEmpty()) continue;
            active = true;
        }
        this.buttonCopy.f_93623_ = active;
    }

    private void setCommand(int index, String command) {
        EntityTag entity = this.activatorRail.getPassenger(index + 1);
        if (entity != null) {
            entity.setCommand(command);
        }
    }

    private void addCommand(int index) {
        this.activatorRail.addPassenger(index + 1, new EntityTag(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20471_)));
    }

    private void removeCommand(int index) {
        this.activatorRail.removePassenger(index + 1);
    }

    @Nullable
    private String getCommand(int index) {
        EntityTag entity = this.activatorRail.getPassenger(index + 1);
        if (entity != null) {
            return entity.getCommand();
        }
        return null;
    }

    private int getCommandCount() {
        return this.activatorRail.getPassengerCount() - 1 - 2;
    }

    private void swapCommands(int i, int j) {
        Collections.swap(this.activatorRail.getPassengers(), i + 1, j + 1);
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.command_stack");
    }
}

