/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.impl.TeamCommandBuilder;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.content.impl.ContentScoreboard;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.widget.menu.impl.ILogicButtonList;
import exopandora.worldhandler.gui.widget.menu.impl.MenuButtonList;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ContentScoreboardTeams
extends ContentScoreboard {
    private final TeamCommandBuilder builderTeams = new TeamCommandBuilder();
    private final IContent.CommandPreview previewAdd = new IContent.CommandPreview(this.builderTeams, (Object)TeamCommandBuilder.Label.ADD_DISPLAYNAME);
    private final IContent.CommandPreview previewJoinOrLeave = new IContent.CommandPreview().add(this.builderTeams, (Object)TeamCommandBuilder.Label.JOIN).add(this.builderTeams, (Object)TeamCommandBuilder.Label.LEAVE);
    private final IContent.CommandPreview previewRemoveOrEmpty = new IContent.CommandPreview().add(this.builderTeams, (Object)TeamCommandBuilder.Label.REMOVE).add(this.builderTeams, (Object)TeamCommandBuilder.Label.EMPTY);
    private final IContent.CommandPreview previewModify = new IContent.CommandPreview(this.builderTeams, (Object)TeamCommandBuilder.Label.MODIFY);
    private GuiTextFieldTooltip teamField;
    private Page page = Page.ADD;

    @Override
    public IContent.CommandPreview getCommandPreview() {
        switch (this.page) {
            case ADD: {
                return this.previewAdd;
            }
            case JOIN_OR_LEAVE: {
                return this.previewJoinOrLeave;
            }
            case REMOVE_OR_EMPTY: {
                return this.previewRemoveOrEmpty;
            }
            case OPTION: {
                return this.previewModify;
            }
        }
        return null;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.teamField = new GuiTextFieldTooltip(x + 118, y + this.page.getShift(), 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.scoreboard.team.team"));
        this.teamField.m_94153_((Predicate)Predicates.notNull());
        this.teamField.m_94144_(this.builderTeams.team().get());
        this.teamField.m_94151_(text -> {
            this.builderTeams.team().set((String)text);
            this.builderTeams.displayName().deserialize((String)text);
            container.initButtons();
        });
        if (Page.OPTION.equals((Object)this.page)) {
            MenuButtonList options = new MenuButtonList(x + 118, y + 24, HELPER.getOptions(), 2, new ILogicButtonList(){

                @Override
                public MutableComponent translate(String key, int depth) {
                    if (depth == 0) {
                        return Component.m_237115_((String)("gui.worldhandler.scoreboard.team.options." + key));
                    }
                    if (depth == 1) {
                        if (Arrays.stream(ChatFormatting.values()).map(ChatFormatting::m_126666_).anyMatch((Predicate<String>)Predicates.equalTo((Object)key))) {
                            return Component.m_237115_((String)("gui.worldhandler.color." + key));
                        }
                        return Component.m_237115_((String)("gui.worldhandler.scoreboard.team.suboption." + key));
                    }
                    return Component.m_237113_((String)key);
                }

                @Override
                public String buildEventKey(List<String> keys, int depth) {
                    return ILogicButtonList.super.buildTranslationKey(keys, depth);
                }

                @Override
                public void onClick(String key, int depth) {
                    if (depth == 0) {
                        ContentScoreboardTeams.this.builderTeams.option().set(key);
                    } else if (depth == 1) {
                        ContentScoreboardTeams.this.builderTeams.value().set(key);
                    }
                }

                @Override
                public String getId() {
                    return "options";
                }
            });
            container.addMenu(options);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        boolean enabled;
        container.m_142416_(new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.scoreboard.team.create"), () -> {
            this.page = Page.ADD;
            container.m_7856_();
        });
        container.m_142416_(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, (Component)Component.m_237113_((String)(I18n.m_118938_((String)"gui.worldhandler.scoreboard.team.join", (Object[])new Object[0]) + " / " + I18n.m_118938_((String)"gui.worldhandler.scoreboard.team.leave", (Object[])new Object[0]))), () -> {
            this.page = Page.JOIN_OR_LEAVE;
            container.m_7856_();
        });
        container.m_142416_(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, (Component)Component.m_237113_((String)(I18n.m_118938_((String)"gui.worldhandler.scoreboard.team.remove", (Object[])new Object[0]) + " / " + I18n.m_118938_((String)"gui.worldhandler.scoreboard.team.empty", (Object[])new Object[0]))), () -> {
            this.page = Page.REMOVE_OR_EMPTY;
            container.m_7856_();
        });
        container.m_142416_(button3);
        GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.scoreboard.team.options"), () -> {
            this.page = Page.OPTION;
            container.m_7856_();
        });
        container.m_142416_(button4);
        button1.f_93623_ = !Page.ADD.equals((Object)this.page);
        button2.f_93623_ = !Page.JOIN_OR_LEAVE.equals((Object)this.page);
        button3.f_93623_ = !Page.REMOVE_OR_EMPTY.equals((Object)this.page);
        button4.f_93623_ = !Page.OPTION.equals((Object)this.page);
        boolean bl = enabled = this.builderTeams.team().get() != null && !this.builderTeams.team().get().isEmpty();
        if (Page.JOIN_OR_LEAVE.equals((Object)this.page)) {
            button1 = new GuiButtonBase(x + 118, y + 36, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.scoreboard.team.join"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderTeams, (Object)TeamCommandBuilder.Label.JOIN);
                container.initButtons();
            });
            container.m_142416_(button1);
            container.m_142416_(new GuiButtonBase(x + 118, y + 60, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.scoreboard.team.leave"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderTeams, (Object)TeamCommandBuilder.Label.LEAVE);
                container.initButtons();
            }));
            button1.f_93623_ = enabled;
        } else if (Page.REMOVE_OR_EMPTY.equals((Object)this.page)) {
            button1 = new GuiButtonBase(x + 118, y + 36, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.scoreboard.team.remove"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderTeams, (Object)TeamCommandBuilder.Label.REMOVE);
                container.initButtons();
            });
            container.m_142416_(button1);
            button2 = new GuiButtonBase(x + 118, y + 60, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.scoreboard.team.empty"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderTeams, (Object)TeamCommandBuilder.Label.EMPTY);
                container.initButtons();
            });
            container.m_142416_(button2);
            button1.f_93623_ = enabled;
            button2.f_93623_ = enabled;
        }
        if (Page.ADD.equals((Object)this.page) || Page.OPTION.equals((Object)this.page)) {
            button1 = new GuiButtonBase(x + 118, y + 72 - this.page.getShift(), 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.actions.perform"), () -> {
                if (Page.ADD.equals((Object)this.page)) {
                    CommandHelper.sendCommand(container.getPlayer(), this.builderTeams, (Object)TeamCommandBuilder.Label.ADD_DISPLAYNAME);
                } else if (Page.OPTION.equals((Object)this.page)) {
                    CommandHelper.sendCommand(container.getPlayer(), this.builderTeams, (Object)TeamCommandBuilder.Label.MODIFY);
                }
                container.initButtons();
            });
            container.m_142416_(button1);
            button1.f_93623_ = enabled;
        }
        container.m_142416_(this.teamField);
    }

    @Override
    public void tick(Container container) {
        this.teamField.m_94120_();
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.scoreboard.teams");
    }

    @Override
    public Content getActiveContent() {
        return Contents.SCOREBOARD_TEAMS;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        if (Page.JOIN_OR_LEAVE.equals((Object)this.page)) {
            this.builderTeams.members().setTarget(username);
        }
    }

    public static enum Page {
        ADD(24),
        JOIN_OR_LEAVE(12),
        REMOVE_OR_EMPTY(12),
        OPTION(0);

        private final int shift;

        private Page(int shift) {
            this.shift = shift;
        }

        public int getShift() {
            return this.shift;
        }
    }
}

