/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.util.ActionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class GuiButtonPiano
extends GuiButtonBase {
    private static final ResourceLocation NOTE = new ResourceLocation("worldhandler", "textures/misc/note.png");
    private final Type type;
    private final SoundEvent sound;
    private final float pitch;

    public GuiButtonPiano(int x, int y, int width, int height, Component buttonText, SoundEvent sound, float pitch, Type type, ActionHandler actionHandler) {
        super(x, y, width, height, buttonText, actionHandler);
        this.sound = sound;
        this.pitch = pitch;
        this.type = type;
    }

    @Override
    public void m_87963_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        switch (this.type) {
            case LEFT: {
                this.f_93622_ = this.isHoveringLeft(mouseX, mouseY);
                break;
            }
            case NORMAL: {
                this.f_93622_ = this.isHoveringNormal(mouseX, mouseY);
                break;
            }
            case RIGHT: {
                this.f_93622_ = this.isHoveringRight(mouseX, mouseY);
                break;
            }
            case BLACK: {
                this.f_93622_ = this.isHoveringBlack(mouseX, mouseY);
                break;
            }
        }
        int hovered = this.m_274533_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)Config.getSkin().getButtonAlpha());
        RenderSystem.m_157456_((int)0, (ResourceLocation)NOTE);
        switch (this.type) {
            case LEFT: 
            case NORMAL: 
            case RIGHT: {
                this.drawWhiteKey(poseStack, hovered);
                break;
            }
            case BLACK: {
                this.drawBlackKey(poseStack, hovered);
                break;
            }
        }
    }

    protected void drawWhiteKey(PoseStack poseStack, int hoverstate) {
        int textColor = this.getFGColor();
        Font font = Minecraft.m_91087_().f_91062_;
        GuiComponent.m_93228_((PoseStack)poseStack, (int)this.m_252754_(), (int)this.m_252907_(), (int)(25 + hoverstate * 15 - 15), (int)0, (int)15, (int)92);
        font.m_92889_(poseStack, this.m_6035_(), (float)(this.m_252754_() + this.f_93618_ / 2 - font.m_92852_((FormattedText)this.m_6035_()) / 2), (float)(this.m_252907_() + (this.f_93619_ - 8) / 2 + 36), textColor);
    }

    protected void drawBlackKey(PoseStack poseStack, int hoverstate) {
        GuiComponent.m_93228_((PoseStack)poseStack, (int)this.m_252754_(), (int)this.m_252907_(), (int)(55 - hoverstate * 9 + 18), (int)0, (int)9, (int)58);
    }

    public int getFGColor() {
        int textColor = 0;
        if (!this.f_93623_) {
            textColor = 0xA0A0A0;
        } else if (this.m_198029_()) {
            textColor = 0x8B8B8B;
        }
        return textColor;
    }

    public void m_7435_(SoundManager soundManager) {
        if (this.sound != null) {
            soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.sound, (float)this.pitch));
        }
    }

    private boolean isHoveringBlack(double mouseX, double mouseY) {
        return mouseX >= (double)this.m_252754_() && mouseY >= (double)this.m_252907_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    private boolean isHoveringLeft(double mouseX, double mouseY) {
        return mouseX >= (double)this.m_252754_() && mouseY >= (double)this.m_252907_() && mouseX < (double)(this.m_252754_() + 10) && mouseY < (double)(this.m_252907_() + 60) || mouseX >= (double)this.m_252754_() && mouseY >= (double)(this.m_252907_() + 58) && mouseX < (double)(this.m_252754_() + 14) && mouseY < (double)(this.m_252907_() + 93);
    }

    private boolean isHoveringNormal(double mouseX, double mouseY) {
        return mouseX >= (double)(this.m_252754_() + 4) && mouseY >= (double)this.m_252907_() && mouseX < (double)(this.m_252754_() + 10) && mouseY < (double)(this.m_252907_() + 60) || mouseX >= (double)this.m_252754_() && mouseY >= (double)(this.m_252907_() + 58) && mouseX < (double)(this.m_252754_() + 14) && mouseY < (double)(this.m_252907_() + 93);
    }

    private boolean isHoveringRight(double mouseX, double mouseY) {
        return mouseX >= (double)(this.m_252754_() + 4) && mouseY >= (double)this.m_252907_() && mouseX < (double)(this.m_252754_() + 14) && mouseY < (double)(this.m_252907_() + 60) || mouseX >= (double)this.m_252754_() && mouseY >= (double)(this.m_252907_() + 58) && mouseX < (double)(this.m_252754_() + 14) && mouseY < (double)(this.m_252907_() + 93);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        switch (this.type) {
            case LEFT: {
                return this.f_93623_ && this.f_93624_ && this.isHoveringLeft(mouseX, mouseY);
            }
            case NORMAL: {
                return this.f_93623_ && this.f_93624_ && this.isHoveringNormal(mouseX, mouseY);
            }
            case RIGHT: {
                return this.f_93623_ && this.f_93624_ && this.isHoveringRight(mouseX, mouseY);
            }
            case BLACK: {
                return this.f_93623_ && this.f_93624_ && this.isHoveringBlack(mouseX, mouseY);
            }
        }
        return false;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.m_5953_(mouseX, mouseY);
    }

    public static enum Type {
        LEFT,
        NORMAL,
        RIGHT,
        BLACK;

    }
}

