/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.util.ResourceHelper;
import exopandora.worldhandler.util.TextUtils;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;

public class RenderUtils {
    public static final double EPS = (double)0.002f;

    public static void drawWatchIntoGui(PoseStack matrix, GuiComponent gui, int width, int height, long worldTicks, boolean smooth) {
        float hour = TextUtils.toHour(worldTicks);
        float minute = TextUtils.toMinute(worldTicks);
        if (smooth) {
            hour = (float)(worldTicks + 6000L) / 1000.0f;
            minute = (float)(((double)((float)worldTicks + 6000.0f) - Math.floor(hour) * 1000.0) * 6.0 / 100.0);
        }
        float rotationHour = 30.0f * (hour >= 12.0f ? hour - 12.0f : hour) - 180.0f;
        float rotationMinute = 6.0f * minute - 180.0f;
        matrix.m_85836_();
        matrix.m_252880_((float)(width + 5), (float)(height + 5), 0.0f);
        matrix.m_85841_(0.25f, 0.25f, 0.25f);
        matrix.m_252781_(Axis.f_252403_.m_252977_(rotationHour));
        GuiComponent.m_93172_((PoseStack)matrix, (int)-1, (int)-1, (int)1, (int)11, (int)-13092808);
        matrix.m_252781_(Axis.f_252393_.m_252977_(rotationHour));
        matrix.m_252781_(Axis.f_252403_.m_252977_(rotationMinute));
        GuiComponent.m_93172_((PoseStack)matrix, (int)-1, (int)-1, (int)1, (int)15, (int)-9474193);
        matrix.m_252781_(Axis.f_252393_.m_252977_(rotationMinute));
        matrix.m_85849_();
        RenderUtils.colorDefaultButton();
        RenderSystem.m_157456_((int)0, (ResourceLocation)ResourceHelper.iconTexture());
        GuiComponent.m_93228_((PoseStack)matrix, (int)(width + 0), (int)height, (int)48, (int)0, (int)10, (int)10);
        matrix.m_85836_();
        matrix.m_85841_(0.5f, 0.5f, 0.5f);
        GuiComponent.m_93172_((PoseStack)matrix, (int)((width + 5) * 2 - 1), (int)((height + 4) * 2 + 1), (int)((width + 6) * 2 - 1), (int)((height + 5) * 2 + 1), (int)-16777216);
        matrix.m_85849_();
    }

    public static void colorDefaultButton() {
        float r = Config.getSkin().getButtonRed();
        float g = Config.getSkin().getButtonGreen();
        float b = Config.getSkin().getButtonBlue();
        float a = Config.getSkin().getButtonAlpha();
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
    }

    public static void colorDefaultBackground() {
        RenderUtils.colorDefaultBackground(1.0);
    }

    public static void colorDefaultBackground(double alpha) {
        float r = Config.getSkin().getBackgroundRed();
        float g = Config.getSkin().getBackgroundGreen();
        float b = Config.getSkin().getBackgroundBlue();
        float a = (float)alpha * Config.getSkin().getBackgroundAlpha();
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
    }

    public static void colorDarkBackground() {
        float r = Config.getSkin().getBackgroundRed();
        float g = Config.getSkin().getBackgroundGreen();
        float b = Config.getSkin().getBackgroundBlue();
        float a = Config.getSkin().getBackgroundAlpha();
        RenderSystem.m_157429_((float)Math.max(0.0f, r - 0.3f), (float)Math.max(0.0f, g - 0.3f), (float)Math.max(0.0f, b - 0.3f), (float)a);
    }

    public static void drawTexturedTriangleBL(PoseStack matrix, GuiComponent gui, int x, int y, int textureX, int textureY, int size) {
        for (int i = 0; i < size; ++i) {
            GuiComponent.m_93228_((PoseStack)matrix, (int)x, (int)(y + i), (int)textureX, (int)(textureY + i), (int)(i + 1), (int)1);
        }
    }

    public static void drawTexturedTriangleBR(PoseStack matrix, GuiComponent gui, int x, int y, int textureX, int textureY, int size) {
        for (int i = 0; i < size; ++i) {
            GuiComponent.m_93228_((PoseStack)matrix, (int)(x + size - i - 1), (int)(y + i), (int)(textureX + size - i - 1), (int)(textureY + i), (int)(i + 1), (int)1);
        }
    }

    public static void drawTexturedTriangleTL(PoseStack matrix, GuiComponent gui, int x, int y, int textureX, int textureY, int size) {
        for (int i = 0; i < size; ++i) {
            GuiComponent.m_93228_((PoseStack)matrix, (int)x, (int)(y + i), (int)textureX, (int)textureY, (int)(size - i), (int)1);
        }
    }

    public static void drawTexturedTriangleTR(PoseStack matrix, GuiComponent gui, int x, int y, int textureX, int textureY, int size) {
        for (int i = 0; i < size; ++i) {
            GuiComponent.m_93228_((PoseStack)matrix, (int)(x + i), (int)(y + i), (int)(textureX + i), (int)textureY, (int)(size - i), (int)1);
        }
    }

    public static void drawTexturedWedgeGradientTR(PoseStack matrix, GuiComponent gui, int x, int y, int textureX, int textureY, int width, int height) {
        RenderSystem.m_69478_();
        for (int i = 0; i < height; ++i) {
            double w = (double)(height - i) / (double)(height + 1);
            int z = width - (int)(w * (double)width);
            RenderUtils.colorDefaultBackground(w);
            GuiComponent.m_93228_((PoseStack)matrix, (int)(x + z), (int)(y + i), (int)(textureX + z), (int)(textureY + i), (int)(width - z), (int)1);
        }
        RenderSystem.m_69461_();
    }

    public static void drawTexturedWedgeGradientTL(PoseStack matrix, GuiComponent gui, int x, int y, int textureX, int textureY, int width, int height) {
        RenderSystem.m_69478_();
        for (int i = 0; i < height; ++i) {
            double w = (double)(height - i) / (double)(height + 1);
            int z = (int)(w * (double)width);
            RenderUtils.colorDefaultBackground(w);
            GuiComponent.m_93228_((PoseStack)matrix, (int)x, (int)(y + i), (int)textureX, (int)(textureY + i), (int)z, (int)1);
        }
        RenderSystem.m_69461_();
    }
}

