/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.container.impl;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.event.KeyHandler;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.widget.IContainerWidget;
import exopandora.worldhandler.gui.widget.WidgetCommandSyntax;
import exopandora.worldhandler.gui.widget.WidgetNameField;
import exopandora.worldhandler.gui.widget.WidgetShortcuts;
import exopandora.worldhandler.gui.widget.WidgetTabRenderer;
import exopandora.worldhandler.gui.widget.WidgetWatch;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.menu.IMenu;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.RenderUtils;
import exopandora.worldhandler.util.ResourceHelper;
import exopandora.worldhandler.util.TextUtils;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;

public class GuiWorldHandler
extends Container {
    private static String player = Minecraft.m_91087_().m_91094_().m_92546_();
    private static final List<IContainerWidget> WIDGETS = (List)Util.m_137469_((Object)Lists.newArrayList(), widgets -> {
        widgets.add(new WidgetTabRenderer());
        widgets.add(new WidgetWatch());
        widgets.add(new WidgetNameField());
        widgets.add(new WidgetCommandSyntax());
        widgets.add(new WidgetShortcuts());
    });
    private final Content content;

    public GuiWorldHandler(Content content) throws Exception {
        super((Component)content.getTitle());
        this.content = content;
        this.content.init(this);
    }

    @Override
    public void m_7856_() {
        ActionHelper.tryRun(() -> {
            this.menus.clear();
            this.m_169413_();
            int x = this.getContentX();
            int y = this.getContentY();
            this.content.onPlayerNameChanged(this.getPlayer());
            this.content.initGui(this, x, y);
            for (IMenu menu : this.menus) {
                menu.initGui(this);
            }
            for (IContainerWidget widget : WIDGETS) {
                if (!widget.isEnabled()) continue;
                widget.initGui(this, x, y);
            }
            this.initButtons();
        });
    }

    @Override
    public void initButtons() {
        ActionHelper.tryRun(() -> {
            this.m_169413_();
            this.content.initButtons(this, this.getContentX(), this.getContentY());
            int x = this.getContentX();
            int y = this.getContentY();
            for (IContainerWidget widget : WIDGETS) {
                if (!widget.isEnabled()) continue;
                widget.initButtons(this, x, y);
            }
            for (IMenu menu : this.menus) {
                menu.initButtons(this);
            }
        });
    }

    public void m_86600_() {
        ActionHelper.tryRun(() -> {
            this.content.tick(this);
            for (IMenu menu : this.menus) {
                menu.tick();
            }
            for (IContainerWidget widget : WIDGETS) {
                if (!widget.isEnabled()) continue;
                widget.tick(this);
            }
        });
    }

    @Override
    public int getBackgroundX() {
        return (this.f_96543_ - this.getBackgroundWidth()) / 2;
    }

    @Override
    public int getBackgroundY() {
        return (this.f_96544_ - this.getBackgroundHeight()) / 2 + 10;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        ActionHelper.tryRun(() -> {
            int backgroundX = this.getBackgroundX();
            int backgroundY = this.getBackgroundY();
            if (Config.getSkin().drawBackground()) {
                super.m_280273_(guiGraphics);
            }
            RenderSystem.enableBlend();
            RenderUtils.colorDefaultBackground();
            guiGraphics.m_280218_(ResourceHelper.backgroundTexture(), backgroundX, backgroundY, 0, 0, this.getBackgroundWidth(), this.getBackgroundHeight());
            String label = "1.20.1-3.4.4";
            int versionWidth = this.f_96543_ - this.f_96547_.m_92895_("1.20.1-3.4.4") - 2;
            int versionHeight = this.f_96544_ - 10;
            guiGraphics.m_280056_(this.f_96547_, "1.20.1-3.4.4", versionWidth, versionHeight, Config.getSkin().getLabelColor() + 0x33000000, false);
            int x = this.getContentX();
            int y = this.getContentY();
            for (IContainerWidget iContainerWidget : WIDGETS) {
                if (!iContainerWidget.isEnabled() || IContainerWidget.EnumLayer.BACKGROUND != iContainerWidget.getLayer()) continue;
                iContainerWidget.drawScreen(guiGraphics, this, x, y, mouseX, mouseY, partialTicks);
            }
            int maxWidth = this.getBackgroundWidth() - 18 - this.f_96547_.m_92895_(this.getPlayer()) - (Config.getSettings().watch() ? 9 : 0);
            guiGraphics.m_280614_(this.f_96547_, (Component)TextUtils.stripText(this.content.getTitle(), maxWidth, this.f_96547_), backgroundX + 7, backgroundY + 7, Config.getSkin().getLabelColor(), false);
            for (Renderable renderable : this.f_169369_) {
                renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            }
            this.content.drawScreen(guiGraphics, this, x, y, mouseX, mouseY, partialTicks);
            for (IMenu menu : this.menus) {
                menu.draw(guiGraphics, mouseX, mouseY, partialTicks);
            }
            for (IContainerWidget widget : WIDGETS) {
                if (!widget.isEnabled() || IContainerWidget.EnumLayer.FOREGROUND != widget.getLayer()) continue;
                widget.drawScreen(guiGraphics, this, x, y, mouseX, mouseY, partialTicks);
            }
            if (Config.getSettings().tooltips()) {
                for (Renderable renderable : this.f_169369_) {
                    if (!(renderable instanceof GuiButtonTooltip)) continue;
                    ((GuiButtonTooltip)renderable).renderTooltip(guiGraphics, this.f_96547_, mouseX, mouseY);
                }
            }
            if (mouseX >= versionWidth && mouseY >= versionHeight) {
                PoseStack poseStack = guiGraphics.m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_((float)(versionWidth - 12), (float)(versionHeight + 12), 0.0f);
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"1.20.1-3.4.4"), 0, 0);
                poseStack.m_85849_();
            }
            RenderSystem.disableBlend();
        });
    }

    public void m_94757_(double xPos, double mouseY) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled()) continue;
            widget.m_94757_(xPos, mouseY);
        }
        this.content.m_94757_(xPos, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int keyCode) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.m_6375_(mouseX, mouseY, keyCode)) continue;
            return true;
        }
        if (this.content.m_6375_(mouseX, mouseY, keyCode)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, keyCode);
    }

    public boolean m_6348_(double mouseX, double mouseY, int keyCode) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.m_6348_(mouseX, mouseY, keyCode)) continue;
            return true;
        }
        if (this.content.m_6348_(mouseX, mouseY, keyCode)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, keyCode);
    }

    public boolean m_7979_(double mouseX, double mouseY, int keyCode, double deltaX, double deltaY) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.m_7979_(mouseX, mouseY, keyCode, deltaX, deltaY)) continue;
            return true;
        }
        if (this.content.m_7979_(mouseX, mouseY, keyCode, deltaX, deltaY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, keyCode, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double distance) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.m_6050_(mouseX, mouseY, distance)) continue;
            return true;
        }
        if (this.content.m_6050_(mouseX, mouseY, distance)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, distance);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!(this.m_7222_() instanceof AbstractWidget) && KeyHandler.KEY_WORLD_HANDLER.m_90832_(keyCode, scanCode) && KeyHandler.KEY_WORLD_HANDLER.getKeyModifier().isActive(null)) {
            Minecraft.m_91087_().m_91152_(null);
            return true;
        }
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (this.content.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.m_7920_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (this.content.m_7920_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char charTyped, int keyCode) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.m_5534_(charTyped, keyCode)) continue;
            return true;
        }
        if (this.content.m_5534_(charTyped, keyCode)) {
            return true;
        }
        return super.m_5534_(charTyped, keyCode);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.m_5953_(mouseX, mouseY)) continue;
            return true;
        }
        if (this.content.m_5953_(mouseX, mouseY)) {
            return true;
        }
        return super.m_5953_(mouseX, mouseY);
    }

    private int getContentX() {
        return this.getBackgroundX() + 8;
    }

    private int getContentY() {
        return this.getBackgroundY() + 33;
    }

    public void m_7379_() {
        ActionHelper.tryRun(this.content::onGuiClosed);
        super.m_7379_();
    }

    public boolean m_7043_() {
        return Config.getSettings().pause();
    }

    @Override
    public String getPlayer() {
        return player;
    }

    @Override
    public void setPlayer(String player) {
        GuiWorldHandler.player = player;
    }

    @Override
    public Content getContent() {
        return this.content;
    }

    @Override
    public int getBackgroundWidth() {
        return 248;
    }

    @Override
    public int getBackgroundHeight() {
        return 166;
    }
}

