/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.impl.BanCommandBuilder;
import exopandora.worldhandler.builder.impl.DeOpCommandBuilder;
import exopandora.worldhandler.builder.impl.KickCommandBuilder;
import exopandora.worldhandler.builder.impl.OpCommandBuilder;
import exopandora.worldhandler.builder.impl.PardonCommandBuilder;
import exopandora.worldhandler.builder.impl.SaveAllCommandBuilder;
import exopandora.worldhandler.builder.impl.SaveOffCommandBuilder;
import exopandora.worldhandler.builder.impl.SaveOnCommandBuilder;
import exopandora.worldhandler.builder.impl.StopCommandBuilder;
import exopandora.worldhandler.builder.impl.WhitelistCommandBuilder;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.widget.button.EnumIcon;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonIcon;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.button.GuiHintTextField;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ContentMultiplayer
extends Content {
    private GuiHintTextField playerField;
    private GuiHintTextField reasonField;
    private Page page = Page.KICK_AND_BAN;
    private final KickCommandBuilder builderKick = new KickCommandBuilder();
    private final BanCommandBuilder builderBan = new BanCommandBuilder();
    private final PardonCommandBuilder builderPardon = new PardonCommandBuilder();
    private final OpCommandBuilder builderOp = new OpCommandBuilder();
    private final DeOpCommandBuilder builderDeop = new DeOpCommandBuilder();
    private final SaveAllCommandBuilder builderSaveAll = new SaveAllCommandBuilder();
    private final SaveOnCommandBuilder builderSaveOn = new SaveOnCommandBuilder();
    private final SaveOffCommandBuilder builderSaveOff = new SaveOffCommandBuilder();
    private final StopCommandBuilder builderStop = new StopCommandBuilder();
    private final WhitelistCommandBuilder builderWhitelist = new WhitelistCommandBuilder();
    private final IContent.CommandPreview previewKickBan = new IContent.CommandPreview().add(this.builderKick, (Object)KickCommandBuilder.Label.KICK).add(this.builderBan, (Object)BanCommandBuilder.Label.BAN);
    private final IContent.CommandPreview previewPardon = new IContent.CommandPreview(this.builderPardon, (Object)PardonCommandBuilder.Label.PARDON);
    private final IContent.CommandPreview previewPermissions = new IContent.CommandPreview().add(this.builderOp, (Object)OpCommandBuilder.Label.OP).add(this.builderDeop, (Object)DeOpCommandBuilder.Label.DEOP);
    private final IContent.CommandPreview previewRuntime = new IContent.CommandPreview().add(this.builderSaveAll, (Object)SaveAllCommandBuilder.Label.SAVE_ALL).add(this.builderSaveOn, (Object)SaveOnCommandBuilder.Label.SAVE_ON).add(this.builderSaveOff, (Object)SaveOffCommandBuilder.Label.SAVE_OFF).add(this.builderStop, (Object)StopCommandBuilder.Label.STOP);
    private final IContent.CommandPreview previewWhitelist = new IContent.CommandPreview(this.builderWhitelist, null);

    @Override
    public IContent.CommandPreview getCommandPreview() {
        if (Page.KICK_AND_BAN.equals((Object)this.page)) {
            return this.previewKickBan;
        }
        if (Page.PARDON.equals((Object)this.page)) {
            return this.previewPardon;
        }
        if (Page.PERMISSIONS.equals((Object)this.page)) {
            return this.previewPermissions;
        }
        if (Page.RUNTIME.equals((Object)this.page)) {
            return this.previewRuntime;
        }
        if (Page.WHITELIST.equals((Object)this.page)) {
            return this.previewWhitelist;
        }
        return null;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.playerField = new GuiHintTextField(x + 118, y + this.page.getShift(), 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.username"));
        this.playerField.m_94153_((Predicate)Predicates.notNull());
        this.playerField.m_93692_(false);
        this.playerField.m_94144_(this.builderKick.targets().getTarget());
        this.playerField.m_94199_(16);
        this.playerField.m_94151_(text -> {
            this.setPlayer(this.playerField.m_94155_());
            container.initButtons();
        });
        this.reasonField = new GuiHintTextField(x + 118, y + 24 + this.page.getShift(), 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.kick_ban.reason"));
        this.reasonField.m_94153_((Predicate)Predicates.notNull());
        this.reasonField.m_93692_(false);
        this.reasonField.m_94144_(this.builderKick.reason().get());
        this.reasonField.m_94151_(text -> {
            this.setReason(this.reasonField.m_94155_());
            container.initButtons();
        });
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.m_142416_(new GuiButtonBase(x + 118, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, (Component)Component.m_237113_((String)(I18n.m_118938_((String)"gui.worldhandler.multiplayer.kick", (Object[])new Object[0]) + " / " + I18n.m_118938_((String)"gui.worldhandler.multiplayer.ban", (Object[])new Object[0]))), () -> {
            this.page = Page.KICK_AND_BAN;
            container.m_7856_();
        });
        container.m_142416_(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.pardon"), () -> {
            this.page = Page.PARDON;
            container.m_7856_();
        });
        container.m_142416_(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.permissions"), () -> {
            this.page = Page.PERMISSIONS;
            container.m_7856_();
        });
        container.m_142416_(button3);
        GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.runtime"), () -> {
            this.page = Page.RUNTIME;
            container.m_7856_();
        });
        container.m_142416_(button4);
        GuiButtonBase button5 = new GuiButtonBase(x, y + 96, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.whitelist"), () -> {
            this.page = Page.WHITELIST;
            container.m_7856_();
        });
        container.m_142416_(button5);
        if (Page.KICK_AND_BAN.equals((Object)this.page)) {
            container.m_142416_(this.playerField);
            container.m_142416_(this.reasonField);
            GuiButtonTooltip button6 = new GuiButtonTooltip(x + 118, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.kick"), (Component)Component.m_237113_((String)this.builderKick.toCommand((Object)KickCommandBuilder.Label.KICK_REASON, false)), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderKick, (Object)KickCommandBuilder.Label.KICK_REASON));
            container.m_142416_(button6);
            GuiButtonTooltip button7 = new GuiButtonTooltip(x + 118, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.ban"), (Component)Component.m_237113_((String)this.builderBan.toCommand((Object)BanCommandBuilder.Label.BAN_REASON, false)), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderBan, (Object)BanCommandBuilder.Label.BAN_REASON));
            container.m_142416_(button7);
            if (this.playerField.m_94155_().isEmpty()) {
                button6.f_93623_ = false;
                button7.f_93623_ = false;
            }
            button1.f_93623_ = false;
        } else if (Page.PARDON.equals((Object)this.page)) {
            container.m_142416_(this.playerField);
            GuiButtonTooltip button6 = new GuiButtonTooltip(x + 118, y + 48, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.pardon"), (Component)Component.m_237113_((String)this.builderPardon.toCommand((Object)PardonCommandBuilder.Label.PARDON, false)), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderPardon, (Object)PardonCommandBuilder.Label.PARDON));
            container.m_142416_(button6);
            if (this.playerField.m_94155_().isEmpty()) {
                button6.f_93623_ = false;
            }
            button2.f_93623_ = false;
        } else if (Page.PERMISSIONS.equals((Object)this.page)) {
            container.m_142416_(this.playerField);
            GuiButtonTooltip button6 = new GuiButtonTooltip(x + 118, y + 24 + 12, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.permissions.give"), (Component)Component.m_237113_((String)this.builderOp.toCommand((Object)OpCommandBuilder.Label.OP, false)), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderOp, (Object)OpCommandBuilder.Label.OP));
            container.m_142416_(button6);
            GuiButtonTooltip button7 = new GuiButtonTooltip(x + 118, y + 48 + 12, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.permissions.take"), (Component)Component.m_237113_((String)this.builderDeop.toCommand((Object)DeOpCommandBuilder.Label.DEOP, false)), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderDeop, (Object)DeOpCommandBuilder.Label.DEOP));
            container.m_142416_(button7);
            if (this.playerField.m_94155_().isEmpty()) {
                button6.f_93623_ = false;
                button7.f_93623_ = false;
            }
            button3.f_93623_ = false;
        } else if (Page.RUNTIME.equals((Object)this.page)) {
            container.m_142416_(new GuiButtonTooltip(x + 118, y, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.runtime.save_world"), (Component)Component.m_237113_((String)this.builderSaveAll.toCommand((Object)SaveAllCommandBuilder.Label.SAVE_ALL, false)), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderSaveAll, (Object)SaveAllCommandBuilder.Label.SAVE_ALL)));
            container.m_142416_(new GuiButtonTooltip(x + 118, y + 24, 114, 20, (Component)Component.m_237110_((String)"gui.worldhandler.multiplayer.runtime.autosave", (Object[])new Object[]{Component.m_237115_((String)"gui.worldhandler.generic.on")}), (Component)Component.m_237113_((String)this.builderSaveOn.toCommand((Object)SaveOnCommandBuilder.Label.SAVE_ON, false)), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderSaveOn, (Object)SaveOnCommandBuilder.Label.SAVE_ON)));
            container.m_142416_(new GuiButtonTooltip(x + 118, y + 48, 114, 20, (Component)Component.m_237110_((String)"gui.worldhandler.multiplayer.runtime.autosave", (Object[])new Object[]{Component.m_237115_((String)"gui.worldhandler.generic.off")}).m_130940_(ChatFormatting.RED), (Component)Component.m_237113_((String)this.builderSaveOff.toCommand((Object)SaveOffCommandBuilder.Label.SAVE_OFF, false)), () -> ActionHelper.open(Contents.CONTINUE.withBuilder(this.builderSaveOff, (Object)SaveOffCommandBuilder.Label.SAVE_OFF))));
            container.m_142416_(new GuiButtonTooltip(x + 118, y + 72, 114, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.runtime.stop_server").m_130940_(ChatFormatting.RED), (Component)Component.m_237113_((String)this.builderStop.toCommand((Object)StopCommandBuilder.Label.STOP, false)), () -> ActionHelper.open(Contents.CONTINUE.withBuilder(this.builderStop, (Object)StopCommandBuilder.Label.STOP))));
            button4.f_93623_ = false;
        } else if (Page.WHITELIST.equals((Object)this.page)) {
            container.m_142416_(this.playerField);
            GuiButtonBase button6 = new GuiButtonBase(x + 118, y + 24, 44, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.whitelist.add"), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderWhitelist, (Object)WhitelistCommandBuilder.Label.ADD));
            container.m_142416_(button6);
            GuiButtonBase button7 = new GuiButtonBase(x + 118 + 47, y + 24, 44, 20, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.whitelist.remove"), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderWhitelist, (Object)WhitelistCommandBuilder.Label.REMOVE));
            container.m_142416_(button7);
            container.m_142416_(new GuiButtonBase(x + 118, y + 48, 114, 20, (Component)Component.m_237110_((String)"gui.worldhandler.multiplayer.whitelist.whitelist", (Object[])new Object[]{Component.m_237115_((String)"gui.worldhandler.generic.on")}), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderWhitelist, (Object)WhitelistCommandBuilder.Label.ON)));
            container.m_142416_(new GuiButtonBase(x + 118, y + 72, 114, 20, (Component)Component.m_237110_((String)"gui.worldhandler.multiplayer.whitelist.whitelist", (Object[])new Object[]{Component.m_237115_((String)"gui.worldhandler.generic.off")}), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderWhitelist, (Object)WhitelistCommandBuilder.Label.OFF)));
            container.m_142416_(new GuiButtonIcon(x + 232 - 20, y + 24, 20, 20, EnumIcon.RELOAD, (Component)Component.m_237115_((String)"gui.worldhandler.multiplayer.whitelist.reload"), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderWhitelist, (Object)WhitelistCommandBuilder.Label.RELOAD)));
            if (this.playerField.m_94155_().isEmpty()) {
                button6.f_93623_ = false;
                button7.f_93623_ = false;
            }
            button5.f_93623_ = false;
        }
    }

    @Override
    public void tick(Container container) {
        if (Page.KICK_AND_BAN.equals((Object)this.page)) {
            this.reasonField.m_94120_();
        }
        if (!Page.RUNTIME.equals((Object)this.page)) {
            this.playerField.m_94120_();
        }
    }

    private void setPlayer(String player) {
        this.builderBan.targets().setTarget(player);
        this.builderKick.targets().setTarget(player);
        this.builderPardon.targets().setTarget(player);
        this.builderOp.targets().setTarget(player);
        this.builderDeop.targets().setTarget(player);
        this.builderWhitelist.targets().setTarget(player);
    }

    private void setReason(String reason) {
        this.builderBan.reason().set(reason);
        this.builderKick.reason().set(reason);
    }

    @Override
    public Category getCategory() {
        return Categories.MAIN;
    }

    @Override
    public MutableComponent getTitle() {
        return Component.m_237115_((String)"gui.worldhandler.title.multiplayer");
    }

    @Override
    public MutableComponent getTabTitle() {
        return Component.m_237115_((String)"gui.worldhandler.tab.multiplayer");
    }

    @Override
    public Content getActiveContent() {
        return Contents.MULTIPLAYER;
    }

    @Override
    public Content getBackContent() {
        return null;
    }

    public static enum Page {
        KICK_AND_BAN(0),
        PARDON(24),
        PERMISSIONS(14),
        RUNTIME(0),
        WHITELIST(0);

        private final int shift;

        private Page(int shift) {
            this.shift = shift;
        }

        public int getShift() {
            return this.shift;
        }
    }
}

